/***************************************************************************
                          listTabs.cpp  -  description
                             -------------------
    begin                :   2 21 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qregexp.h>
#include <qpixmap.h>
#include <qpainter.h>
#include <qbitmap.h>

// include files for KDE
#include <klocale.h>

// application specific includes
#include "system.h"
#include "option.h"
#include "docTables.h"
#include "listTabs.h"

static bool initPix = false;

static QPixmap* pmCron[4][2];
static QPixmap* pmAnac[4][2];
static QPixmap* pmAt[4][2];


extern QDateTime* g_CurTime;        // current time


/////////////////////////////////////////////////////////////////////////////
// TabLvi - List Tab's ListViewItem

//
// Destructor
TabLvi::~TabLvi()
{
#ifndef CRON_DILLON
  if ( dType == CRON_LOG || dType == ANACRON_LOG ){
    delete (LogTbl*)TblPtr;
  }
#endif
}

//
// Compare for Sort 0:DataType, 1:QDateTime
int TabLvi::compare( QListViewItem * i, int col, bool ascending ) const
{
  int ret;
  if ( col == 0 ){
    ret = dType - ((TabLvi*)i)->dType;
  }else if ( col == 1 ){
    if ( Next > ((TabLvi*)i)->Next) ret = 1;
    else  ret = -1;
  }else{
    ret = QListViewItem::compare( i, col, ascending );
  }

  return ret;
}


/////////////////////////////////////////////////////////////////////////////
// TabLvv - List Tab's ListView Common

//
// Constructor
TabLvw::TabLvw() : QListView()
{
  setAllColumnsShowFocus( 1 );
  setItemMargin( 4 );
  setShowSortIndicator( TRUE );
}

QPixmap* TabLvw::compPixmap( const QPixmap& p1, const QPixmap& p2 )
{
  QPixmap* p = new QPixmap(p1);
  
  QBitmap b = *p1.mask();
  bitBlt( &b, 0, 0, p2.mask(), 0, 0, p2.width(), p2.height(), OrROP, false );
  p->setMask( b );

  bitBlt( p, 0, 0, &p2, 0, 0, p2.width(), p2.height(), CopyROP, false );

  return p;
}


//
// Get Pixmap by Data Type & Modify Flag
const QPixmap TabLvw::pixmap(DATATYPE t, int f)
{

  if ( ! initPix ){
    QPixmap pCre( IconFile("create") );
    QPixmap pMod( IconFile("modify") );
    QPixmap pDel( IconFile("delete") );
    QPixmap pEdi( IconFile("edit") );

    pmCron[0][0] = new QPixmap( IconFile("cronicon") );
    pmAnac[0][0] = new QPixmap( IconFile("anacicon") );
    pmAt[0][0]   = new QPixmap( IconFile("aticon") );

    pmCron[1][0] = compPixmap( *pmCron[0][0], pCre );
    pmAnac[1][0] = compPixmap( *pmAnac[0][0], pCre );
    pmAt[1][0] = compPixmap( *pmAt[0][0], pCre );

    pmCron[2][0] = compPixmap( *pmCron[0][0], pMod );
    pmAnac[2][0] = compPixmap( *pmAnac[0][0], pMod );
    pmAt[2][0] = compPixmap( *pmAt[0][0], pMod );

//    pmCron[3] = new QPixmap( IconFile("cronicon_del").fullName );
    pmCron[3][0] = compPixmap( *pmCron[0][0], pDel );
    pmAnac[3][0] = compPixmap( *pmAnac[0][0], pDel );
    pmAt[3][0] = compPixmap( *pmAt[0][0], pDel );

    for ( int i=0; i<4; i++ ){
      pmCron[i][1] = compPixmap( *pmCron[i][0], pEdi );
      pmAnac[i][1] = compPixmap( *pmAnac[i][0], pEdi );
      pmAt[i][1] = compPixmap( *pmAt[i][0], pEdi );
    }

    initPix = true;
  }
  int e;
  if ( f & EDIT_CURRENT ) e = 1;
  else e = 0;
  QPixmap *p;
  switch( t ){
    case CRON:
#ifndef CRON_DILLON
    case CRON_LOG:
#endif
      if ( f & EDIT_DELETE ) p = pmCron[3][e];
      else if ( f & EDIT_CREATE ) p = pmCron[1][e];
      else if ( f & EDIT_MODIFY ) p = pmCron[2][e];
      else p = pmCron[0][e];
      break;
    case ANACRON:
#ifndef CRON_DILLON
    case ANACRON_LOG:
#endif
      if ( f & EDIT_DELETE ) p = pmAnac[3][e];
      else if ( f & EDIT_CREATE ) p = pmAnac[1][e];
      else if ( f & EDIT_MODIFY ) p = pmAnac[2][e];
      else p = pmAnac[0][e];
      break;
    default :
//    case AT:    
//    case AT_LOG:
      if ( f & EDIT_DELETE ) p = pmAt[3][e];
      else if ( f & EDIT_CREATE ) p = pmAt[1][e];
      else if ( f & EDIT_MODIFY ) p = pmAt[2][e];
      else p = pmAt[0][e];
  }
  return *p;

}

/////////////////////////////////////////////////////////////////////////////
// StngLvv - Setting List View

//
// Consurctor - Initialize Column
StngLvw::StngLvw() : TabLvw()
{
//  addColumn( i18n( "Type" ) );
  addColumn( "" );
  addColumn( i18n( "Time" ) );
  addColumn( i18n( "User" ) );
  addColumn( i18n( "Command" ) );
//  setSorting( 1 );
}

//
// Add 'cron' data
TabLvi *StngLvw::addItem( CronTbl *cr, const QDateTime& next)
{

  TabLvi *i = new TabLvi( this, cr, next );
  i->setPixmap( 0, pixmap(CRON,cr->Flag|cr->userTbl->Flag) );
  i->setText( 1, cr->Time );
#ifdef CRON_DILLON
  i->setText( 2, cr->User );
#else
  if ( cr->cronType == CRON_ETC ){
    i->setText( 2, "(" + cr->User + ")" );
  }else{
    i->setText( 2, cr->User );
  }
#endif
  i->setText( 3, cr->Cmnd );
  return i;

}

//
// Add 'anacron' data
TabLvi *StngLvw::addItem( AnacTbl *an, const QDateTime& next )
{

  TabLvi *i = new TabLvi( this, an, next );
  i->setPixmap( 0, pixmap(ANACRON,an->Flag|an->userTbl->Flag) );
  i->setText( 1, QString().sprintf( "%d - %d", an->Prod, an->Dlay ) );
  i->setText( 2, "-" );
  i->setText( 3, an->Cmnd );
  return i;

}

//
// Add 'at' data
TabLvi *StngLvw::addItem( AtTbl *at )
{

  TabLvi *i = new TabLvi( this, at );
  i->setPixmap( 0, pixmap(AT,at->Flag) );
  i->setText( 1, at->Time.toString( "yy-MM-dd hh:mm" ) );
  i->setText( 2, at->User );
  i->setText( 3, at->Cmnd.section( "\n", 0, 0 ) );
  return i;

}

//
// get ListViewItem from Table Data
TabLvi *StngLvw::getItem( void* ptr )
{

  for ( QListViewItemIterator it( this ); it.current(); ++it ){
    TabLvi *i = (TabLvi*)it.current();
    if ( i->TblPtr == ptr ){
      return i;
    }
  }

  return NULL;
}

//
// Reset All Pixmap from Modify Flag
void StngLvw::resetFlag()
{
  for ( QListViewItemIterator it( this ); it.current(); ++it ){
    TabLvi *i = (TabLvi*)it.current();
    if ( i->dType == CRON ){
      CronTbl* c = i->cronTbl();
      i->setPixmap( 0, pixmap(CRON,c->Flag|c->userTbl->Flag) );
    }else if ( i->dType == ANACRON ){
      AnacTbl* a = i->anacTbl();
      i->setPixmap( 0, pixmap(ANACRON,a->Flag|a->userTbl->Flag) );
    }else{
      AtTbl* a = i->atTbl();
      i->setPixmap( 0, pixmap(AT,a->Flag) );
    }
  }
}

/////////////////////////////////////////////////////////////////////////////
// ExecLvv - Execute List View

//
// Consurctor - Initialize Column
ExecLvw::ExecLvw() : TabLvw()
{
//  addColumn( i18n( "Type" ) );
  addColumn( "" );
  addColumn( i18n( "Execute Time" ) );
  addColumn( i18n( "Time" ) );
  addColumn( i18n( "User" ) );
  addColumn( i18n( "Command" ) );
//  setSorting( 1 );
}

//
// Add 'cron' data
void ExecLvw::addItem( CronTbl *cr, const QDateTime& next )
{

  TabLvi *i = new TabLvi( this, cr, next );
  i->setPixmap( 0, pixmap(CRON,cr->Flag) );
  i->setText( 1, next.toString( "yy-MM-dd(ddd) hh:mm" ) );
  i->setText( 2, cr->Time );
#ifdef CRON_DILLON
    i->setText( 3, cr->User );
#else
  if ( cr->cronType == CRON_ETC ){
    i->setText( 3, "(" + cr->User + ")" );
  }else{
    i->setText( 3, cr->User );
  }
#endif
  i->setText( 4, cr->Cmnd );

}

//
// Add 'anacron' data
void ExecLvw::addItem( AnacTbl *an, const QDateTime& next )
{

  TabLvi *i = new TabLvi( this, an, next );
  i->setPixmap( 0, pixmap(ANACRON,an->Flag) );
  i->setText( 1, next.toString( "yy-MM-dd(ddd) hh:mm" ) );
  i->setText( 2, QString().sprintf("%d - %d", an->Prod, an->Dlay) );
  i->setText( 3, "-" );
  i->setText( 4, an->Cmnd );

}

//
// Add 'at' data
void ExecLvw::addItem( AtTbl *at )
{

  TabLvi *i = new TabLvi( this, at );
  i->setPixmap( 0, pixmap(AT,at->Flag) );
  i->setText( 1, i->Next.toString( "yy-MM-dd(ddd) hh:mm" ) );
  i->setText( 2, at->Time.toString( "yy-MM-dd hh:mm" ) );
  i->setText( 3, at->User );
  i->setText( 4, at->Cmnd.section( "\n", 0, 0 ) );

}

//
// Reset All Pixmap from Modify Flag
void ExecLvw::resetFlag()
{

  for ( QListViewItemIterator it( this ); it.current(); ++it ){
    TabLvi *i = (TabLvi*)it.current();
    if ( i->dType == CRON ){
      CronTbl* c = i->cronTbl();
      i->setPixmap( 0, pixmap(CRON,c->Flag|c->userTbl->Flag) );
    }else if ( i->dType == ANACRON ){
      AnacTbl* a = i->anacTbl();
      i->setPixmap( 0, pixmap(ANACRON,a->Flag|a->userTbl->Flag) );
    }else{
      AtTbl* a = i->atTbl();
      i->setPixmap( 0, pixmap(AT,a->Flag) );
    }
  }
}
#ifndef CRON_DILLON

/////////////////////////////////////////////////////////////////////////////
// LogLvv - Log List View

//
// Consurctor - Initialize Column
LogLvw::LogLvw() : TabLvw()
{
  addColumn( "" );
//  addColumn( i18n( "Type" ) );
  addColumn( i18n( "Execute Time" ) );
  addColumn( i18n( "User" ) );
  addColumn( i18n( "Action" ) );
//  setSorting( 1, FALSE );
//  setShowSortIndicator( TRUE );
}

//
// Add log data
void LogLvw::addItem( LogTbl *log )
{
  TabLvi *i = new TabLvi( this, log );
  i->setPixmap( 0, pixmap(i->dType,0) );
  i->setText( 1, log->Time.toString( "yy-MM-dd(ddd) hh:mm:ss") );
  i->setText( 2, log->User );
  i->setText( 3, log->LogStr );
}
#endif
