/***************************************************************************
                          runeDlg.cpp  -  description
                             -------------------
    begin                :   2 3 2003
    copyright            : (C) 2003 by k-kobayashi
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/
//using namespace std;
//#include <iostream>

// include files for Qt
#include <qlayout.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qdatetime.h>
#include <qpainter.h>

////////////////////////// TEST
//#include <qfont.h>
//#include <qfontdialog.h>
//////////////////////////


// include files for KDE
#include <klocale.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kseparator.h>
//#include <kdialogbase.h>


// application specific includes
#include "option.h"
#include "system.h"
#include "runeDlg.h"

QString RuneDlg::getRText( int n )
{
  QString s;
  switch( n ){
  case 0: s = i18n("FEOH\n success:\n something you have been striving for\n is within reach."); break;
  case 1: s = i18n("URAZ\n wild ox:\n strength and good health,\n resistance to disease."); break;
  case 2: s = i18n("THRISAZ\n points to good luck:\n usualally from an unexpected source."); break;
  case 3: s = i18n("RAIDHO\n wagon:\n indication of travel and safe trip,\n journey of the soul."); break;
  case 4: s = i18n("KANUZ\n fire:\n illumination, creatively,\n good for artists and craftspeaple."); break;
  case 5: s = i18n("GIFU\n primary rune of love and secuality:\n forecasts success in love."); break;
  case 6: s = i18n("EIHWAZ\n tree from whcich they made weapons,\n primary rune of protection."); break;
  case 7: s = i18n("SIGEL\n will, secf-confidence,\n power to make positive changes\n in your life."); break;
  case 8: s = i18n("TIRE\n rune of victory and\n motivations,\n points to success in competition."); break;
  default: s = i18n("DEGAZ\n rune of the new day,\n points to fresh start,\n growth & prosperity."); break;
  }
  return s;

}

RuneDlg::RuneDlg( bool rs, QWidget *parent, const char *name )
  : KDialog( parent, name, false )
{

  runOnStart = rs;
  curRune = QDate::currentDate().day() % 10;
  
  setCaption(i18n("Rune of the Day - by zippo rune series"));

  QVBoxLayout *vbox = new QVBoxLayout(this, marginHint(), spacingHint());
  {

    QHBoxLayout *hbox = new QHBoxLayout(vbox, 0, 0);
    {
      runeLbl = new QLabel(this);
      QString fn = QString( "rune%1" ).arg( curRune+1 );
      runeLbl->setPixmap( IconFile( fn ) );
      hbox->addWidget(runeLbl);
    }
    {
      QLabel *titlePane = new QLabel(this);
      titlePane->setText(i18n(" Today's Rune Character \n"));
      titlePane->setBackgroundPixmap( IconFile("rune_background")) ;
      titlePane->setFont(QFont(KGlobalSettings::generalFont().family(), 20,  QFont::Bold));
      titlePane->setAlignment(QLabel::AlignCenter);
      titlePane->setFixedWidth( 350 );
      hbox->addWidget(titlePane,100);
    }
  }
  {
    textView = new QTextView(this);
    vbox->addWidget(textView);
    textView->setFont(QFont(KGlobalSettings::generalFont().family(), 12,  QFont::Bold));
    textView->setText( getRText(curRune) );
//    setMinimumWidth( 350 );
  }
  {
    KSeparator* sep = new KSeparator( KSeparator::HLine, this);
    vbox->addWidget(sep);
  }
  {
    QHBoxLayout *hbox = new QHBoxLayout(vbox);
    {
      QCheckBox* ckb = new QCheckBox(i18n("&Show on start"), this);
      hbox->addWidget(ckb);
      hbox->addStretch();
      ckb->setChecked(runOnStart);
      connect(ckb, SIGNAL(toggled(bool)), this, SLOT(slotRunOnStart(bool)));
    }
    {
      QPushButton *next = new QPushButton(i18n("&Next"), this);
      hbox->addWidget(next);
      connect(next, SIGNAL(clicked()), this, SLOT(slotNext()));
    }
    {
      QPushButton *ok = new QPushButton(i18n("&Ok"), this);
      hbox->addWidget(ok);
      ok->setDefault(true);
      connect(ok, SIGNAL(clicked()), this, SLOT(accept()));
    }
  }

}

RuneDlg::~RuneDlg()
{
}

void RuneDlg::slotNext()
{

  curRune++;
  if ( curRune >= 10 ) curRune = 0;
  QString fn = QString( "rune%1" ).arg( curRune+1 );
  runeLbl->setPixmap( IconFile( fn ) );
  textView->setText( getRText(curRune) );

  //
#if 0
    bool ok;
    QFont font = QFontDialog::getFont(
                    &ok, QFont( "Helvetica [Cronyx]", 10 ), this );
    if ( ok ) {
        // font is set to the font the user selected
        cout << "Font = " << font.toString() << endl;
        
    } else {
        // the user cancelled the dialog; font is set to the initial
        // value, in this case Helvetica [Cronyx], 10
    }
    //
#endif


}

void RuneDlg::slotRunOnStart( bool b )
{
  runOnStart = b;
}

