/***************************************************************************
                          viewTabs.cpp  -  description
                             -------------------
    begin                :   2 21 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>
#include <unistd.h>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qtextedit.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qdatetimeedit.h>
#include <qpainter.h>
#include <qframe.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qtextview.h>
#include <qregexp.h>
#include <qlayout.h>

// include files for KDE
#include <klocale.h>
#include <kseparator.h>

// application specific includes
#include "system.h"
#include "option.h"
#include "docTables.h"
#include "commonWgt.h"
#include "varDlg.h"
#include "timeDlg.h"
#include "clockView.h"
#include "viewTabs.h"

extern QDateTime* g_CurTime;
extern Option*    g_Option;
extern int        g_SecsNext;

/////////////////////////////////////////////////////////////////////////////
// TimeLabel - LCD Time Label

//
// Constructor
TimeLabel::TimeLabel(QWidget *p) : QLCDNumber(17, p)
{

  setFrameShape( QFrame::StyledPanel );
  setFrameShadow( QFrame::Sunken );
  setSizePolicy( QSizePolicy((QSizePolicy::SizeType)7, (QSizePolicy::SizeType)7, 0, 0,
        sizePolicy().hasHeightForWidth() ) );
  setMinimumHeight( 38 );
  setSegmentStyle( Filled );
}

//
// Display Rest Time
void TimeLabel::dspTime( int sec )
{

  //
  // Set Time String
  QString s;
  QString flg( "" );  // init minus flag
  // minus second -- log time
  if ( sec < 0 ){
    sec = sec * -1;
    flg = "-";        // set minus flag
  }
//  sec++;

  // set string - "dd hh-mm-ss" ( supress string )  
  int m = sec / 60;
  if ( m > 0 ){
    sec = sec % 60;
    int h = m / 60;
    if ( h > 0  && g_Option->restMode != 3 ){
      m = m % 60;
      int d = h / 24;
      if ( d > 0 && g_Option->restMode != 2 ){
        h = h % 24;
        s.sprintf( "%d %02d:%02d:%02d", d, h, m, sec );
      }else{
        s.sprintf( "%02d:%02d:%02d", h, m, sec );
      }
    }else{
      s.sprintf( "%02d:%02d", m, sec );
    }
  }else{
    s.sprintf( "%02d", sec );
  }

  // Display Time
  display( flg + s );
}

/////////////////////////////////////////////////////////////////////////////
// ClockWgt - Clock Display Tab

//
// Constructor
ClockWgt::ClockWgt() : QWidget()
{

  QVBoxLayout *l = new QVBoxLayout( this );
  {
    // Clock View
    clockView = new ClockView(this);
    l->addWidget( clockView );

    // Time LCD Label
    QGridLayout *g = new QGridLayout( l, 4, 4, 5 );
    {
      g->addRowSpacing( 0, 7 );
      g->addColSpacing( 0, 7 );
      g->addWidget( new QLabel( i18n("Current"), this ), 1, 1 );
      g->addWidget( new QLabel( i18n("Execute"), this ), 2, 1 );
      g->addWidget( new QLabel( i18n("Remain"), this ), 3, 1 );
      lblCur = new TimeLabel(this);
      g->addWidget( lblCur, 1, 2 );
      lblNext = new TimeLabel(this);
      g->addWidget( lblNext, 2, 2 );
      lblRest = new TimeLabel(this);
      g->addWidget( lblRest, 3, 2 );
      g->addRowSpacing( 4, 7 );
      g->addColSpacing( 3, 7 );
    }
    // Stretch
    l->addStretch();
  }

  // Next Execute can't display
  nextTime = NULL;

}

//
// Display 'cron' time
void ClockWgt::dspClock( CronTbl *cr, QDateTime*  t )
{
  lblNext->dspTime( t );
  nextTime = t;
  dspCurTime();
  clockView->iniClock( cr, t );

}

//
// Diaplay 'anacron' time
void ClockWgt::dspClock( AnacTbl *an, QDateTime*  t )
{

  lblNext->dspTime( t );
  nextTime = t;
  dspCurTime();
  clockView->iniClock( an, t );

}

//
// Display 'at' & Log gtime
void ClockWgt::dspClock( QDateTime*  t )
{

  lblNext->dspTime( t );
  nextTime = t;
  dspCurTime();
  clockView->iniClock( t );

}

//
// Clear Next and Rest Time
void ClockWgt::clrClock()
{
  nextTime = NULL;
  lblNext->clrTime( );
  lblRest->clrTime();
  dspCurTime();
  clockView->iniClock( NULL );
}

//
// Display Current Time
void ClockWgt::dspCurTime()
{
  if ( nextTime ){
    // Display Rest Time
    g_SecsNext = g_CurTime->secsTo( *nextTime );
    lblRest->dspTime( g_SecsNext );
  }
  lblCur->dspTime( g_CurTime );
  clockView->drawTime();      // Draw Clock Second
}

/////////////////////////////////////////////////////////////////////////////
// DetailWgt - Detail Display Tab

//
// Constructor
DetailWgt::DetailWgt() : QWidget()
{
//  QVBoxLayout *l = new QVBoxLayout( this, 5, 5 );
  QVBoxLayout *l = new QVBoxLayout( this );
  {
    // Text View
    textView = new QTextView( this );
    textView->setLineWidth( 1 );
    // Set backgroud
    textView->setPaper( QBrush( "WhiteSmoke" ) );
  }
  l->addWidget( textView );

  // Get template
  cronText    = DetailFile( "CronDetail" ).readDetail();
  anacText    = DetailFile( "AnacDetail" ).readDetail();
  atText      = DetailFile( "AtDetail" ).readDetail();
  logCronText = DetailFile( "LogCronDetail" ).readDetail();
  logAnacText = DetailFile( "LogAnacDetail" ).readDetail();
  logAtText   = DetailFile( "LogAtDetail" ).readDetail();

}

//
// Display 'cron' data
void DetailWgt::dspText( CronTbl* c, const QDateTime& selt )
{

  QString s;
  QString str = cronText;

  // Replace File Name
#ifdef CRON_DILLON
  str.replace( QRegExp( "__FILE__" ), g_Option->cronPathSpool + "/" + c->User );
#else
  if ( c->cronType == CRON_USER ) s = g_Option->cronPathSpool + "/" + c->User;
  else                            s = g_Option->cronFileSys;
  str.replace( QRegExp( "__FILE__" ), s );
#endif

  // Replace Headder Comment
  s = c->userTbl->Head;
  s.replace( QRegExp( "\\n$" ), "" );
  s.replace( QRegExp( "\\n" ), "<br>" );
  str.replace( QRegExp( "__HEAD__" ), s );

  // Replace 'cron' Time
  str.replace( QRegExp( "__TIME__" ), c->Time );
  // Replace 'cron' User
  str.replace( QRegExp( "__USER__" ), c->User );
  // Replace 'cron' Command
  str.replace( QRegExp( "__CMND__" ), c->Cmnd );
  // Replace 'cron' Comment
  s = c->Cmnt;
  s.replace( QRegExp( "\\n" ), "<br>" );
  str.replace( QRegExp( "__CMNT__" ), s );
  
  // Replace 'cron' Environment variable
  QString slst = str.section( "__ENVLIST__", 1, 1 );
  QString estr = "";
  for( VarTbl* v=c->userTbl->Vars->first(); v; v=c->userTbl->Vars->next() ){
    s = slst;
    s.replace( QRegExp( "__ENVNAM__"), v->Name );
    s.replace( QRegExp( "__ENVVAL__"), v->Val );
    estr = estr + s + "\n";
  }
  str.replace( QRegExp( "__ENVLIST__*__ENVLIST__", true, true ) , estr );

  // Replace Execute Time Data
  slst = str.section( "__TIMLIST__", 1, 1 );
  QDateTime tc = *g_CurTime;
  QDateTime tw;
  estr = "";
  CronTime  ct( c );
  int flg = 0;
  int i = 0;
  for( i=0; i<5; i++ ){
    tw = ct.GetNextTime( tc );
    s = slst;
    s.replace( QRegExp( "__TIMCNT__"), QString().setNum(i+1) );
    s.replace( QRegExp( "__TIMNXT__"), tw.toString( "yy-MM-dd(ddd) hh:mm" ) );
    if ( tw == selt ){
      s.replace( QRegExp( "blue" ), "red" );
      flg = 1;
    }
    tc = tw;
    estr = estr + s + "\n";
  }
  QString ds = slst;
  ds.replace( QRegExp( "__TIMCNT__"), "..." );
  ds.replace( QRegExp( "__TIMNXT__"), "....." );
  if ( flg == 0 ){
    while( true ){
      tw = ct.GetNextTime( tc );
      if ( tw == selt ) break;
      i++;
      if ( tw > selt ) break;
      tc = tw;
    }
    if ( i > 5 ){
      estr = estr + ds + "\n";
    }
    if ( tw == selt ){
      s = slst;
      s.replace( QRegExp( "blue" ), "red" );
      s.replace( QRegExp( "__TIMCNT__"), QString().setNum(i+1) );
      s.replace( QRegExp( "__TIMNXT__"), tw.toString( "yy-MM-dd(ddd) hh:mm" ) );
      estr = estr + s + "\n";
    }
  }
  estr = estr + ds + "\n";
  str.replace( QRegExp( "__TIMLIST__*__TIMLIST__", true, true ), estr );

  // Set Text View
  textView->setText( str );
}

//
// Display 'anacron' data
void DetailWgt::dspText( AnacTbl* n, const QDateTime& selt )
{

  QString str = anacText;
  QString s;

  // Replace File Name
  str.replace( QRegExp( "__FILE__" ), g_Option->anacFileSys );
  // Replace headder comment
  s = n->userTbl->Head;
  s.replace( QRegExp( "\\n$" ), "" );
  s.replace( QRegExp( "\\n" ), "<br>" );
  str.replace( QRegExp( "__HEAD__" ), s );
  // Replace Period
  str.replace( QRegExp( "__PERIOD__" ), QString().setNum(n->Prod) );
  // Replace Delay Time
  str.replace( QRegExp( "__DELAY__" ), QString().setNum(n->Dlay) );
  // Replace Ident
  str.replace( QRegExp( "__IDENT__" ), n->Idnt );
  // Replace previous Execute Time
  str.replace( QRegExp( "__PREV__" ), n->Mtim.toString( "yyyy-MM-dd(ddd) hh:mm" ) );
  // Replace Command
  str.replace( QRegExp( "__CMND__" ), n->Cmnd );
  // Replace Comment
  s = n->Cmnt;
  s.replace( QRegExp( "\\n" ), "<br>" );
  str.replace( QRegExp( "__CMNT__" ), s );

  // Replace Environment Variable
  QString slst = str.section( "__ENVLIST__", 1, 1 );
  QString estr = "";
  for( VarTbl* v=n->userTbl->Vars->first(); v; v=n->userTbl->Vars->next() ){
    s = slst;
    s.replace( QRegExp( "__ENVNAM__"), v->Name );
    s.replace( QRegExp( "__ENVVAL__"), v->Val );
    estr = estr + s + "\n";
  }
  str.replace( QRegExp( "__ENVLIST__*__ENVLIST__", true, true ), estr );

  // Replace Execute Time
  slst = str.section( "__TIMLIST__", 1, 1 );

  QDateTime   tc = *g_CurTime;
  QDateTime   tw;
  estr = "";
  CronTime  ct( n );
  int flg = 0;
  int i = 0;
  for( i=0; i<5; i++ ){
    tw = ct.GetNextTime( tc );
    s = slst;
    s.replace( QRegExp( "__TIMCNT__"), QString().setNum(i+1) );
    s.replace( QRegExp( "__TIMNXT__"), tw.toString( "yyyy-MM-dd(ddd) hh:mm" ) );
    if ( tw == selt ){
      s.replace( QRegExp( "blue" ), "red" );
      flg = 1;
    }
    tc = tw;
    estr = estr + s + "\n";
  }
  QString ds = slst;
  ds.replace( QRegExp( "__TIMCNT__"), "..." );
  ds.replace( QRegExp( "__TIMNXT__"), "....." );
  if ( flg == 0 ){
    while( true ){
      tw = ct.GetNextTime( tc );
      if ( tw == selt ) break;
      i++;
      if ( tw > selt ) break;
      tc = tw;
    }
    if ( i > 5 ){
      estr = estr + ds + "\n";
    }
    if ( tw == selt ){
      s = slst;
      s.replace( QRegExp( "blue" ), "red" );
      s.replace( QRegExp( "__TIMCNT__"), QString().setNum(i+1) );
      s.replace( QRegExp( "__TIMNXT__"), tw.toString( "yyyy-MM-dd(ddd) hh:mm" ) );
      estr = estr + s + "\n";
    }
  }
  estr = estr + ds + "\n";
  str.replace( QRegExp( "__TIMLIST__*__TIMLIST__", true, true), estr );

  // Set Text View
  textView->setText( str );
}

//
// Display 'at' data
void DetailWgt::dspText( AtTbl* a )
{

  QString str = atText;

  QString s;
  // Replace 'at' Time
  str.replace( QRegExp( "__TIME__" ), a->Time.toString( "yyyy-MM-dd(ddd) hh:mm" ) );
  // Replace Job No
  str.replace( QRegExp( "__JOB__" ), QString().setNum(a->Jno) );
  // Replace Queue Level
  str.replace( QRegExp( "__QLEVEL__" ), QString(QChar(a->Qno)) );
  // Replace User Name
  str.replace( QRegExp( "__USER__" ), a->User );
  // Replace Mail ON/OFF
  if ( a->Mail ) str.replace( QRegExp( "__MAIL__" ), "ON" );
  else           str.replace( QRegExp( "__MAIL__" ), "OFF" );
  // Replace Command
  s = a->Cmnd;
  s.replace( QRegExp( "\\n$" ), "" );
  s.replace( QRegExp( "\\n" ), "<br>" );
  str.replace( QRegExp( "__CMND__" ), s );
  // Replace Execute Time
  str.replace( QRegExp( "__TIMNXT__"), a->Time.toString( "yyyy-MM-dd(ddd) hh:mm" ) );

  // Set Text View
  textView->setText( str );
}

#ifndef CRON_DILLON
//
// Display Log data
void DetailWgt::dspText( LogTbl* log )
{

  QString str;
  if ( log->dType == CRON_LOG ){
    str = logCronText;
  }else if ( log->dType == ANACRON_LOG ){
    str = logAnacText;
  }else{
    str = logAtText;
  }
  // Executed Time
  str.replace( QRegExp( "__TIME__" ), log->Time.toString( "yyyy-MM-dd(ddd) hh:mm" ) );
  // Host Name
  str.replace( QRegExp( "__HOST__" ), log->Host );
  // Process ID
  str.replace( QRegExp( "__PID__" ), QString().setNum( log->Pid ) );
  // Program ('cron'/'anacron' )
  str.replace( QRegExp( "__PRG__" ), log->Prog );
  // Replace User Name
  str.replace( QRegExp( "__USER__" ), log->User );
  // Event
  str.replace( QRegExp( "__EVENT__" ), log->LogStr );

  // Set Text View
  textView->setText( str );
}

#endif

/////////////////////////////////////////////////////////////////////////////
// EdiiWgt - Edit Tab Comman Class

//
// Constructor
EditWgt::EditWgt() : QWidget()
{
  QVBoxLayout* v = new QVBoxLayout( this );
  {
    Frame = new QFrame( this );
    Frame->setFrameShape( QFrame::StyledPanel );
    Frame->setFrameShadow( QFrame::Sunken );
    v->addWidget( Frame );
  }
  {
    QHBoxLayout* h = new QHBoxLayout( v, 0 );

    modBtn = new QPushButton( QIconSet( IconFile( "modifybtn" ) ), trUtf8( "Modify" ), this );
    h->addWidget( modBtn );

    creBtn = new QPushButton( QIconSet( IconFile( "createbtn" ) ), trUtf8( "Create" ), this );
    h->addWidget( creBtn );

    delBtn = new QPushButton( QIconSet( IconFile( "deletebtn" ) ), trUtf8( "Delete" ), this );
    h->addWidget( delBtn );

    exeBtn = new QPushButton( QIconSet( IconFile( "execbtn" ) ), trUtf8( "Exec" ), this );
    h->addWidget( exeBtn );
  }
}

//
// Set button Enable/Disable
void EditWgt::setEnable( bool bWrite, bool bMod, bool bNew, bool bExe )
{
  bool m=true, c=true, d=true;

  if ( bWrite ){
    // Modify Enable
    if ( bMod ){
      // Modified
      d = false;
      if ( bNew ) m = false;
    }else{
      m = false;
      if ( ! bNew ) c = false;
      else          d = false;
    }
  }else{
    m = false;
    c = false;
    d = false;
  }

  modBtn->setEnabled( m );
  creBtn->setEnabled( c );
  delBtn->setEnabled( d );
  exeBtn->setEnabled( bExe );
  
}


/////////////////////////////////////////////////////////////////////////////
// CronEditWgt - 'cron' Edit Tab

//
// Constructor
CronEditWgt::CronEditWgt() : EditWgt()
{

  QGridLayout* l = new QGridLayout( Frame, 7, 3, 10, 10 );
  int i = 0;

  { // Time
    l->addWidget( new QLabel( i18n("Time"), Frame ), i, 0 );
    timLed = new QLineEdit( Frame );
    l->addWidget( timLed, i, 1 );
    timBtn = new IconPushButton( "edfilicon", Frame );
    l->addWidget( timBtn, i, 2 );
    i++;
  }
  { // User
    l->addWidget( new QLabel( i18n("User"), Frame ), i, 0 );
    usrCmb = new UserComboBox ( Frame );
    l->addMultiCellWidget( usrCmb, i, i, 1, 2 );
//    l->addWidget( usrCmb, i, 1 );
    i++;
  }
  { // Command Label
    l->addWidget( new QLabel( i18n("Command"), Frame ), i, 0 );
    i++;
  }
  { // Command Input Text
    cmdLed = new QLineEdit( Frame );
    l->addMultiCellWidget( cmdLed, i, i, 0, 2 );
    i++;
  }
  { // Comment Label
    l->addWidget( new QLabel( i18n("Comment"), Frame ), i, 0 );
    i++;
  }
  { // Comment Input Text
    cmtTed = new QTextEdit( Frame );
    cmtTed->setWordWrap( QTextEdit::NoWrap );
    cmtTed->setMinimumSize( QSize( 0, 30 ) );
    l->addMultiCellWidget( cmtTed, i, i, 0, 2 );
    i++;
  }
  {
    QFrame *f = new QFrame( this );
    f->setFrameShape( QFrame::StyledPanel );
    f->setFrameShadow( QFrame::Sunken );
    l->addMultiCellWidget( f, i, i, 0, 2 );
    i=0;
    QGridLayout* ll = new QGridLayout( f, 2, 3, 10, 10 );
    { // File Name
      ll->addWidget( new QLabel( i18n("File"), f ), i, 0 );
#ifndef CRON_DILLON
      filCmb = new FileComboBox( f );
      ll->addWidget( filCmb, i, 1 );
#endif
      varBtn = new IconPushButton( "edfilicon", f );
      varBtn->setFixedSize( varBtn->sizeHint() );
      ll->addWidget( varBtn, i, 2 );

      i++;
    }
    { // Variables
      ll->addWidget( new QLabel( i18n("Variable"), f ), i, 0 );
      varLvw = new VarListView( f );
      ll->addWidget( varLvw, i, 1 );
//      ll->addMultiCellWidget( varLvw, i, i, 1, 2 );
//      varBtn = new IconPushButton( "edfilicon", f );
//      ll->addWidget( varBtn, i, 2 );
      i++;
    }
  }

  // Editing 'cron' data
  editCron = new CronTbl();

  setEnabled( false );


}

//
// Initialize from 'cron' data
void CronEditWgt::iniEdit( CronTbl *cr )
{

  setEnabled( true );

  timLed->setText( cr->Time );    // Time
  cmdLed->setText( cr->Cmnd );    // Command
  cmtTed->setText( cr->Cmnt );    // Comment

  // Variables
  varLvw->setVar(cr->userTbl->Vars);

#ifdef CRON_DILLON
  // User Cron
  if ( System::uid() == 0 ){
    // root user can edit all user
    usrCmb->setUser( UserComboBox::AllowCron );
  }else{
    usrCmb->setUser( UserComboBox::Current );
  }
#else
  // File Combo Box
  filCmb->iniFile( cr->User, cr->cronType );

  if ( cr->cronType == CRON_ETC ){
    // System Cron
    usrCmb->setUser( UserComboBox::All );
  }else{
    // User Cron
    if ( System::uid() == 0 ){
      // root user can edit all user
      usrCmb->setUser( UserComboBox::AllowCron );
    }else{
      usrCmb->setUser( UserComboBox::Current );
    }
  }
#endif
//  filCmb->setCurrent( cr->cronType );
  usrCmb->setCurrentText( cr->User );

  // Editing data
  *editCron = *cr;
  setButton( *cr );

}

//
// Set Action Button
void CronEditWgt::setButton( const CronTbl& chk )
{

  bool w, m, n, e;

  w = true;
  e = true;
#ifdef CRON_DILLON
  if (   chk.User     != editCron->User     ||
         chk.Time     != editCron->Time     ||
         chk.Cmnd     != editCron->Cmnd     ||
         chk.Cmnt     != editCron->Cmnt     ||
         chk.userTbl  != editCron->userTbl ){
#else
  if ( editCron->cronType == CRON_ETC && System::uid() != 0 ){
    if ( ! ( System::isCronWritable() ) ) w = false;
    e = false;
  }
  if ( chk.cronType != editCron->cronType ||
         chk.User     != editCron->User     ||
         chk.Time     != editCron->Time     ||
         chk.Cmnd     != editCron->Cmnd     ||
         chk.Cmnt     != editCron->Cmnt     ||
         chk.userTbl  != editCron->userTbl ){
#endif
    m = true;
  }else{
    m = false;
  }
  if ( chk.Flag & ( EDIT_DELETE | EDIT_NEW ) ) {
    n = true;
  }else{
    n = false;
  }
      
  setEnable( w, m, n, e );
}

/////////////////////////////////////////////////////////////////////////////
// AnacEditWgt - 'anacron' Edit Tab

//
// Constructor
AnacEditWgt::AnacEditWgt() : EditWgt()
{

  QGridLayout* l = new QGridLayout( Frame, 8, 3, 10, 10 );
  int i = 0;

  { // Period
    l->addWidget( new QLabel( i18n("Period(Day)"), Frame ), i, 0 );
    prdSpb = new QSpinBox( Frame );
    l->addMultiCellWidget( prdSpb, i, i, 1, 2 );
    i++;
  }
  { // Delay Time
    l->addWidget( new QLabel( i18n("Delay(Min)"), Frame ), i, 0 );
    dlySpb = new QSpinBox( Frame );
    l->addMultiCellWidget( dlySpb, i, i, 1, 2 );
    i++;
  }
  { // Identifier
    l->addWidget( new QLabel( i18n("Identifier"), Frame ), i, 0 );
    idtLed = new QLineEdit( Frame );
    l->addMultiCellWidget( idtLed, i, i, 1, 2 );
    i++;
  }
  { // Command Label
    l->addWidget( new QLabel( i18n("Command"), Frame ), i, 0 );
    i++;
  }
  { // Command Input Text
    cmdLed = new QLineEdit( Frame );
    l->addMultiCellWidget( cmdLed, i, i, 0, 2 );
    i++;
  }
  { // Comment Label
    l->addWidget( new QLabel( i18n("Comment"), Frame ), i, 0 );
    i++;
  }
  { // Comment Input Text
    cmtTed = new QTextEdit( Frame );
    cmtTed->setWordWrap( QTextEdit::NoWrap );
    cmtTed->setMinimumSize( QSize( 0, 30 ) );
    l->addMultiCellWidget( cmtTed, i, i, 0, 2 );
    i++;
  }

  {
    QFrame *f = new QFrame( this );
    f->setFrameShape( QFrame::StyledPanel );
    f->setFrameShadow( QFrame::Sunken );
    l->addMultiCellWidget( f, i, i, 0, 2 );
    i=0;
    QGridLayout* ll = new QGridLayout( f, 2, 3, 10, 10 );
    { // File Name
      ll->addWidget( new QLabel( i18n("File"), f ), i, 0 );
      ll->addWidget( new FrameLabel( g_Option->anacFileSys, f ), i, 1 );
      varBtn = new IconPushButton( "edfilicon", f );
      varBtn->setFixedSize( varBtn->sizeHint() );
      ll->addWidget( varBtn, i, 2 );

      i++;
    }
    { // Variables
      ll->addWidget( new QLabel( i18n("Variable"), f ), i, 0 );
      varLvw = new VarListView( f );
      ll->addWidget( varLvw, i, 1 );
      i++;
    }
  }

  editAnac = new AnacTbl();
  setEnabled( false );

}

//
// Initialize from 'anacron' data
void AnacEditWgt::iniEdit( AnacTbl *an )
{

  setEnabled( true );

  cmdLed->setText( an->Cmnd );
  cmtTed->setText( an->Cmnt );
  idtLed->setText( an->Idnt );

  varLvw->setVar(an->userTbl->Vars);

  dlySpb->setValue( an->Dlay );
  prdSpb->setValue( an->Prod );
  *editAnac = *an;
  setButton( *an );
}

//
// Set Action Button
void AnacEditWgt::setButton( const AnacTbl& chk )
{

  bool w, m, n, e;

  w = true;
  // 'anacrontab' file access check
  if ( ! System::isAnacWritable() ){
    w = false;
  }

  // Execute Check
  if ( System::uid() == 0 ) e = true;
  else                      e = false;

  // Change Check
  if ( chk.Prod  != editAnac->Prod ||
       chk.Dlay  != editAnac->Dlay ||
       chk.Idnt  != editAnac->Idnt ||
       chk.Cmnd  != editAnac->Cmnd ||
       chk.Cmnt  != editAnac->Cmnt ){
    m = true;
  }else{
    m = false;
  }

  // New Data?
  if ( chk.Flag & ( EDIT_DELETE | EDIT_NEW ) ) {
    n = true;
  }else{
    n = false;
  }

  setEnable( w, m, n, e );


}

/////////////////////////////////////////////////////////////////////////////
// AtEditWgt - 'at' Edit Tab

//
// Constructor
AtEditWgt::AtEditWgt() : EditWgt()
{

  QGridLayout* l = new QGridLayout( Frame, 5, 3, 10, 10 );
  int i = 0;
  { // Time
    l->addWidget( new QLabel( i18n("Time"), Frame ), i, i );
    timLed = new QLineEdit( Frame );
    l->addWidget( timLed, i, 1 );
    timBtn = new IconPushButton( "edfilicon", Frame );
    l->addWidget( timBtn, i, 2 );
    i++;
  }
  { // User
    l->addWidget( new QLabel( i18n("User"), Frame ), i, 0 );
    usrLbl = new FrameLabel( "", Frame );
    l->addMultiCellWidget( usrLbl, i, i, 1, 2 );
    i++;
  }
  { // Queue Level
    l->addWidget( new QLabel( i18n("Queue Level"), Frame ), i, 0 );
    queLed = new QLineEdit( Frame );
    queLed->setMaxLength( 1 );
    l->addMultiCellWidget( queLed, i, i, 1, 1 );
    i++;
  }
  { // Mail ON/OFF
    l->addWidget( new QLabel( i18n("Mail"), Frame ), i, 0 );
    QButtonGroup *g = new QButtonGroup( 1, Vertical, Frame );
    g->setFrameShape( QFrame::NoFrame );
    g->setInsideMargin( 0 );
    g->setInsideSpacing( 0 );
    monRdb = new QRadioButton( "ON", g );
    mofRdb = new QRadioButton( "OFF", g );
    l->addMultiCellWidget( g, i, i, 1, 2 );
    i++;
  }
  { // Command Lable
    l->addWidget( new QLabel( i18n("Command"), Frame ), i, 0 );
    i++;
  }
  { // Command Input Text
    cmdTed = new QTextEdit( Frame );
    cmdTed->setWordWrap( QTextEdit::NoWrap );
    l->addMultiCellWidget( cmdTed, i, i, 0, 2 );
    i++;
  }
  editAt = new AtTbl();
  setEnabled( false );

}

//
// Initialize from 'at' data
void AtEditWgt::iniEdit( AtTbl *at )
{

  setEnabled( true );

  timLed->setText( at->Time.toString( "yyyy-MM-dd hh:mm" ) );
  cmdTed->setText( at->Cmnd );
  if ( at->Mail ){
    monRdb->setChecked( true );
  }else{
    mofRdb->setChecked( true );
  }

  usrLbl->setText( at->User );
  queLed->setText( QChar(at->Qno) );

  *editAt = *at;
  setButton( *at );

}

//
// Set Action Button
void AtEditWgt::setButton( const AtTbl& chk )
{

  bool m, n;

  // Change Check
  if ( chk.Qno    != editAt->Qno    ||
       chk.User   != editAt->User   ||
       chk.Time   != editAt->Time   ||
       chk.Mail   != editAt->Mail   ||
       chk.Cmnd   != editAt->Cmnd ){
    m = true;
  }else{
    m = false;
  }
  if ( chk.Flag & ( EDIT_DELETE | EDIT_NEW ) ) {
    n = true;
  }else{
    n = false;
  }
  if ( chk.User != System::uName() ){
//  n = false;
    m = false;
  }

  setEnable( true, m, n, true );
}
