/***************************************************************************
                          system.h  -  description
                             -------------------
    begin                :   1 31 2003
    copyright            : (C) 2003 by k-kobayashi
    email                : k-kobayashi@isis.ocn.ne.jp
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/


#ifndef SYSTEM_H
#define SYSTEM_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Unix System
//#include <unistd.h>
//#include <iostream>
#include <pwd.h>
#include <grp.h>



// include files for QT
#include <qstring.h>
#include <qstringlist.h>
#include <kprocess.h>
#include <qfile.h>
#include <qpixmap.h>

// include files for KDE
#include <kstandarddirs.h>

class Option;

#define CAN_READ      0x01
#define CAN_WRITE     0x02
#define CAN_READ_DIR  0x04
#define CAN_WRITE_DIR 0x08
#define FILE_EXIST    0x10
#define PATH_EXIST    0x20

// Anacron Status
#define ANAC_INSTALLED  0x01
#define ANAC_READABLE   0x02
#define ANAC_WRITABLE   0x04

// Kde Appliation Data File Type
enum KFTYPE {
  KFILE_DETAIL,     // Text file        : apps/text/*.txt
  KFILE_TMPL,       // Template file    : apps/text/*.txt
  KFILE_ICON,       // Icon image       : apps/image/icon/*.png
  KFILE_CLOCK_CONF, // Clock Config     : apps/image/clock/*.txt
  KFILE_CLOCK_IMAGE,// Clock image      : apps/image/clock/*.png
  KFILE_SOUND       // Wave File        : apps/sound/*.wav
};



/**
  * Kde Application Data Directory Information Class
  *  if local application directory not found,
  *  directroy and data copied from install directory by constructor
  *   : inherited by KdeData
  *  
  */
class KdeDir : public KStandardDirs
{
public:
  /** KFType is Application data type
   */
  KdeDir( KFTYPE kftype );

  /** Get Local Directroy Entry File
   */
  QStringList getEntry( const QString& filter );
  
  /** Local Directory
   */
  QString     dirName;
};

/**
  * Kde Local Application Data File Access Class
  * Read/Write(text) Local data file 
  *  : Inherited by IconFile, DetailFile, BackFile, CConfFile, CimgFile
  */
class KdeFile : KdeDir
{

public:
  /** Constructor, Parameter is data file type and short file name
   */
  KdeFile( const QString& name, KFTYPE kftype );
  ~KdeFile() {}

  /** Absolute file name
   */
  QString fullName;

  QString readText();
  void    writeText( const QString& str );
//  inline QPixmap pixmap() const { return QPixmap( fullName ); }
};

/** Icon Image File Access
  */
class IconFile : public QPixmap
{
public:
  IconFile( const QString& name )
  : QPixmap( KdeFile( name, KFILE_ICON ).fullName, 0, QPixmap::Color ) {}
};

/** Text Data File (Detail Format File) Access
  */
class DetailFile : public KdeFile
{
public:
  DetailFile( const QString& name ) : KdeFile( name, KFILE_DETAIL ) {}
  QString readDetail();
};

/** Template Data File (Template File) Access
  */
class TmplFile : public KdeFile
{
public:
  TmplFile( const QString& name ) : KdeFile( name, KFILE_TMPL ) {}
};

/** Clock Configure File Access
  */
class CconfFile : public KdeFile
{
public:
  CconfFile( const QString& name ) : KdeFile( name, KFILE_CLOCK_CONF ) {}
};

/** Clock Image File Access
  */
class CimagFile : public QPixmap
{
public:
  CimagFile( const QString& name )
  : QPixmap( KdeFile( name, KFILE_CLOCK_IMAGE ).fullName ) {}
};

/** Sound File Access
 */
class CwaveFile : public KdeFile
{
public:
  CwaveFile( const QString& name ) : KdeFile( name, KFILE_SOUND ) {}
};

/** Issue Command, and get result
  * errStr : strerr string
  * outStr : strout string
  *
  */
// Issue Command, and get stdout/stderr
//
class Command : public QObject
{
Q_OBJECT

public:
  /** Execute command and wait command completed
   *  return : command return code
   */
  Command( const QString& cmd, bool detach=false );

  QString   outStr;       // stdout string
  QString   errStr;       // stderr string
  int exitStatus;

protected slots:
  void      slotStderr(KProcess*,char*,int);
  void      slotStdout(KProcess*,char*,int);
};

/** Common Use In this System
  */
class System
{

public:

  static uid_t    uid()    { return getuid();                        }
  static gid_t    gid()    { return getgid();                        }
  static QString  uName()  { return( getpwuid(uid())->pw_name );     } // user name
  static QString  uHome()  { return( getpwuid(uid())->pw_dir );      } // user home directory
  static QString  uShell() { return( getpwuid(uid())->pw_shell );    } // user shell
  static QString  uReal()  { return( getpwuid(uid())->pw_gecos ); } // user real name
  static QString  uGroup() { return( getgrgid(gid())->gr_name );     } // user group
  static int      access( const QString& fname );
  static QStringList allUsers();                         // all user name list
  static QStringList cronUsers();     // 'cron' allow user name list
  static QStringList atUsers();       // 'at' allow user name list
  static bool        atEnable();
  static bool        cronEnable();
  static bool        isCronWritable();
  static int         getAnacStatus();
  static bool        saveUsers( int flg, QStringList* user, const QString& afile, const QString& dfile );
  static QString     getCommand( const QString& name );  // get command absolute path
  static QString     cronVersion();                      // 'cron' version
  static QString     anacVersion();                      // 'anacron' version
  static QString     atVersion();                        // 'at' version
  static void        setUid( const QString& user );
  static void        iniClock();
  static int         getClock();
//  static clock_t     fClock;
    
private:
  static QStringList getUsers( const QString& str );    // get user name list from (allow/deny)file

};

#endif // SYSTEM_H

