/***************************************************************************
                          confDlg.cpp  -  description
                             -------------------
    begin                :   2 22 2003
    copyright            : (C) 2003 by K.Kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//using namespace std;
//#include <iostream>
#include <sys/syslog.h>

// include files for Qt
#include <qdatetime.h>
#include <qlistview.h>
#include <qfile.h>
#include <qpushbutton.h>
#include <qbuttongroup.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qdatetimeedit.h>
#include <qlayout.h>
#include <qtextedit.h>
#include <qfileinfo.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qlistbox.h>

// include files for KDE
#include <klocale.h>
#include <kdialogbase.h>

// application specific includes
#include "system.h"
#include "option.h"
#include "docTables.h"
#include "commonWgt.h"
#include "kroneconfig.h"
#include "confDlg.h"

extern Option *g_Option;
extern bool   g_ViewMode;

/////////////////////////////////////////////////////////////////////////////
// GenTab - General Configure Tab

//
// Constructor
GenTab::GenTab(QWidget* p) :
  QWidget( p )
{

  CGroupBox *g;

  QHBoxLayout* h = new QHBoxLayout( this, KDialogBase::marginHint(), KDialogBase::spacingHint() );
  {
    // ** Left **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // Use Anacron, At
      g = new CGroupBox( i18n("Show Data"), this );
      v->addWidget( g );
#ifdef CRON_DILLON
      QGridLayout* l = new QGridLayout( g->layout(), 2, 2 );
#else
      QGridLayout* l = new QGridLayout( g->layout(), 3, 2 );
#endif
      {
        anacCbx = new QCheckBox( i18n("Show Anacron in this program"), g );
        l->addWidget( anacCbx, 0, 0 );
        l->addWidget( new QLabel( "", g ), 0, 1 );
        atCbx = new QCheckBox( i18n("Show At in this Program"), g );
        l->addWidget( atCbx, 1, 0 );
#ifndef CRON_DILLON
        scronCbx = new QCheckBox( i18n("Show '/etc/crontab' in this Program"), g );
        l->addWidget( scronCbx, 2, 0 );
#endif
        anacCbx->setChecked( g_Option->useAnacron );
        atCbx->setChecked( g_Option->useAt );
#ifndef CRON_DILLON
        scronCbx->setChecked( g_Option->useSyscron );
#endif
        if ( ! ( System::getAnacStatus() & ANAC_INSTALLED ) ) anacCbx->setEnabled( false );
      }
    }
#ifndef CRON_DILLON
    {
      // Log File Path
      pathBgr = new CButtonGroup( i18n("Path Name"), this );
      v->addWidget( pathBgr );
      QHBoxLayout* h1 = new QHBoxLayout( pathBgr->layout() );
      {
        h1->addWidget( new QLabel( i18n("Log File"), pathBgr ) );
        logLed = new QLineEdit( g_Option->logFile, pathBgr );
        h1->addWidget( logLed );
        h1->addWidget( new IconPushButton( "check", pathBgr  ) );
      }
    }
#endif
    {
      // Next Time Method
      g = new CGroupBox( i18n("Machine Power On Time(Expected)"), this );
      v->addWidget( g );
      QGridLayout* l = new QGridLayout( g->layout(), 2, 2 );
      {
        // Power On Time
        l->addWidget( new QLabel( i18n("Power On Time"), g ), 0, 0 );
        timeTme = new QTimeEdit( g );
        timeTme->setTime( g_Option->ponTime );
        l->addWidget( timeTme, 0, 1 );
      }
      {
        // Weekday
        weekdayCbx = new QCheckBox( i18n("Weekday Only"), g );
        weekdayCbx->setChecked( g_Option->ponWeekDay );
        l->addMultiCellWidget( weekdayCbx, 1,1,0,1);
      }
    }
    {
      // Rest Time Display Mode
      CButtonGroup *b = new CButtonGroup( i18n("Rest Time Display Mode"), this );
      v->addWidget( b );
      QHBoxLayout* h1 = new QHBoxLayout( b->layout() );
      {
        dayRdb = new QRadioButton( i18n("Days"), b );
        h1->addWidget( dayRdb );
        hourRdb = new QRadioButton( i18n("Hours"), b );
        h1->addWidget( hourRdb );
        minuteRdb = new QRadioButton( i18n("Minutes"), b );
        h1->addWidget( minuteRdb );
        if ( g_Option->restMode == 1 ) dayRdb->setChecked( true );
        else if ( g_Option->restMode == 2 ) hourRdb->setChecked( true );
        else minuteRdb->setChecked( true );
      }
     }
#ifndef CRON_DILLON
    {
      // Auto Log Update
      CButtonGroup *b = new CButtonGroup( i18n("Log List Update"), this );
      v->addWidget( b );
      QHBoxLayout* h1 = new QHBoxLayout( b->layout() );
      {
        alogCbx = new QCheckBox( i18n("Automatic Log List Update"), b );
        alogCbx->setChecked( g_Option->autoModLog );
        h1->addWidget( alogCbx );
        if ( !(System::access( g_Option->logFile ) & CAN_READ) ){
          alogCbx->setEnabled( false );
        }

      }
    }
#endif
    v->addStretch();
  }
  {
    // ** Right **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // List (Execute,Log) Max
      g = new CGroupBox( i18n("List Max"), this );
      v->addWidget( g );
#ifdef CRON_DILLON
      QGridLayout* l = new QGridLayout( g->layout(), 3, 2 );
#else
      QGridLayout* l = new QGridLayout( g->layout(), 4, 2 );
#endif
      {
        // Execute List Max
        l->addWidget( new QLabel( i18n("Execute List Max"), g ), 0, 0 );
        exeSbx = new QSpinBox( 10, 10000, 10, g );
        l->addWidget( exeSbx, 0, 1 );
        exeSbx->setValue( g_Option->exeListMax );
        edayCbx = new QCheckBox( i18n("Execute List Max Date form Today"), g );
        edayCbx->setChecked( g_Option->useExeDay );
        l->addWidget( edayCbx, 1, 0 );
        l->addWidget( new QLabel( i18n("ExeCute List Max Date"), g ), 2, 0 );
        edaySbx = new QSpinBox( 0, 3650, 1, g );
        l->addWidget( edaySbx, 2, 1 );
        edaySbx->setValue( g_Option->exeDayMax );
        if ( g_Option->useExeDay ){
          edaySbx->setEnabled( true );
        }else{
          edaySbx->setEnabled( false );
        }
      }
#ifndef CRON_DILLON
      {
        // Log List Max
        l->addWidget( new QLabel( i18n("Log List Max"), g ), 3, 0 );
        logSbx = new QSpinBox( 100, 10000, 10, g );
        l->addWidget( logSbx, 3, 1 );
        logSbx->setValue( g_Option->logListMax );
        if ( !(System::access( g_Option->logFile ) & CAN_READ) ){
          logSbx->setEnabled( false );
        }
      }
#endif
    }
    {
      // Image File ( Backgroud,Clock )
      g = new CGroupBox( i18n("Graphics"), this );
      v->addWidget( g );
      QGridLayout* l = new QGridLayout( g->layout(), 1, 2 );
      {
        // Clock Image
        l->addWidget( new QLabel( i18n("Clock Image"), g ), 0, 0 );
        clockCbb = new QComboBox( g );
        QStringList sl = KdeDir( KFILE_CLOCK_CONF ).getEntry( "*.txt" );
        clockCbb->insertStringList( sl );
        if ( sl.find( g_Option->clockImage ) != sl.end() ){
          clockCbb->setCurrentText( g_Option->clockImage );
        }
        l->addWidget( clockCbb, 0, 1 );
      }
    }
    {
      // Sound
      g = new CGroupBox( i18n("Sound"), this );
      v->addWidget( g );
      QGridLayout* l = new QGridLayout( g->layout(), 3, 3 );
      {
        // Sound Enable/Disable
        soundCbx = new QCheckBox( i18n("Use Sound"), g );
        soundCbx->setChecked( g_Option->useSound );
        l->addWidget( soundCbx, 0, 0 );
        // Sound Minutes
        l->addWidget( new QLabel( i18n("Play Time Before Job(Second)"), g ), 1, 0 );
        soundSbx = new QSpinBox( 10, 50, 1, g );
        soundSbx->setValue( g_Option->soundSec );
        l->addWidget( soundSbx, 1, 1 );
        // Sound Name
        l->addWidget( new QLabel( i18n("Sound Name"), g ), 2, 0 );
        soundCbb = new QComboBox( g );
        QStringList sl = KdeDir( KFILE_SOUND ).getEntry( "*.wav" );
        soundCbb->insertStringList( sl );
        if ( sl.find( g_Option->soundName ) != sl.end() ){
          soundCbb->setCurrentText( g_Option->soundName );
        }
        l->addWidget( soundCbb, 2, 1 );
        soundBtn = new IconPushButton( "check", g  ); 
        l->addWidget( soundBtn, 2, 2 );
      }
      if ( System::getCommand( SOUND_CMD ) == "" ) g->setEnabled( false );
    }
    v->addStretch();
  }

}

/////////////////////////////////////////////////////////////////////////////
// CronTab - 'cron' Configure Tab

//
// Constructor
CronTab::CronTab(QWidget* p) :
  QWidget( p )
{

  CGroupBox *g;
  
  // Get Current 'cron' Users
  cronUsers = new QStringList ( System::cronUsers() );
  cronUser = g_Option->cronUser;
  cronUserChg = false;

  QHBoxLayout* h = new QHBoxLayout( this, KDialogBase::marginHint(), KDialogBase::spacingHint() );
  {
    // ** Left **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // Use Literal Format
      g = new CGroupBox( i18n("Date Field Format"), this );
      v->addWidget( g );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      litCbx = new QCheckBox( i18n("Use Literal Format in Week/Month Fiels"),g );
      litCbx->setChecked( g_Option->cronLiteral );
      v1->addWidget( litCbx );
    }
    {
      // 'cron' File Path
      pathBgr = new CButtonGroup( i18n("Cron Path Names"), this );
      v->addWidget( pathBgr );
#ifdef CRON_DILLON
      QGridLayout* l = new QGridLayout( pathBgr->layout(), 2, 3 );
#else
      QGridLayout* l = new QGridLayout( pathBgr->layout(), 7, 3 );
#endif
      int i = 0;
      {
        // 'cron' Directory
        l->addWidget( new QLabel( i18n("Cron Directory"), pathBgr ), i, 0 );
        cronLed = new QLineEdit( g_Option->cronPath, pathBgr );
        l->addWidget( cronLed, i, 1 );
        l->addWidget( new IconPushButton( "check", pathBgr  ), i, 2 );
        i++;
      }
      {
        // Spool Directroy
        l->addWidget( new QLabel( i18n("Spool Directory"), pathBgr ), i, 0 );
        spoolLed = new QLineEdit( g_Option->cronPathSpool, pathBgr );
        l->addWidget( spoolLed, i, 1 );
        l->addWidget( new IconPushButton( "check", pathBgr  ), i, 2 );
        i++;
      }
#ifndef CRON_DILLON
      {
        // Allow File
        l->addWidget( new QLabel( i18n("Allow File"), pathBgr ), i, 0 );
        allowLed = new QLineEdit( g_Option->cronFileAllow, pathBgr );
        l->addWidget( allowLed, i, 1 );
        l->addWidget( new IconPushButton( "check", pathBgr  ), i, 2 );
        i++;
      }
      {
        // Deny File
        l->addWidget( new QLabel( i18n("Deny File"), pathBgr ), i, 0 );
        denyLed = new QLineEdit( g_Option->cronFileDeny, pathBgr );
        l->addWidget( denyLed, i, 1 );
        l->addWidget( new IconPushButton( "check", pathBgr  ), i, 2 );
        i++;
      }
      {
        // 'crontab' File
        l->addWidget( new QLabel( i18n("System Cron Table"), pathBgr ), i, 0 );
        sysLed = new QLineEdit( g_Option->cronFileSys, pathBgr );
        l->addWidget( sysLed, i, 1 );
        l->addWidget( new IconPushButton( "check", pathBgr ), i, 2 );
        i++;
      }
#endif

    }
#ifndef CRON_DILLON
    {
      // User Access List
      usrBgr = new CButtonGroup( i18n("User Access \"allow/deny\" File"), this );
      v->addWidget( usrBgr );
      QGridLayout* l = new QGridLayout( usrBgr->layout(), 3, 2 );
      {
        // All Users                                 
        allRbt = new QRadioButton( i18n("All Users"), usrBgr );
        l->addWidget( allRbt, 0, 0 );
      }
      {
        // Allow Users
        allowRbt = new QRadioButton( i18n("Allow Users"), usrBgr );
        l->addWidget( allowRbt, 1, 0 );
      }
      {
        // Deny Users
        denyRbt = new QRadioButton( i18n("Deny Users"), usrBgr );
        l->addWidget( denyRbt, 2, 0 );
      }
      {
        // User Edit Button
        usrBtn = new IconPushButton( "user", usrBgr  );
        usrBtn->setFixedWidth( usrBtn->height() );
        l->addMultiCellWidget( usrBtn, 1, 2, 1, 1 );
      }
      // Set Current
      switch( cronUser ){
        case ALL_USER:
          allRbt->setChecked( true );
          usrBtn->setEnabled( false );
          break;
        case ALLOW_USER:
          allowRbt->setChecked( true );
          usrBtn->setEnabled( true );
          break;
        case DENY_USER:
          denyRbt->setChecked( true );
          usrBtn->setEnabled( true );
          break;
      }
      if ( g_ViewMode || System::uid() != 0 ) usrBgr->setEnabled( false );
    }
#endif
    v->addStretch();
  }
  {
    // ** Right 
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // New Data Template
      g = new CGroupBox( i18n("Default New Data"), this );
      v->addWidget( g );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      {
        // Description
        v1->addWidget( new QLabel( i18n( "  Below variables convert strings from passwd\n"
                                         "    |USER|,|GROUP|,|HOME|,|SHELL|,|UINF|\n"
                                         "  Current Time : |CURRENT|" ), g ) );
      }
      {
        // Header Template
        v1->addWidget( new QLabel( i18n("Header (Comment and Variable)"), g ) );
        headTed = new QTextEdit( g );
        v1->addWidget( headTed );
        headTed->setWordWrap( QTextEdit::NoWrap );
        headTed->setText( g_Option->cronNewHead );
      }
      {
        // Command Template
        v1->addWidget( new QLabel( i18n("Command (Comment and Command)"), g ) );
        cmndTed = new QTextEdit( g );
        v1->addWidget( cmndTed );
        cmndTed->setWordWrap( QTextEdit::NoWrap );
        cmndTed->setText( g_Option->cronNewCmnd );
      }
    }
//    v->addStretch();
  }
}

//
// Destructor
CronTab::~CronTab()
{
  delete cronUsers;
}

/////////////////////////////////////////////////////////////////////////////
// AnacTab - 'anacron' Configure Tab

//
// Constructor
AnacTab::AnacTab(QWidget* p) :
  QWidget( p )
{

  CGroupBox *g;
  QHBoxLayout* h = new QHBoxLayout( this, KDialogBase::marginHint(), KDialogBase::spacingHint() );
  {
    // ** Left **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // Use Execute List
      g = new CGroupBox( i18n("Display in Execute Time List"), this );
      v->addWidget( g );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      dspexeCbx = new QCheckBox( i18n("Display in Execute Time List"),g );
      dspexeCbx->setChecked( g_Option->anacListDisp );
      v1->addWidget( dspexeCbx );
    }
    {
      // Path check
      IconPushButton *btn;
      pathBgr = new CButtonGroup( i18n("Anacron Path"), this );
      v->addWidget( pathBgr );
      QGridLayout* l = new QGridLayout( pathBgr->layout(), 2, 3 );
      int i=0;
      {
        // 'anacrontab' Path
        l->addWidget( new QLabel( i18n("Anacron Table Path"), pathBgr ), 0, 0 );
        sysLed = new QLineEdit( g_Option->anacFileSys, pathBgr );
        l->addWidget( sysLed, i, 1 );
        btn = new IconPushButton( "check", pathBgr  );
        l->addWidget( btn, i, 2 );
        i++;
      }
      {
        // Spool Path
        l->addWidget( new QLabel( i18n("Anacron Spool Path"), pathBgr ), i, 0 );
        spoolLed = new QLineEdit( g_Option->anacPathSpool, pathBgr );
        l->addWidget( spoolLed, i, 1 );
        btn = new IconPushButton( "check", pathBgr  );
        l->addWidget( btn, i, 2 );
        i++;
      }
    }
    v->addStretch();
  }
  {
    // ** Right **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // New Data Template
      g = new CGroupBox( i18n("Default New Data"), this );
      v->addWidget( g );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      {
        // Description
        v1->addWidget( new QLabel( i18n("  Below variables convert strings from passwd\n"
                                        "    |USER|,|GROUP|,|HOME|,|SHELL|,|UINF|\n"
                                        "  Current Time : |CURRENT|") , g ) );
      }
      {
        // Header Template
        v1->addWidget( new QLabel( i18n("Header (Comment and Variable)"), g ) );
        headTed = new QTextEdit( g );
        v1->addWidget( headTed );
        headTed->setWordWrap( QTextEdit::NoWrap );
        headTed->setText( g_Option->anacNewHead );
      }
      {
        // Command Template
        v1->addWidget( new QLabel( i18n("Command (Comment and Command)"), g ) );
        cmndTed = new QTextEdit( g );
        v1->addWidget( cmndTed );
        cmndTed->setWordWrap( QTextEdit::NoWrap );
        cmndTed->setText( g_Option->anacNewCmnd );
      }
    }
  }

}


/////////////////////////////////////////////////////////////////////////////
// AtTab - 'at' Configure Tab

//
// Constructor
AtTab::AtTab(QWidget* p) :
  QWidget( p )
{

  // 'at' Users List
  atUsers = new QStringList ( System::atUsers() );
  // 'at' User Mode
  atUser = g_Option->atUser;
  atUserChg = false;

  CGroupBox *g;
  
  QHBoxLayout* h = new QHBoxLayout( this, KDialogBase::marginHint(), KDialogBase::spacingHint() );
  {
    // ** Left **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // Display Execute
      g = new CGroupBox( i18n("Display in Execute Time List"), this );
      v->addWidget( g );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      dspexeCbx = new QCheckBox( i18n("Display in Execute Time List"),g );
      dspexeCbx->setChecked( g_Option->atDispExe );
      v1->addWidget( dspexeCbx );
    }
    {
      // Path Check
      pathBgr = new CButtonGroup( i18n("At Path"), this );
      v->addWidget( pathBgr );
      QGridLayout* l = new QGridLayout( pathBgr->layout(), 1, 3 );
      {
        // Allow/Deny Path
        l->addWidget( new QLabel( i18n("allow/deny Path"), pathBgr ), 0, 0 );
        pathLed = new QLineEdit( g_Option->atPath, pathBgr );
        l->addWidget( pathLed, 0, 1 );
        l->addWidget( new IconPushButton( "check", pathBgr  ), 0, 2 );
      }
    }
    {
      // Allow Users
      usrBgr = new CButtonGroup( i18n("User Access \"allow/deny\" File"), this );
      v->addWidget( usrBgr );
      QGridLayout* l = new QGridLayout( usrBgr->layout(), 3, 2 );
      {
        // All
        allRbt = new QRadioButton( i18n("All Users"), usrBgr );
        l->addWidget( allRbt, 0, 0 );
      }
      {
        // Allow
        allowRbt = new QRadioButton( i18n("Allow Users"), usrBgr );
        l->addWidget( allowRbt, 1, 0 );
      }
      {
        // Deny
        denyRbt = new QRadioButton( i18n("Deny Users"), usrBgr );
        l->addWidget( denyRbt, 2, 0 );
      }
      {
        // Select Button
        usrBtn = new IconPushButton( "user", usrBgr );
        usrBtn->setFixedWidth( usrBtn->height() );
        l->addMultiCellWidget( usrBtn, 1, 2, 1, 1 );
      }
      // Current Setting
      switch( atUser ){
        case ALL_USER:
          allRbt->setChecked( true );
          usrBtn->setEnabled( false );
          break;
        case ALLOW_USER:
          allowRbt->setChecked( true );
          usrBtn->setEnabled( true );
          break;
        case DENY_USER:
          denyRbt->setChecked( true );
          usrBtn->setEnabled( true );
          break;
      }
      if ( g_ViewMode || System::uid() != 0 ) usrBgr->setEnabled( false );
    }
    v->addStretch();
  }
  {
    // ** Left **
    QVBoxLayout* v = new QVBoxLayout( h );
    {
      // Template
      g = new CGroupBox( i18n("Default New Data"), this );
      v->addWidget( g );
      QVBoxLayout* v1 = new QVBoxLayout( g->layout() );
      {
        // Description
        v1->addWidget( new QLabel( i18n("  Below variables convert strings from passwd\n"
                                        "    |USER|,|GROUP|,|HOME|,|SHELL|,|UINF|\n"
                                        "  Current Time : |CURRENT|\n"
                                        "  Execute Time : |EXETIME|") , g ) );
      }
      {
        // Command Template
        v1->addWidget( new QLabel( i18n("Command"), g ) );
        cmndTed = new QTextEdit( g );
        v1->addWidget( cmndTed );
        cmndTed->setWordWrap( QTextEdit::NoWrap );
        cmndTed->setText( g_Option->atNewCmnd );
      }
      {
        // Delay Minute Default
        QHBoxLayout* h1 = new QHBoxLayout( g->layout() );
        h1->addWidget( new QLabel( i18n("Execute Delay Minutes from current"), g ) );
        delaySpb = new QSpinBox( 1, 3650, 1, g );
        h1->addWidget( delaySpb );
        delaySpb->setValue( g_Option->atNewTime );
      }
      {
        // Mail Default
        QHBoxLayout* h1 = new QHBoxLayout( g->layout() );
        h1->addWidget( new QLabel( i18n("Mail"), g ) );
        monRbt = new QRadioButton( "ON", g );
        h1->addWidget( monRbt );
        moffRbt = new QRadioButton( "OFF", g );
        h1->addWidget( moffRbt );
        if ( g_Option->atNewMail ){
          monRbt->setChecked( true );
        }else{
          moffRbt->setChecked( true );
        }
      }
    }
  }
}

//
// Destructor
AtTab::~AtTab()
{
  delete atUsers;
}

/////////////////////////////////////////////////////////////////////////////
// UserDlg - User Select Dialog

//
// Constructor
UserDlg::UserDlg( int flg, QStringList* ulist ) :
  KDialog()
{
  QVBoxLayout* v = new QVBoxLayout( this, marginHint(), spacingHint() );
  {
    // ** Upper **
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    {
      // Left Data
      QVBoxLayout *v1 = new QVBoxLayout( h, 5 );
      if ( flg == ALLOW_USER ){
        v1->addWidget( new QLabel( i18n( "Allow Users" ), this ) );
      }else{
        v1->addWidget( new QLabel( i18n( "Deny Users" ), this ) );
      }
      setLbx = new QListBox( this );
      setLbx->setMinimumWidth( 150 );
      setLbx->setSelectionMode( QListBox::Multi );
      v1->addWidget( setLbx );
    }
    {
      // '<','>' Buttons
      QVBoxLayout *v1 = new QVBoxLayout( h, 5 );
      QPushButton* btn = new QPushButton( "<", this );
      btn->setFixedWidth( 40 );
      connect( btn, SIGNAL( clicked() ), this, SLOT( slotAdd() ) );
      v1->addWidget( btn );
      
      btn = new QPushButton( ">", this );
      btn->setFixedWidth( 40 );
      connect( btn, SIGNAL( clicked() ), this, SLOT( slotRemove() ) );
      v1->addWidget( btn );
    }
    {
      // Right Data
      QVBoxLayout *v1 = new QVBoxLayout( h, 5 );
      v1->addWidget( new QLabel( i18n( "All Users" ), this ) );
      allLbx = new QListBox( this );
      allLbx->setMinimumWidth( 150 );
      allLbx->setSelectionMode( QListBox::Multi );
      v1->addWidget( allLbx );
    }
  }
  {
    // ** OK/CANCEL Button **
    QHBoxLayout* h = new QHBoxLayout( v, 5 );
    h->addStretch( 1 );
    QPushButton *okbutton = new QPushButton( i18n("&OK"), this );
    okbutton->setDefault( true );
    h->addWidget( okbutton );

    QPushButton *canbutton = new QPushButton( i18n("&Cancel"), this );
    h->addWidget( canbutton );

    connect( okbutton, SIGNAL( clicked() ), this, SLOT( accept() ) );
    connect( canbutton, SIGNAL( clicked() ), this, SLOT( reject() ) );
  }
  setCaption( i18n("Allow User Setting") );

  //
  // Initalize List Box
  QStringList alluser = System::allUsers();
  for( QStringList::Iterator ia=alluser.begin(); ia != alluser.end(); ++ia ){
    bool bget = true;
    if ( ulist->find( *ia ) == ulist->end() ){
      bget = false;
    }
    if ( flg == ALLOW_USER ){
      if ( bget ) setLbx->insertItem( *ia );
      else allLbx->insertItem( *ia );
    }else{
      if ( ! bget ) setLbx->insertItem( *ia );
      else allLbx->insertItem( *ia );
    }
  }
  chgFlg = false;


}

//
//---SLOTS-------------------------------------------------------------------

//
// User Add Button Action
void UserDlg::slotAdd()
{
  for (int i=0; i < allLbx->numRows(); i++ ){
    if ( allLbx->isSelected( i ) ){
      setLbx->insertItem( allLbx->text( i ) );
      allLbx->removeItem( i );
      i--;
    }
  }
  chgFlg = true;
}

//
// User Remove Button Action
void UserDlg::slotRemove()
{
  for (int i=0; i < setLbx->numRows(); i++ ){
    if ( setLbx->isSelected( i ) ){
      allLbx->insertItem( setLbx->text( i ) );
      setLbx->removeItem( i );
      i--;
    }
  }
  chgFlg = true;
}

/////////////////////////////////////////////////////////////////////////////
// ConfDlg - Configure Dialog

//
// Constructor
ConfDlg::ConfDlg() :
  QTabDialog( 0, "Test Dialog", false )
{

  // General Configure Tab
  genTab = new GenTab( this );
  addTab( genTab, IconFile( "configure" ), i18n("General Setting") );

  // 'cron' Configure Tab
  cronTab = new CronTab( this );
  addTab( cronTab,    IconFile( "cronicon" ), "Cron" );

  // 'anacron' Configure Tab
  if ( System::getAnacStatus() & ANAC_INSTALLED ){
    anacTab = new AnacTab( this );
    addTab( anacTab,    IconFile( "anacicon" ), "Anacron" );
  }
  
  // 'anacron' Configure Tab
  atTab = new AtTab( this );
  addTab( atTab,      IconFile( "aticon" ),   "At" );
    
  //  Buttons();
  setOkButton();
  setCancelButton();

  setCaption( i18n("Configure Kroneko") );

  // Change Item
  chgFlag = 0;
  atEnable = System::atEnable();

#ifndef CRON_DILLON
  // Genaral Configure Tab : Path Check
  connect( genTab->pathBgr, SIGNAL( clicked( int ) ), this,
                         SLOT( slotGenPathCheck( int ) ) );
#endif
  // Genaral Configure Tab : Use Day
  connect( genTab->edayCbx, SIGNAL( toggled( bool ) ), this,
                         SLOT ( slotGenUseDay( bool ) ) );
  // General Configure Tab : Test Sound
  connect( genTab->soundBtn, SIGNAL( clicked() ), this,
                         SLOT( slotSoundTest() ) );
#ifndef CRON_DILLON
  // 'cron' Configure Tab : Path Check
  connect( cronTab->usrBgr, SIGNAL( clicked( int ) ), this,
                         SLOT( slotCronUserAccess( int ) ) );
#endif
  // 'cron' Configure Tab : Path Check
  connect( cronTab->pathBgr, SIGNAL( clicked( int ) ), this,
                         SLOT( slotCronPathCheck( int ) ) );
  if ( System::getAnacStatus() & ANAC_INSTALLED ){
    // 'anacron' Configure Tab : Path Check
    connect( anacTab->pathBgr, SIGNAL( clicked( int ) ), this,
                         SLOT( slotAnacPathCheck( int ) ) );
  }
  // 'at' Configure Tab : Path Check
  connect( atTab->usrBgr, SIGNAL( clicked( int ) ), this,
                         SLOT( slotAtUserAccess( int ) ) );
  // 'at' Configure Tab : Path Check
  connect( atTab->pathBgr, SIGNAL( clicked( int ) ), this,
                         SLOT( slotAtPathCheck( int ) ) );

  // OK Action
  connect( this, SIGNAL( applyButtonPressed() ), this, SLOT( slotApply() ) );
  // CANCEL Action
  connect( this, SIGNAL( cancelButtonPressed() ), this, SLOT( reject() ) );

}

//
//---SLOTS-------------------------------------------------------------------

//
// - General Tab Slots -
//
// Log Path Check Action
void ConfDlg::slotGenPathCheck( int /* idx */ )
{
  
#ifndef CRON_DILLON
  QString def( i18n("\n\nThis operation system's default is ") + LOG_PATH + "."  );
  QString cap( i18n("Log File") );
  QFileInfo fi( genTab->logLed->text() );
  if ( ! fi.exists() ){
    QMessageBox::warning( this, cap, i18n("Log file not found.") + def );
  }else{
    if ( fi.isReadable() ){
      QMessageBox::information( this, cap, i18n("Log file found.") + def );
    }else{
      QMessageBox::information( this, cap,
            i18n("Log file found.\n"
                 "but you not allowed read access.") + def );
    }
  }
#endif

}

//
// Use Day
void ConfDlg::slotGenUseDay( bool b )
{
  // Day Spin Box Enable/Disable
  genTab->edaySbx->setEnabled( b );
}


//
// Sound Test
void ConfDlg::slotSoundTest()
{
  QString fn = CwaveFile( genTab->soundCbb->currentText() ).fullName;
  QString cstr = System::getCommand( SOUND_CMD ) + " " + fn;
  Command cmd( cstr );
  if ( cmd.exitStatus ){
    genTab->soundCbx->setChecked( false );
    QMessageBox::warning( this, i18n("Sound Error"), cmd.errStr );
  }

}

//
// - 'cron' Tab Slots -
//
// Allow User Button Group
void ConfDlg::slotCronUserAccess( int idx )
{

  switch ( idx ){
    case 0:
      // All Users Radio Button
      cronTab->usrBtn->setEnabled( false );
      cronTab->cronUser = ALL_USER;
      break;
    case 1:
      // Allow Users Radio Button
      cronTab->usrBtn->setEnabled( true );
      cronTab->cronUser = ALLOW_USER;
      break;
    case 2:
      // Deny Users Radio Button
      cronTab->usrBtn->setEnabled( true );
      cronTab->cronUser = DENY_USER;
      break;
    case 3:
      // User Select Button
      UserDlg dlg( cronTab->cronUser, cronTab->cronUsers );
      if ( dlg.exec() == QDialog::Accepted ){
        // Allow User Set
        cronTab->cronUsers->clear();
        if ( ! cronTab->cronUserChg ) cronTab->cronUserChg = dlg.chgFlg;
        if ( cronTab->cronUser == ALLOW_USER ){
          for( int i=0; i<dlg.setLbx->numRows(); i++ ){
            cronTab->cronUsers->append( dlg.setLbx->text(i) );
          }
        }else if ( cronTab->cronUser == DENY_USER ){
          for( int i=0; i<dlg.allLbx->numRows(); i++ ){
            cronTab->cronUsers->append( dlg.allLbx->text(i) );
          }
        }
        
      }
      break;
  }
}

//
// Path Check Action
//  Cron Directory,XX,XX,
void ConfDlg::slotCronPathCheck( int idx )
{

  QString def;
  QString cap;
  QString s;
#ifndef CRON_DILLON
  int     ac;
#endif
  switch( idx ){
    case 0:
    {
      // 'cron' Directory
      def = i18n("\n\nThis path is assumed to execute crond/crontab.\n"
                 "vixie-cron's default path is /var/cron.");
      if ( ! QFileInfo ( "/var/cron" ).exists() ){
        def = def + i18n("\nbut may be set /etc. by this operating system vender");
      }
      cap = i18n("cron Default Path");
      QFileInfo fi( cronTab->cronLed->text() );
      if ( fi.exists() ){
        if ( fi.isReadable() ){
          QMessageBox::information( this, cap,
            i18n("cron default path found.") + def );
        }else{
          QMessageBox::information( this, cap,
            i18n("cron default found.\n"
                 "but you not allowed read access") + def );
        }
      }else{
        QMessageBox::critical( this, cap,
          i18n("cron default path not found.") + def );
      }
    }
    break;
    case 1:
    {
      // 'cron' Spool Path
#ifdef CRON_DILLON
      def = i18n("\n\nThis path is user crontab lives.\n"
                 "dillon-cron's default path is /var/spool/cron/crontabs.");
#else
      def = i18n("\n\nThis path is user crontab lives.\n"
                 "vixie-cron's default path is /var/cron/tabs.");
      if ( ! QFileInfo ( "/var/cron" ).exists() ){
        def = def + i18n("\nbut may be set /var/cron/spool. by this operating system vender");
      }
#endif
      cap = i18n("cron Spool Data File");
      if ( QFileInfo( cronTab->spoolLed->text() ).exists() ){
        QMessageBox::information( this, cap,
          i18n("cron spool data path found.") + def );
      }else{
        QMessageBox::critical( this, cap,
          i18n("cron spool data path not found.") + def );
      }
    }
    break;
#ifndef CRON_DILLON
    case 2:
    {
      // Allow File
      def = i18n("\n\nThis file is allow user file.\n"
                 "vixie-cron's default file is /var/cron/allow.");
      if ( ! QFileInfo ( "/var/cron" ).exists() ){
        def = def + i18n("\nbut may be set /etc/cron.allow. by this operating system vender");
      }
      cap = i18n("Allow User File");
      ac = System::access( cronTab->allowLed->text() );
      if ( ac & FILE_EXIST ){
        if ( ac & CAN_READ && ac & CAN_WRITE ){
          s = i18n("you can read/write the file.");
        }else if ( ac & CAN_READ ){
          s = i18n("you cannot write the file.");
        }else if ( ac & CAN_WRITE ){
          s = i18n("you can write the file.");
        }else{
          s = i18n("you cannot access the file.");
        }
        QMessageBox::information( this, cap, i18n("Allow User File Found.\n") + s + def );
      }else if ( ac & PATH_EXIST ){
        if ( ac & CAN_READ_DIR && ac & CAN_WRITE_DIR ){
          s = i18n("you can read/write the path.");
        }else if ( ac & CAN_READ_DIR ){
          s = i18n("you cannot write the path.");
        }else if ( ac & CAN_WRITE_DIR ){
          s = i18n("you can write the path.");
        }else{
          s = i18n("you cannot access the path.");
        }
        QMessageBox::information( this, cap, i18n("Allow User Path Found.\n") + s + def );
      }else{
        QMessageBox::critical( this, cap,
          i18n("Allow User Path Not Found.") + def );
      }
    }
    break;
    case 3:
    {
      // Deny File
      def = i18n("\n\nThis file is deny user file.\n"
                 "vixie-cron's default file is /var/cron/deny.");
      if ( ! QFileInfo ( "/var/cron" ).exists() ){
        def = def + i18n("\nbut may be set /etc/cron.deny. by this operating system vender");
      }
      cap = i18n("Deny User File");
      ac = System::access( cronTab->denyLed->text() );
      if ( ac & FILE_EXIST ){
        if ( ac & CAN_READ && ac & CAN_WRITE ){
          s = i18n("you can read/write the file.");
        }else if ( ac & CAN_READ ){
          s = i18n("you cannot write the file.");
        }else if ( ac & CAN_WRITE ){
          s = i18n("you can write the file.");
        }else{
          s = i18n("you cannot access the file.");
        }
        QMessageBox::information( this, cap, i18n("Deny User File Found.\n") + s + def );
      }else if ( ac & PATH_EXIST ){
        if ( ac & CAN_READ_DIR && ac & CAN_WRITE_DIR ){
          s = i18n("you can read/write the path.");
        }else if ( ac & CAN_READ_DIR ){
          s = i18n("you cannot write the path.");
        }else if ( ac & CAN_WRITE_DIR ){
          s = i18n("you can write the path.");
        }else{
          s = i18n("you cannot access the path.");
        }
        QMessageBox::information( this, cap, i18n("Deny User Path Found.\n") + s + def );
      }else{
        QMessageBox::critical( this, cap,
          i18n("Deny User Path Not Found.") + def );
      }
    }
    break;
    case 4:
    {
      // 'crontab' File
      def = i18n("\n\nThis path is system crontab file\n"
                 "vixie-cron's default is /etc/crontab.");
      cap = i18n("System crontab");
      QFileInfo fi( cronTab->sysLed->text() );
      if ( fi.exists() ){
        if ( fi.isReadable() && fi.isWritable() ){
          s = i18n("you can read/write the file.");
        }else if ( fi.isReadable() ){
          s = i18n("you cannot write the file.");
        }else if ( fi.isWritable() ){
          s = i18n("you can write the file.");
        }else{
          s = i18n("you cannot access the file.");
        }
        QMessageBox::information( this, cap, i18n("System crontab File Found.\n") + s + def );
      }else{
        QMessageBox::critical( this, cap,
          i18n("system crontab file not found.") + def );
      }
    }
    break;
#endif
  }

}

//
// - 'anacron' Tab Slots -
//
// Path Check Action
//    'anacrontab' File, 'anacron' Spool Path
void ConfDlg::slotAnacPathCheck( int idx )
{

  QString def;
  QString cap;
  QString s;
  switch( idx ){
    case 0:
    {
      // 'anacrontab' File
      def = i18n("\n\nThis is system anacrontab file\n"
                 "default is /etc/anacrontab.");
      cap = i18n("System anacrontab File");
      QFileInfo fi( anacTab->sysLed->text() );
      if ( fi.exists() ){
        if ( fi.isReadable() && fi.isWritable() ){
          s = i18n("you can read/write the file.");
        }else if ( fi.isReadable() ){
          s = i18n("you cannot write the file.");
        }else if ( fi.isWritable() ){
          s = i18n("you can write the file.");
        }else{
          s = i18n("you cannot access the file.");
        }
        QMessageBox::information( this, cap, i18n("File Found\n") + s + def );
      }else{
        QMessageBox::critical( this, cap, i18n("File Not Found !") + def );
      }
    }
    break;
    case 1:
    {
      def = i18n("\n\nThis path is anacron spool path.\n"
                 "default is /var/spool/anacron.");
      cap = i18n("Spool Path");
      if ( QFileInfo(anacTab->spoolLed->text()).exists() ){
        QMessageBox::information( this, cap, i18n("Path Found.") + def );
      }else{
        QMessageBox::critical( this, cap, i18n("Path Not Found.") + def );
      }
    }
    break;
  }

}

//
// - 'at' Tab Slots -
//
// Allow/Deny Button Group
void ConfDlg::slotAtUserAccess( int idx )
{

  switch ( idx ){
    case 0:
      // All
      atTab->usrBtn->setEnabled( false );
      atTab->atUser = ALL_USER;
      break;
    case 1:
      // Allow
      atTab->usrBtn->setEnabled( true );
      atTab->atUser = ALLOW_USER;
      break;
    case 2:
      // Deny
      atTab->usrBtn->setEnabled( true );
      atTab->atUser = DENY_USER;
      break;
    case 3:
      // User Select Dialog
      UserDlg* dlg = new UserDlg( atTab->atUser, atTab->atUsers );
      if ( dlg->exec() == QDialog::Accepted ){
        atTab->atUsers->clear();
        if ( ! atTab->atUserChg ) atTab->atUserChg = dlg->chgFlg;
        if ( atTab->atUser == ALLOW_USER ){
          for( int i=0; i<dlg->setLbx->numRows(); i++ ){
            atTab->atUsers->append( dlg->setLbx->text(i) );
          }
        }else if ( atTab->atUser == DENY_USER ){
          for( int i=0; i<dlg->allLbx->numRows(); i++ ){
            atTab->atUsers->append( dlg->allLbx->text(i) );
          }
        }
      }
      delete dlg;
      break;
  }


}

// Path Check Action
//    'at' allow/deny File Path
void ConfDlg::slotAtPathCheck( int /** idx */ )
{

  QString s;
  QString def = i18n("\n\nThis path is at.allow/at.deny file setted\n"
                     "default is /etc.");
  QString cap = i18n("at Path");
  int ac = System::access( atTab->pathLed->text() );
  if ( ac & FILE_EXIST ){
    if ( ac & CAN_READ && ac & CAN_WRITE ){
      s = i18n("you can read/write the file.");
    }else if ( ac & CAN_READ ){
      s = i18n("you cannot write the file.");
    }else if ( ac & CAN_WRITE ){
      s = i18n("you can write the file.");
    }else{
      s = i18n("you cannot access the file.");
    }
    QMessageBox::information( this, cap, i18n("Path Found\n") + s + def );
  }else{
    QMessageBox::critical( this, cap, i18n("Path Not Found.") + def );
  }

}

//
// - Configure Slots -
//
// OK Button Action
void ConfDlg::slotApply()
{
  bool b;
  int  n;
  QString s;

  // ----- General Configure Tab -----
  // Use Anac
  b = genTab->anacCbx->isChecked();
  if ( b != g_Option->useAnacron ) chgFlag |= CHG_ANAC;
  g_Option->useAnacron = b;

  // Use At
  g_Option->useAt = genTab->atCbx->isChecked();

#ifndef CRON_DILLON
  // Use System Crontab
  b = genTab->scronCbx->isChecked();
  if ( b != g_Option->useSyscron ) chgFlag |= CHG_CRON;
  g_Option->useSyscron = b;
#endif
    
  // Execute List Max
  n = genTab->exeSbx->value();
  if ( n != g_Option->exeListMax ) chgFlag |= CHG_ELIST;
  g_Option->exeListMax = n;

  // Execute List Date Max
  b = genTab->edayCbx->isChecked();
  n = genTab->edaySbx->value();
  if ( b != g_Option->useExeDay ){
    chgFlag |= CHG_ELIST;
  }else{
    if ( b && n != g_Option->exeDayMax ) chgFlag |= CHG_ELIST;
  }
  g_Option->useExeDay = b;
  g_Option->exeDayMax = n;

#ifndef CRON_DILLON
  // Log List Max
  n = genTab->logSbx->value();
  if ( n != g_Option->logListMax ) chgFlag |= CHG_LLIST;
  g_Option->logListMax = n;
  
  // Log File Name
  s = genTab->logLed->text();
  if ( s != g_Option->logFile ) chgFlag |= CHG_LLIST;
  g_Option->logFile = s;
#endif

  // Clock Image File
  s = genTab->clockCbb->currentText();
  if ( g_Option->clockImage != s ) chgFlag |= CHG_CLOCK;
  g_Option->clockImage =s;

  // Sound
  g_Option->useSound = genTab->soundCbx->isChecked();
  g_Option->soundSec = genTab->soundSbx->value();
  g_Option->soundName = genTab->soundCbb->currentText();

  // Rest Display Mode
  if ( genTab->dayRdb->isChecked() ) g_Option->restMode = 1;
  else if ( genTab->hourRdb->isChecked() ) g_Option->restMode = 2;
  else g_Option->restMode = 3;

  // Use WeekDay
  b = genTab->weekdayCbx->isChecked();
  if ( b != g_Option->ponWeekDay ) chgFlag |= CHG_LIST;
  g_Option->ponWeekDay = b;

  // Power On Time
  if ( g_Option->ponTime != genTab->timeTme->time() ){
    chgFlag |= CHG_LIST;
    g_Option->ponTime = genTab->timeTme->time();
  }

#ifndef CRON_DILLON
  // Automatic Log List Update
  g_Option->autoModLog = genTab->alogCbx->isChecked();
#endif
  

  // ----- 'cron' Configure Tab -----
  // Cron Path
  g_Option->cronLiteral = cronTab->litCbx->isChecked();
  g_Option->cronPath = cronTab->cronLed->text();        // 'cron' root directory
  g_Option->cronPathSpool = cronTab->spoolLed->text();  // 'cron' spool directroy
#ifndef CRON_DILLON
  g_Option->cronFileAllow = cronTab->allowLed->text();  // allow file name
  g_Option->cronFileDeny = cronTab->denyLed->text();    // deny file name
  g_Option->cronFileSys = cronTab->sysLed->text();      // system 'crontab' file
#endif

  // Allow Users
  if ( g_Option->cronUser != cronTab->cronUser || cronTab->cronUserChg ){
    bool ret;
#ifdef CRONONLYROOT
    ret = System::saveUsers( cronTab->cronUser, cronTab->cronUsers, g_Option->cronFileAllow, g_Option->cronFileDeny );
#else
    if ( cronTab->cronUser  == ALL_USER ) {
      QStringList s = System::allUsers();
      ret = System::saveUsers( DENY_USER, &s, g_Option->cronFileAllow, g_Option->cronFileDeny );
    }else{
      ret = System::saveUsers( cronTab->cronUser, cronTab->cronUsers, g_Option->cronFileAllow, g_Option->cronFileDeny );
    }
#endif
    if ( ! ret ){
        QMessageBox::critical( this, i18n("File Error"), i18n("Can't Update Allow/Deny File.") );
    }

    chgFlag |= CHG_CRON;
  }
  g_Option->cronUser = cronTab->cronUser;

  // 'cron' New Data Template
  g_Option->cronNewHead = cronTab->headTed->text();
  g_Option->cronNewCmnd = cronTab->cmndTed->text();

  // ----- 'anacron' Configure Tab -----
  // Display Execute List
  if ( System::getAnacStatus() & ANAC_INSTALLED ){
    b = anacTab->dspexeCbx->isChecked();
    if ( b != g_Option->anacListDisp ) chgFlag |= CHG_ELIST;
    g_Option->anacListDisp = b;

    // Anacron Path
    g_Option->anacFileSys = anacTab->sysLed->text();      // System 'anacrontab' file
    g_Option->anacPathSpool = anacTab->spoolLed->text();  // Spool path

    // 'anacron' New Data Template
    g_Option->anacNewHead = anacTab->headTed->text();
    g_Option->anacNewCmnd = anacTab->cmndTed->text();
  }
    
  // ----- 'at' Configure Tab -----
  // Display Execute List
  b = atTab->dspexeCbx->isChecked();
  if ( b != g_Option->atDispExe ) chgFlag |= CHG_ELIST;
  g_Option->atDispExe = b;

  // At Path
  g_Option->atPath = atTab->pathLed->text();            // at.allow/at.deny path
  g_Option->atFileAllow = g_Option->atPath + "/at.allow";
  g_Option->atFileAllow = g_Option->atPath + "/at.deny";

  // Allow Users
  if ( g_Option->atUser != atTab->atUser || atTab->atUserChg ){
    bool ret;
    if ( atTab->atUser  == ALL_USER ) {
      QStringList s = System::allUsers();
      ret = System::saveUsers( DENY_USER, &s,
        g_Option->atFileAllow, g_Option->atFileDeny );
    }else{
      ret = System::saveUsers( atTab->atUser, atTab->atUsers,
        g_Option->atFileAllow , g_Option->atFileDeny );
    }
    if ( ! ret ){
        QMessageBox::critical( this, i18n("File Error"), i18n("Can't Update Allow/Deny File.") );
    }
    chgFlag |= CHG_LIST;
  }
  g_Option->atUser = atTab->atUser;
  if ( atEnable != System::atEnable() ) chgFlag |= CHG_AT;

  // 'at' New Data Template
  g_Option->atNewCmnd = atTab->cmndTed->text();
  g_Option->atNewTime = atTab->delaySpb->value();
  g_Option->atNewMail = atTab->monRbt->isChecked();

  if ( chgFlag & CHG_LIST ) chgFlag |= CHG_ELIST;

}
