/***************************************************************************
                          kronekodoc.h  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRONEKODOC_H
#define KRONEKODOC_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for QT
#include <qobject.h>
#include <qstring.h>
#include <qlist.h>
#include <qthread.h>
#include <qlistview.h>
#include <qdatetime.h>

// include files for KDE

// forward declaration of the Kroneko classes
class KronekoApp;
class KronekoView;
class CronTbl;
class UserTbl;
class AnacTbl;
class AtTbl;
class TabLvi;

#ifdef CRON_DILLON
enum LISTTAB  { LIST_NONE, LIST_STNG, LIST_EXEC };
#else
enum LISTTAB  { LIST_NONE, LIST_STNG, LIST_EXEC, LIST_LOG };
#endif
enum VIEWTAB  { VIEW_NONE, VIEW_CLOCK, VIEW_DETAIL, VIEW_EDIT };

#define RUN_GET           0x01
#define RUN_LIST_EXEC     0x02
#ifndef CRON_DILLON
#define RUN_LIST_LOG      0x04
#endif
#define RUN_LIST_TIME     0x08
#define RUN_EXIT          0x10
#define RUN_INIT          ( RUN_GET | RUN_LIST_EXEC )

/**	KronekoDoc provides a document object for a document-view model.
  *
  * The KronekoDoc class provides a document object that can be used in conjunction with the classes KronekoApp and KronekoView
  * to create a document-view model for standard KDE applications based on KApplication and KMainWindow. Thereby, the document object
  * is created by the KronekoApp instance and contains the document structure with the according methods for manipulation of the document
  * data by KronekoView objects. Also, KronekoDoc contains the methods for serialization of the document data from and to files.
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team. 	
  * @version KDevelop version 1.2 code generation
  */
class KronekoDoc : public QObject, public QThread
{
  Q_OBJECT
  public:
    /** Constructor for the fileclass of the application */
    KronekoDoc(QWidget *parent, const char *name=0);
    /** Destructor for the fileclass of the application */
    ~KronekoDoc();

    /** Initialize 'cron' Table */
    void getCron( const QString& usr="" );
    /** Initialize 'anacron' Table */
    void getAnac();
    /** Initialize 'at' Table */
    void getAt();
    /** Rid '#' from Comment String */
    QString setComment( const QString& s );
    void dspErrText( const QString& s, int line );

    /** Initialize View */
    void setView(KronekoView *view);
    /** Set Execute List View */
    void setExecView();
    /** Set Log List View */
    void setLogView();

    /** Save 'cron' Data */
    void saveCron();
    /** Save 'anacron' Data */
    void saveAnac();
    /** Save 'at' Data */
    void saveAt();

    /** Add New 'cron' Data to Table */
    void newCron();
    void newCronUser( UserTbl* u );
    /** Add New 'anacron' Data to Table */
    void newAnac();
    /** Add New 'at' Data to Table */
    void newAt();

    /** Check 'crontab' Data */
    QString chkCron( CronTbl* cr );
    /** Check 'anacrontab' Data */
    QString chkAnac( AnacTbl* an, bool newdata );
    /** Check 'at' Data */
    bool chkAt( AtTbl* at );

    // Check 'cron' Time Format
    bool chkCronForm( const QString& str );
    
    // Check 'cron' Time
    bool chkCronTime( const QString& str, int mx );
    
    /** Reset Flag */
    void resetFlag();
    /** Convert Comment String */
    QString cnvComment( const QString& s );
    QString cnvCommentU( const QString& s, const QString& u );

    /** Edit Select Item */
    void editSelect();

    /** Edit Select Time */
    void editTime();

    void dispExe( bool flg );

    /** Check Outdate */
    bool checkModify();

    /** Initialize View Tab data */
    void dspView();

    /** Display Statistic Information */
    void dspDetail();

    /** Display Progress Bar's Current Position */
    void dspProgress( double dp );

    /** Display Status Message */
    void dspStatusMsg( const QString& m );

    /** Thread Restart from Waiting Condition */
    void pStart( int mode );

    /** Thread Start */
    virtual void run();

    /** Get KronekoApp */
    KronekoApp* getApp() { return (KronekoApp *) parent(); }

  public:
    /** ViewWidget Pointer **/
    KronekoView *view;

    /** User Table */
    QPtrList<UserTbl> userTbl;
    /** 'cron' Table */
    QPtrList<CronTbl> cronTbl;
    /** 'anacron' Table */
    QPtrList<AnacTbl> anacTbl;
    /** 'at' Table */
    QPtrList<AtTbl>   atTbl;

    /** Editing 'cron' Data */
    CronTbl   *curEditCron;
    /** Editing 'anacron' Data */
    AnacTbl   *curEditAnac;
    /** Editing 'at' Data */
    AtTbl     *curEditAt;
    /** Created 'cron' Data */
    CronTbl   *newEditCron;
    /** Created 'anacron' Data */
    AnacTbl   *newEditAnac;
    /** Created 'at' Data */
    AtTbl     *newEditAt;
    /** Selecting Setting List */
    TabLvi    *curStngItem;
    /** Selecting Execute List */
    TabLvi    *curExecItem;
    /** Selecting Log List */
    TabLvi    *curLogItem;
    /** Current List Tab */
    LISTTAB   curList;
    /** Current View */
    VIEWTAB   curView;
    /** Last Execute Time */
    QDateTime endExe;
    /** Last Log Time */
    QDateTime endLog;
    
    /** Thread Run Mode */
    int       runMode;
    /** Setting 'cron' User Num */
    int       cronUserNum;
    /** Setting 'at' User Num */
    int       atUserNum;
    /** Update status */
    bool      bUpdate;

  protected:
    // Timer Event ( Every 1 Second )
    void timerEvent( QTimerEvent * );

  public slots:
    /** calls repaint() on all views connected to the document object and is called by the view by which the document has been changed.
     * As this view normally repaints itself, it is excluded from the paintEvent.
     */
    //------- StngLvw -------
    /** Setting ListView Selection Changed */  
    void slotStngListChanged(QListViewItem *i);
    //------- ExecLvw -------
    /** Execute ListView Selection Changed */
    void slotExecListChanged(QListViewItem *i);
    //------- LogLvw -------
    /** Log ListView Selection Changed */
    void slotLogListChanged(QListViewItem *i);
    //------- listTab -------
    /** List Tab Item Changed */
    void slotListTabChanged(QWidget *w);
    //------- viewTab -------
    /** View Tab Item Changed */
    void slotViewTabChanged(QWidget *w);
    
    //------- StngLvw,ExecLvw -------
    /** Edit Data (List View Doubled Clicked) */
    void slotListEdit(QListViewItem *i);

    ////////////////////////////////////////////
    //------- CronEditWgt -------
    /** Comment Changed */
    void slotCronCmntChanged();
    /** Command Changed */
    void slotCronCmndChanged( const QString & s );
    /** Time Changed */
    void slotCronTimeChanged( const QString & s );
    /** Time Edit Button */
    void slotCronTimeEdit();
    /** File Select Changed */
    void slotCronFileChange( int i);
    /** User Select Changed */
    void slotCronUserChange( const QString & s );
    /** Varialble Button */
    void slotCronVarDlg();
    /** Modify Button */
    void slotCronModify();
    /** Create Button */
    void slotCronCreate();
    /** Delete Button */
    void slotCronDelete();
    /** Execute Button */
    void slotCronExecute();

    ////////////////////////////////////////////
    //------- AnacEditWgt -------
    /** Comment Changed */
    void slotAnacCmntChanged();
    /** Command Changed */
    void slotAnacCmndChanged( const QString & s );
    /** Ident Changed */
    void slotAnacIdentChanged( const QString & s );
    /** Period Changed */
    void slotAnacPeriodChanged( int v );
    /** Delay Changed */
    void slotAnacDelayChanged( int v );
    /** Variable Button */
    void slotAnacVarDlg();
    /** Modify Button */
    void slotAnacModify();
    /** Create Button */
    void slotAnacCreate();
    /** Delete Button */
    void slotAnacDelete();
    /** Execute Button */
    void slotAnacExecute();

    ////////////////////////////////////////////
    //------- AnacEditWgt -------
    /** Command Changed */
    void slotAtCmndChanged();
    /** Time Changed */
    void slotAtTimeChanged( const QString & s );
    /** Time Button */
    void slotAtTimeEdit();
    /** Queue Changed */
    void slotAtQueChanged( const QString & s );
    /** Mail On */
    void slotAtMailOn();
    /** Mail Off */
    void slotAtMailOff();
    /** Modify Button */
    void slotAtModify();
    /** Create Button */
    void slotAtCreate();
    /** Delete Button */
    void slotAtDelete();
    /** Execute Button */
    void slotAtExecute();
    
};

#endif // KRONEKODOC_H
