/***************************************************************************
                          kronekoview.h  -  description
                             -------------------
    begin                :   2  8 00:43:28 JST 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRONEKOVIEW_H
#define KRONEKOVIEW_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

// include files for Qt
#include <qwidget.h>


class KronekoDoc;
class QTabWidget;
class StngLvw;
class ExecLvw;
class LvDraft;
class LogLvw;
class ClockWgt;
class DetailWgt;
class CronEditWgt;
class AnacEditWgt;
class AtEditWgt;


/** The KronekoView class provides the view widget for the KronekoApp instance.	
 * The View instance inherits QWidget as a base class and represents the view object of a KTMainWindow. As KronekoView is part of the
 * docuement-view model, it needs a reference to the document object connected with it by the KronekoApp class to manipulate and display
 * the document structure provided by the KronekoDoc class.
 * 	
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */
class KronekoView : public QWidget
{
  public:
    /** Constructor for the main view */
    KronekoView(QWidget *parent = 0, const char *name=0);
    /** Destructor for the main view */
    ~KronekoView() {}

    /** List Tab (Setting,Execute,Log) */
    QTabWidget  *listTab;
    /** View Tab (Clock,Detail,cron Edit, anacron Edit, at Edit ) */
    QTabWidget  *viewTab;
    
    /** Setting List */
    StngLvw     *stngLvw;
    /** Execute List */
    ExecLvw     *execLvw;
    /** Log List */
    LogLvw      *logLvw;

    /** Clock View */
    ClockWgt    *clockWgt;
    /** Detail View */
    DetailWgt   *detailWgt;
    /** 'cron' Edit */
    CronEditWgt *cronEditWgt;
    /** 'anacron' Edit */
    AnacEditWgt *anacEditWgt;
    /** 'at' Edit */
    AtEditWgt   *atEditWgt;

#ifndef CRON_DILLON
    // Log List flag
    bool        logListEnable;
#endif
    
  private:
	
};

#endif // KRONEKOVIEW_H
