/***************************************************************************
                          option.h  -  description
                             -------------------
    begin                :   2 8 2003
    copyright            : (C) 2003 by kobayashi
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OPTION_H
#define OPTION_H
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for Qt
#include <qdatetime.h>

#define   ALL_USER    0
#define   ALLOW_USER  1
#define   DENY_USER   2

class QTime;


class Option
{
public :

// for General
  bool      useAt;          // 'at' enable/dislable
  bool      useAnacron;     // 'anacron' enable/disalbe
#ifndef CRON_DILLON
  bool      useSyscron;     // '/etc/crontab' enable/disable
#endif
  bool      useSound;       // Play sound before job execute
  bool      runeOfDay;      // Display start up 'tips'
  bool      ponWeekDay;     // Sunday & Monday are Holiday
  bool      autoModLog;     // Automatic Modify Log List
  int       exeListMax;     // Execute list max number
#ifndef CRON_DILLON
  int       logListMax;     // Log List max number
#endif
  int       soundSec;       // Minutes before Execute
  bool      useExeDay;      // Use Maximum Date
  int       exeDayMax;      // Maximum Date from Today
  int       restMode;       // Rest Time Display Mode (1:day,2:hour,3:minute)
  QString   clockImage;     // Clock Image File
  QString   soundName;      // Wave FIle
  QString   logFile;        // Log Name
  QTime     ponTime;    // Machine power on (for execute list)

// for 'cron'
  bool      cronLiteral;    // Literal Format ex. sun, jun..
  QString   cronPath;       // 'cron' root directory
  QString   cronPathSpool;  // 'cron' spool directroy
  QString   cronFileAllow;  // allow file name
  QString   cronFileDeny;   // deny file name
  QString   cronFileSys;    // system 'crontab' file
  QString   cronNewHead;    // cron template - header
  QString   cronNewCmnd;    //  - command
  int       cronUser;       // All User / Allow User / Deny User

// for 'anacron'
                            // for execute list
  bool      anacListDisp;   // 'anacron' display execute list
  QString   anacFileSys;    // System 'anacrontab' file
  QString   anacPathSpool;  // Spool path
  QString   anacNewHead;    // 'anacron' template - header
  QString   anacNewCmnd;    //  - command

// for 'at'
  bool      atDispExe;      // 'anacron' display execute list
  QString   atPath;         // at.allow/at.deny path
  QString   atFileAllow;    // allow file name
  QString   atFileDeny;     // deny file name
  int       atUser;         // All User / Allow User / Deny User
  int       atNewTime;      // create delay time
  bool      atNewMail;      // create main on/off
  QString   atNewCmnd;      // 'at' template

};

#endif // OPTION_H
