using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Threading;

namespace SlowTime
{
    // 
    // Microsoft OfficeCXg[ĂKv܂B
    public partial class Form1 : Form
    {
        private bool loopFlag = false;
        private int waitMs;
        private int backMs;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            btnStart.Enabled = false;

            waitMs = Convert.ToInt32(numWait.Value);
            backMs = Convert.ToInt32(numBack.Value);

            AddMessage(DateTime.Now);

            loopFlag = true;
            Thread thread = new Thread(new ThreadStart(this.UpdateLoop));
            thread.IsBackground = true;
            thread.Start();

            btnStop.Enabled = true;
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            btnStop.Enabled = false;

            loopFlag = false;
            AddMessage(DateTime.Now);

            btnStart.Enabled = true;
        }

        private void UpdateLoop()
        {
            while (loopFlag)
            {
                Thread.Sleep(waitMs);

                //VXe擾
                DateTime dateTime = DateTime.Now;

                //VXeύX
                dateTime = dateTime.AddMilliseconds(-backMs);
                Microsoft.VisualBasic.DateAndTime.TimeOfDay = dateTime;
            }
        }

        private void AddMessage(DateTime dateTime)
        {
            AddMessage(dateTime.ToString("yyyy/MM/dd HH:mm:ss"));
        }

        private void AddMessage(String msg)
        {
            textBox1.Text += msg + "\r\n";
            textBox1.Select(textBox1.Text.Length, 0);
            textBox1.ScrollToCaret();
        }
    }
}