/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class C {

  static final String cr = "\r\n";
  static final String cr2 = cr + cr;
  static final int CUSTOM_DATE_TIME_HCM = 0, CUSTOM_DATE_TIME_COMMA = 1, CUSTOM_DATE_TIME_TSUKI_BYOU = 2;
  private static Log log = null;
  
  static void p(String msg){ System.out.println(msg); }
  static void pd(String msg){ C.p("debug: " + msg); }
  static void throwException(String msg) throws Exception{ throw new Exception(msg + cr); }
  static void throwException(String msg, String s) throws Exception{ throw new Exception(msg + " " + s + cr); }
  static void throwException(String msg, Exception e) throws Exception{
    throw new Exception(msg + " " + e.toString() + cr); }
  static void exit(){ System.exit(0); }

  static void openLogFile(String path) throws Exception{
    try{
      log = new Log(path);
    }catch(Exception e){
      C.throwException("C: openLogFile:", e);
    }
  }

  static boolean confirm(String msg){
    return (JOptionPane.showConfirmDialog(null, msg, "mF", JOptionPane.YES_NO_OPTION)
            == JOptionPane.YES_OPTION) ? true : false;
  }

  static void info(String msg){
    JOptionPane.showMessageDialog(null, msg, "", JOptionPane.INFORMATION_MESSAGE);
  }

  static void error(String msg){
    C.log("Error: " + msg);
    JOptionPane.showMessageDialog(null, msg, "G[", JOptionPane.ERROR_MESSAGE);
  }

  static void d(String msg){ C.log("Debug: " + msg); }
  static void e(String msg){ C.log("Error: " + msg); }

  static void log(String msg){
    try{
      log.write(msg);
    }catch(Exception e){
      JOptionPane.showMessageDialog(null, "C: log: " + cr2 + e.toString(), "G[", JOptionPane.ERROR_MESSAGE);
    }
  }

  static public void sleep(int msec){
    try{
      Thread.sleep(msec);
    }catch(Exception e){}
  }

  static String getExecDir() throws Exception{
    String ret = null;
    try{
      String s = C.class.getClassLoader().getResource("C.class").toString();
      // debug: jar:file:/C:/tmp/snapshot.jar!/C.class
      Matcher m = Pattern.compile("jar:file:/(.+)/.+\\.jar").matcher(s);
      if(m.find())
        ret = m.group(1).replace('/', '\\');
    }catch(Exception e){
      C.throwException("C: getExecDir:", e);
    }
    return ret;
  }

  static String getDateTimeString(){
    Calendar c = Calendar.getInstance();
    int y = c.get(Calendar.YEAR), mo = c.get(Calendar.MONTH) +1 , d = c.get(Calendar.DATE),
        h = c.get(Calendar.HOUR_OF_DAY), m = c.get(Calendar.MINUTE), s = c.get(Calendar.SECOND);
    return String.format("%04d%02d%02d-%02d%02d%02d", y, mo, d, h, m, s);
  }

  static String getCustomDateTimeString(int customDateTime){
    Calendar c = Calendar.getInstance();
    int y = c.get(Calendar.YEAR), mo = c.get(Calendar.MONTH) +1 , d = c.get(Calendar.DATE),
      h = c.get(Calendar.HOUR_OF_DAY), m = c.get(Calendar.MINUTE), s = c.get(Calendar.SECOND);
    switch(customDateTime){
    case CUSTOM_DATE_TIME_HCM: return String.format("%02d:%02d", h, m);
    case CUSTOM_DATE_TIME_COMMA: return String.format("%04d/%02d/%02d,%02d:%02d:%02d", y, mo, d, h, m, s);
    case CUSTOM_DATE_TIME_TSUKI_BYOU: return String.format("%02d%02d%02d%02d%02db", mo, d, h, m, s);
    }
    return "";
  }

  static public String getHardwareInfo(){
    String str = "";
    try {
      str += "Hardware Info ---" + cr;
      Enumeration en = NetworkInterface.getNetworkInterfaces();
      while(en.hasMoreElements()){
        NetworkInterface ni = (NetworkInterface)en.nextElement();
        byte[] ma = ni.getHardwareAddress();
        if(ma != null){
          str += "Hardware Address: ";
          for(int i = 0; i < ma.length; i++)
            str += String.format("%02x", ma[i]);
          str += cr;
        }
        str += "Name: " + ni.getName() + cr;
        str += "Display Name: " + ni.getDisplayName() + C.cr;
        Enumeration ea = ni.getInetAddresses();
        while(ea.hasMoreElements()){
          InetAddress ia = (InetAddress)ea.nextElement();
          String ip = ia.getHostAddress();
          str += "Host Address: " + ip + C.cr;
        }
        str += "---" + cr;
      }
    }catch(Exception e){
      str += "error 2" + e.toString();
    }
    return str;
  }

  static public String getStudentNo(String userId){
    String no = userId;
    return no;
  }

}
