/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.io.File;
import java.io.FileWriter;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ClientCanvas extends BaseCanvas {

  private String helpStringNormal =
    "N ... No Ȕԍēx͂\n";

  public ClientCanvas(Snapshot _snapshot) throws Exception{
    super(_snapshot);
  }

  void viewHelp(){
    JOptionPane.showMessageDialog(null, helpString + helpStringNormal, "wv", JOptionPane.PLAIN_MESSAGE);
  }

  public void keyReleasedNormal(int key, int modifiers){
    switch(key){
    case KeyEvent.VK_N:
      try{
        snapshot.client.seat.select();
        snapshot.client.fileCom.writeSeat(snapshot.client.seat.get());
      }catch(Exception e){
        C.error("ClientCanvas: keyReleasedNormal: " + e.toString());
      }
      break;
    default:
      super.keyReleasedNormal(key, modifiers);
      break;
    }
  }

}
