/*
Copyright (C) 2012-2013 Taisuke Kobayashi
    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
import java.io.FileWriter;

public class Log {

  private FileWriter fw;

  public Log(String path) throws Exception{
    try{
      fw = new FileWriter(path, true);
    }catch(Exception e){
      C.throwException("Log: Log:", e);
    }
  }

  public void write(String msg) throws Exception{
    try{
      String s = String.format("%s %s%s", C.getDateTimeString(), msg, C.cr);
      fw.write(s, 0, s.length());
      fw.flush();
    }catch(Exception e){
      C.throwException("Log: write:", e);
    }
  }

}
