/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.pathfinding.Node;
import com.l2jserver.gameserver.pathfinding.cellnodes.CellPathFinding;
import com.l2jserver.util.Point3D;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class GeoEngine
extends GeoData {
    private static Logger _log = Logger.getLogger(GeoData.class.getName());
    private static final byte _e = 1;
    private static final byte _w = 2;
    private static final byte _s = 4;
    private static final byte _n = 8;
    private static Map<Short, MappedByteBuffer> _geodata = new FastMap();
    private static Map<Short, IntBuffer> _geodataIndex = new FastMap();
    private static BufferedOutputStream _geoBugsOut;

    public static GeoEngine getInstance() {
        return SingletonHolder._instance;
    }

    private GeoEngine() {
        GeoEngine.nInitGeodata();
    }

    @Override
    public short getType(int x, int y) {
        return GeoEngine.nGetType(x - -327680 >> 4, y - -262144 >> 4);
    }

    @Override
    public short getHeight(int x, int y, int z) {
        return GeoEngine.nGetHeight(x - -327680 >> 4, y - -262144 >> 4, z);
    }

    @Override
    public short getSpawnHeight(int x, int y, int zmin, int zmax, int spawnid) {
        return GeoEngine.nGetSpawnHeight(x - -327680 >> 4, y - -262144 >> 4, zmin, zmax, spawnid);
    }

    @Override
    public String geoPosition(int x, int y) {
        int gx = x - -327680 >> 4;
        int gy = y - -262144 >> 4;
        return "bx: " + GeoEngine.getBlock(gx) + " by: " + GeoEngine.getBlock(gy) + " cx: " + GeoEngine.getCell(gx) + " cy: " + GeoEngine.getCell(gy) + "  region offset: " + GeoEngine.getRegionOffset(gx, gy);
    }

    @Override
    public boolean canSeeTarget(L2Object cha, Point3D target) {
        if (DoorTable.getInstance().checkIfDoorsBetween(cha.getX(), cha.getY(), cha.getZ(), target.getX(), target.getY(), target.getZ(), cha.getInstanceId())) {
            return false;
        }
        if (cha.getZ() >= target.getZ()) {
            return this.canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), target.getX(), target.getY(), target.getZ());
        }
        return this.canSeeTarget(target.getX(), target.getY(), target.getZ(), cha.getX(), cha.getY(), cha.getZ());
    }

    @Override
    public boolean canSeeTarget(L2Object cha, L2Object target) {
        if (cha == null || target == null) {
            return false;
        }
        int z = cha.getZ() + 45;
        if (cha instanceof L2DefenderInstance) {
            z += 30;
        }
        int z2 = target.getZ() + 45;
        if (!(target instanceof L2DoorInstance) && DoorTable.getInstance().checkIfDoorsBetween(cha.getX(), cha.getY(), z, target.getX(), target.getY(), z2, cha.getInstanceId())) {
            return false;
        }
        if (target instanceof L2DoorInstance) {
            return true;
        }
        if (target instanceof L2DefenderInstance) {
            z2 += 30;
        }
        if (cha.getZ() >= target.getZ()) {
            return this.canSeeTarget(cha.getX(), cha.getY(), z, target.getX(), target.getY(), z2);
        }
        return this.canSeeTarget(target.getX(), target.getY(), z2, cha.getX(), cha.getY(), z);
    }

    @Override
    public boolean canSeeTargetDebug(L2PcInstance gm, L2Object target) {
        int z = gm.getZ() + 45;
        int z2 = target.getZ() + 45;
        if (target instanceof L2DoorInstance) {
            gm.sendMessage("door always true");
            return true;
        }
        if (gm.getZ() >= target.getZ()) {
            return GeoEngine.canSeeDebug(gm, gm.getX() - -327680 >> 4, gm.getY() - -262144 >> 4, z, target.getX() - -327680 >> 4, target.getY() - -262144 >> 4, z2);
        }
        return GeoEngine.canSeeDebug(gm, target.getX() - -327680 >> 4, target.getY() - -262144 >> 4, z2, gm.getX() - -327680 >> 4, gm.getY() - -262144 >> 4, z);
    }

    @Override
    public short getNSWE(int x, int y, int z) {
        return this.nGetNSWE(x - -327680 >> 4, y - -262144 >> 4, z);
    }

    @Override
    public boolean canMoveFromToTarget(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        Location destiny = this.moveCheck(x, y, z, tx, ty, tz, instanceId);
        return destiny.getX() == tx && destiny.getY() == ty && destiny.getZ() == tz;
    }

    @Override
    public Location moveCheck(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        Location startpoint = new Location(x, y, z);
        if (DoorTable.getInstance().checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId)) {
            return startpoint;
        }
        Location destiny = new Location(tx, ty, tz);
        return GeoEngine.moveCheck(startpoint, destiny, x - -327680 >> 4, y - -262144 >> 4, z, tx - -327680 >> 4, ty - -262144 >> 4, tz);
    }

    @Override
    public void addGeoDataBug(L2PcInstance gm, String comment) {
        int gx = gm.getX() - -327680 >> 4;
        int gy = gm.getY() - -262144 >> 4;
        int bx = GeoEngine.getBlock(gx);
        int by = GeoEngine.getBlock(gy);
        int cx = GeoEngine.getCell(gx);
        int cy = GeoEngine.getCell(gy);
        int rx = (gx >> 11) + 10;
        int ry = (gy >> 11) + 10;
        String out = rx + ";" + ry + ";" + bx + ";" + by + ";" + cx + ";" + cy + ";" + gm.getZ() + ";" + comment + "\n";
        try {
            _geoBugsOut.write(out.getBytes());
            _geoBugsOut.flush();
            gm.sendMessage("GeoData bug saved!");
        }
        catch (Exception e) {
            e.printStackTrace();
            gm.sendMessage("GeoData bug save Failed!");
        }
    }

    @Override
    public boolean canSeeTarget(int x, int y, int z, int tx, int ty, int tz) {
        return GeoEngine.canSee(x - -327680 >> 4, y - -262144 >> 4, z, tx - -327680 >> 4, ty - -262144 >> 4, tz);
    }

    @Override
    public boolean hasGeo(int x, int y) {
        int gx = x - -327680 >> 4;
        int gy = y - -262144 >> 4;
        short region = GeoEngine.getRegionOffset(gx, gy);
        return _geodata.get(region) != null;
    }

    private static boolean canSee(int x, int y, double z, int tx, int ty, int tz) {
        int dx = tx - x;
        int dy = ty - y;
        double dz = (double)tz - z;
        int distance2 = dx * dx + dy * dy;
        if (distance2 > 90000) {
            return false;
        }
        if (distance2 < 82) {
            short region;
            return !(dz * dz > 22500.0) || _geodata.get(region = GeoEngine.getRegionOffset(x, y)) == null;
        }
        byte inc_x = GeoEngine.sign(dx);
        byte inc_y = GeoEngine.sign(dy);
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        double inc_z_directionx = dz * (double)dx / (double)distance2;
        double inc_z_directiony = dz * (double)dy / (double)distance2;
        int next_x = x;
        int next_y = y;
        if (dx >= dy) {
            int delta_A = 2 * dy;
            int d = delta_A - dx;
            int delta_B = delta_A - 2 * dx;
            for (int i = 0; i < dx; ++i) {
                x = next_x;
                y = next_y;
                if (d > 0) {
                    d += delta_B;
                    next_x += inc_x;
                    if (!GeoEngine.nLOS(x, y, (int)(z += inc_z_directionx), inc_x, 0, inc_z_directionx, tz, false)) {
                        return false;
                    }
                    next_y += inc_y;
                    if (GeoEngine.nLOS(next_x, y, (int)(z += inc_z_directiony), 0, inc_y, inc_z_directiony, tz, false)) continue;
                    return false;
                }
                d += delta_A;
                next_x += inc_x;
                if (GeoEngine.nLOS(x, y, (int)(z += inc_z_directionx), inc_x, 0, inc_z_directionx, tz, false)) continue;
                return false;
            }
        } else {
            int delta_A = 2 * dx;
            int d = delta_A - dy;
            int delta_B = delta_A - 2 * dy;
            for (int i = 0; i < dy; ++i) {
                x = next_x;
                y = next_y;
                if (d > 0) {
                    d += delta_B;
                    next_y += inc_y;
                    if (!GeoEngine.nLOS(x, y, (int)(z += inc_z_directiony), 0, inc_y, inc_z_directiony, tz, false)) {
                        return false;
                    }
                    next_x += inc_x;
                    if (GeoEngine.nLOS(x, next_y, (int)(z += inc_z_directionx), inc_x, 0, inc_z_directionx, tz, false)) continue;
                    return false;
                }
                d += delta_A;
                next_y += inc_y;
                if (GeoEngine.nLOS(x, y, (int)(z += inc_z_directiony), 0, inc_y, inc_z_directiony, tz, false)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canSeeDebug(L2PcInstance gm, int x, int y, double z, int tx, int ty, int tz) {
        int dx = tx - x;
        int dy = ty - y;
        double dz = (double)tz - z;
        int distance2 = dx * dx + dy * dy;
        if (distance2 > 90000) {
            gm.sendMessage("dist > 300");
            return false;
        }
        if (distance2 < 82) {
            short region;
            return !(dz * dz > 22500.0) || _geodata.get(region = GeoEngine.getRegionOffset(x, y)) == null;
        }
        byte inc_x = GeoEngine.sign(dx);
        byte inc_y = GeoEngine.sign(dy);
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        double inc_z_directionx = dz * (double)dx / (double)distance2;
        double inc_z_directiony = dz * (double)dy / (double)distance2;
        gm.sendMessage("Los: from X: " + x + "Y: " + y + "--->> X: " + tx + " Y: " + ty);
        int next_x = x;
        int next_y = y;
        if (dx >= dy) {
            int delta_A = 2 * dy;
            int d = delta_A - dx;
            int delta_B = delta_A - 2 * dx;
            for (int i = 0; i < dx; ++i) {
                x = next_x;
                y = next_y;
                if (d > 0) {
                    d += delta_B;
                    next_x += inc_x;
                    if (!GeoEngine.nLOS(x, y, (int)(z += inc_z_directionx), inc_x, 0, inc_z_directionx, tz, true)) {
                        return false;
                    }
                    next_y += inc_y;
                    if (GeoEngine.nLOS(next_x, y, (int)(z += inc_z_directiony), 0, inc_y, inc_z_directiony, tz, true)) continue;
                    return false;
                }
                d += delta_A;
                next_x += inc_x;
                if (GeoEngine.nLOS(x, y, (int)(z += inc_z_directionx), inc_x, 0, inc_z_directionx, tz, true)) continue;
                return false;
            }
        } else {
            int delta_A = 2 * dx;
            int d = delta_A - dy;
            int delta_B = delta_A - 2 * dy;
            for (int i = 0; i < dy; ++i) {
                x = next_x;
                y = next_y;
                if (d > 0) {
                    d += delta_B;
                    next_y += inc_y;
                    if (!GeoEngine.nLOS(x, y, (int)(z += inc_z_directiony), 0, inc_y, inc_z_directiony, tz, true)) {
                        return false;
                    }
                    next_x += inc_x;
                    if (GeoEngine.nLOS(x, next_y, (int)(z += inc_z_directionx), inc_x, 0, inc_z_directionx, tz, true)) continue;
                    return false;
                }
                d += delta_A;
                next_y += inc_y;
                if (GeoEngine.nLOS(x, y, (int)(z += inc_z_directiony), 0, inc_y, inc_z_directiony, tz, true)) continue;
                return false;
            }
        }
        return true;
    }

    private static Location moveCheck(Location startpoint, Location destiny, int x, int y, double z, int tx, int ty, int tz) {
        int dx = tx - x;
        int dy = ty - y;
        int distance2 = dx * dx + dy * dy;
        if (distance2 == 0) {
            return destiny;
        }
        if (distance2 > 36100) {
            double divider = Math.sqrt(30000.0 / (double)distance2);
            tx = x + (int)(divider * (double)dx);
            ty = y + (int)(divider * (double)dy);
            int dz = tz - startpoint.getZ();
            tz = startpoint.getZ() + (int)(divider * (double)dz);
            dx = tx - x;
            dy = ty - y;
        }
        byte inc_x = GeoEngine.sign(dx);
        byte inc_y = GeoEngine.sign(dy);
        dx = Math.abs(dx);
        dy = Math.abs(dy);
        int next_x = x;
        int next_y = y;
        double tempz = z;
        if (dx >= dy) {
            int delta_A = 2 * dy;
            int d = delta_A - dx;
            int delta_B = delta_A - 2 * dx;
            for (int i = 0; i < dx; ++i) {
                x = next_x;
                y = next_y;
                if (d > 0) {
                    d += delta_B;
                    tempz = GeoEngine.nCanMoveNext(x, y, (int)z, next_x += inc_x, next_y, tz);
                    if (tempz == Double.MIN_VALUE) {
                        return new Location((x << 4) + -327680, (y << 4) + -262144, (int)z);
                    }
                    z = tempz;
                    if ((tempz = GeoEngine.nCanMoveNext(next_x, y, (int)z, next_x, next_y += inc_y, tz)) == Double.MIN_VALUE) {
                        return new Location((x << 4) + -327680, (y << 4) + -262144, (int)z);
                    }
                    z = tempz;
                    continue;
                }
                d += delta_A;
                tempz = GeoEngine.nCanMoveNext(x, y, (int)z, next_x += inc_x, next_y, tz);
                if (tempz == Double.MIN_VALUE) {
                    return new Location((x << 4) + -327680, (y << 4) + -262144, (int)z);
                }
                z = tempz;
            }
        } else {
            int delta_A = 2 * dx;
            int d = delta_A - dy;
            int delta_B = delta_A - 2 * dy;
            for (int i = 0; i < dy; ++i) {
                x = next_x;
                y = next_y;
                if (d > 0) {
                    d += delta_B;
                    tempz = GeoEngine.nCanMoveNext(x, y, (int)z, next_x, next_y += inc_y, tz);
                    if (tempz == Double.MIN_VALUE) {
                        return new Location((x << 4) + -327680, (y << 4) + -262144, (int)z);
                    }
                    z = tempz;
                    if ((tempz = GeoEngine.nCanMoveNext(x, next_y, (int)z, next_x += inc_x, next_y, tz)) == Double.MIN_VALUE) {
                        return new Location((x << 4) + -327680, (y << 4) + -262144, (int)z);
                    }
                    z = tempz;
                    continue;
                }
                d += delta_A;
                tempz = GeoEngine.nCanMoveNext(x, y, (int)z, next_x, next_y += inc_y, tz);
                if (tempz == Double.MIN_VALUE) {
                    return new Location((x << 4) + -327680, (y << 4) + -262144, (int)z);
                }
                z = tempz;
            }
        }
        if (z == (double)startpoint.getZ()) {
            return destiny;
        }
        return new Location(destiny.getX(), destiny.getY(), (int)z);
    }

    private static byte sign(int x) {
        if (x >= 0) {
            return 1;
        }
        return -1;
    }

    private static void nInitGeodata() {
        LineNumberReader lnr = null;
        try {
            _log.info("Geo Engine: - Loading Geodata...");
            File Data = new File("./data/geodata/geo_index.txt");
            if (!Data.exists()) {
                return;
            }
            lnr = new LineNumberReader(new BufferedReader(new FileReader(Data)));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Failed to Load geo_index File.");
        }
        try {
            String line;
            while ((line = lnr.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                StringTokenizer st = new StringTokenizer(line, "_");
                byte rx = Byte.parseByte(st.nextToken());
                byte ry = Byte.parseByte(st.nextToken());
                GeoEngine.loadGeodataFile(rx, ry);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Failed to Read geo_index File.");
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e) {}
        }
        try {
            File geo_bugs = new File("./data/geodata/geo_bugs.txt");
            _geoBugsOut = new BufferedOutputStream(new FileOutputStream(geo_bugs, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error("Failed to Load geo_bugs.txt File.");
        }
    }

    public static void unloadGeodata(byte rx, byte ry) {
        short regionoffset = (short)((rx << 5) + ry);
        _geodataIndex.remove(regionoffset);
        _geodata.remove(regionoffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadGeodataFile(byte rx, byte ry) {
        String fname = "./data/geodata/" + rx + "_" + ry + ".l2j";
        short regionoffset = (short)((rx << 5) + ry);
        _log.info("Geo Engine: - Loading: " + fname + " -> region offset: " + regionoffset + "X: " + rx + " Y: " + ry);
        File Geo = new File(fname);
        int index = 0;
        int block = 0;
        byte flor = 0;
        AbstractInterruptibleChannel roChannel = null;
        try {
            roChannel = new RandomAccessFile(Geo, "r").getChannel();
            int size = (int)((FileChannel)roChannel).size();
            MappedByteBuffer geo = Config.FORCE_GEODATA ? ((FileChannel)roChannel).map(FileChannel.MapMode.READ_ONLY, 0L, size).load() : ((FileChannel)roChannel).map(FileChannel.MapMode.READ_ONLY, 0L, size);
            geo.order(ByteOrder.LITTLE_ENDIAN);
            if (size > 196608) {
                IntBuffer indexs = IntBuffer.allocate(65536);
                while (block < 65536) {
                    byte type = geo.get(index);
                    indexs.put(block, index);
                    ++block;
                    ++index;
                    if (type == 0) {
                        index += 2;
                        continue;
                    }
                    if (type == 1) {
                        index += 128;
                        continue;
                    }
                    for (int b = 0; b < 64; ++b) {
                        byte layers = geo.get(index);
                        index += (layers << 1) + 1;
                        if (layers <= flor) continue;
                        flor = layers;
                    }
                }
                _geodataIndex.put(regionoffset, indexs);
            }
            _geodata.put(regionoffset, geo);
            _log.info("Geo Engine: - Max Layers: " + flor + " Size: " + size + " Loaded: " + index);
        }
        catch (Exception e) {
            e.printStackTrace();
            _log.warning("Failed to Load GeoFile at block: " + block + "\n");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                roChannel.close();
            }
            catch (Exception e) {}
        }
        return true;
    }

    private static short getRegionOffset(int x, int y) {
        int rx = x >> 11;
        int ry = y >> 11;
        return (short)((rx + 10 << 5) + (ry + 10));
    }

    private static int getBlock(int geo_pos) {
        return (geo_pos >> 3) % 256;
    }

    private static int getCell(int geo_pos) {
        return geo_pos % 8;
    }

    private static short nGetType(int x, int y) {
        short region = GeoEngine.getRegionOffset(x, y);
        int blockX = GeoEngine.getBlock(x);
        int blockY = GeoEngine.getBlock(y);
        int index = 0;
        index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return 0;
        }
        return geo.get(index);
    }

    private static short nGetHeight(int geox, int geoy, int z) {
        short region = GeoEngine.getRegionOffset(geox, geoy);
        int blockX = GeoEngine.getBlock(geox);
        int blockY = GeoEngine.getBlock(geoy);
        int index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return (short)z;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            return geo.getShort(index);
        }
        if (type == 1) {
            int cellX = GeoEngine.getCell(geox);
            int cellY = GeoEngine.getCell(geoy);
            short height = geo.getShort(index += (cellX << 3) + cellY << 1);
            height = (short)(height & 0xFFF0);
            height = (short)(height >> 1);
            return height;
        }
        int cellX = GeoEngine.getCell(geox);
        int cellY = GeoEngine.getCell(geoy);
        for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
            byte lc = geo.get(index);
            index += (lc << 1) + 1;
        }
        byte layers = geo.get(index);
        ++index;
        int height = -1;
        if (layers <= 0 || layers > 125) {
            _log.warning("Broken geofile (case1), region: " + region + " - invalid layer count: " + layers + " at: " + geox + " " + geoy);
            return (short)z;
        }
        int temph = Short.MIN_VALUE;
        while (layers > 0) {
            height = geo.getShort(index);
            height = (short)(height & 0xFFF0);
            if ((z - temph) * (z - temph) > (z - (height = (int)((short)(height >> 1)))) * (z - height)) {
                temph = height;
            }
            layers = (byte)(layers - 1);
            index += 2;
        }
        return (short)temph;
    }

    private static short nGetUpperHeight(int geox, int geoy, int z) {
        short region = GeoEngine.getRegionOffset(geox, geoy);
        int blockX = GeoEngine.getBlock(geox);
        int blockY = GeoEngine.getBlock(geoy);
        int index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return (short)z;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            return geo.getShort(index);
        }
        if (type == 1) {
            int cellX = GeoEngine.getCell(geox);
            int cellY = GeoEngine.getCell(geoy);
            short height = geo.getShort(index += (cellX << 3) + cellY << 1);
            height = (short)(height & 0xFFF0);
            height = (short)(height >> 1);
            return height;
        }
        int cellX = GeoEngine.getCell(geox);
        int cellY = GeoEngine.getCell(geoy);
        for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
            byte lc = geo.get(index);
            index += (lc << 1) + 1;
        }
        byte layers = geo.get(index);
        ++index;
        int height = -1;
        if (layers <= 0 || layers > 125) {
            _log.warning("Broken geofile (case1), region: " + region + " - invalid layer count: " + layers + " at: " + geox + " " + geoy);
            return (short)z;
        }
        int temph = Short.MAX_VALUE;
        while (layers > 0) {
            height = geo.getShort(index);
            height = (short)(height & 0xFFF0);
            if ((height = (int)((short)(height >> 1))) < z) {
                return (short)temph;
            }
            temph = height;
            layers = (byte)(layers - 1);
            index += 2;
        }
        return (short)temph;
    }

    private static short nGetSpawnHeight(int geox, int geoy, int zmin, int zmax, int spawnid) {
        short region = GeoEngine.getRegionOffset(geox, geoy);
        int blockX = GeoEngine.getBlock(geox);
        int blockY = GeoEngine.getBlock(geoy);
        short temph = Short.MIN_VALUE;
        int index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return (short)zmin;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            temph = geo.getShort(index);
        } else if (type == 1) {
            int cellX = GeoEngine.getCell(geox);
            int cellY = GeoEngine.getCell(geoy);
            short height = geo.getShort(index += (cellX << 3) + cellY << 1);
            height = (short)(height & 0xFFF0);
            temph = height = (short)(height >> 1);
        } else {
            int cellX = GeoEngine.getCell(geox);
            int cellY = GeoEngine.getCell(geoy);
            for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
                byte lc = geo.get(index);
                index += (lc << 1) + 1;
            }
            byte layers = geo.get(index);
            ++index;
            if (layers <= 0 || layers > 125) {
                _log.warning("Broken geofile (case2), region: " + region + " - invalid layer count: " + layers + " at: " + geox + " " + geoy);
                return (short)zmin;
            }
            while (layers > 0) {
                short height = geo.getShort(index);
                height = (short)(height & 0xFFF0);
                if ((zmin - temph) * (zmin - temph) > (zmin - (height = (short)(height >> 1))) * (zmin - height)) {
                    temph = height;
                }
                layers = (byte)(layers - 1);
                index += 2;
            }
            if (temph > zmax + 200 || temph < zmin - 200) {
                if (Config.DEBUG) {
                    _log.warning("SpawnHeight Error - Couldnt find correct layer to spawn NPC - GeoData or Spawnlist Bug!: zmin: " + zmin + " zmax: " + zmax + " value: " + temph + " SpawnId: " + spawnid + " at: " + geox + " : " + geoy);
                }
                return (short)zmin;
            }
        }
        if (temph > zmax + 1000 || temph < zmin - 1000) {
            if (Config.DEBUG) {
                _log.warning("SpawnHeight Error - Spawnlist z value is wrong or GeoData error: zmin: " + zmin + " zmax: " + zmax + " value: " + temph + " SpawnId: " + spawnid + " at: " + geox + " : " + geoy);
            }
            return (short)zmin;
        }
        return temph;
    }

    private static double nCanMoveNext(int x, int y, int z, int tx, int ty, int tz) {
        short region = GeoEngine.getRegionOffset(x, y);
        int blockX = GeoEngine.getBlock(x);
        int blockY = GeoEngine.getBlock(y);
        short NSWE = 0;
        int index = 0;
        index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return z;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            return geo.getShort(index);
        }
        if (type == 1) {
            int cellX = GeoEngine.getCell(x);
            int cellY = GeoEngine.getCell(y);
            short height = geo.getShort(index += (cellX << 3) + cellY << 1);
            NSWE = (short)(height & 0xF);
            height = (short)(height & 0xFFF0);
            height = (short)(height >> 1);
            if (GeoEngine.checkNSWE(NSWE, x, y, tx, ty)) {
                return height;
            }
            return Double.MIN_VALUE;
        }
        int cellX = GeoEngine.getCell(x);
        int cellY = GeoEngine.getCell(y);
        for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
            byte lc = geo.get(index);
            index += (lc << 1) + 1;
        }
        byte layers = geo.get(index);
        ++index;
        int height = -1;
        if (layers <= 0 || layers > 125) {
            _log.warning("Broken geofile (case3), region: " + region + " - invalid layer count: " + layers + " at: " + x + " " + y);
            return z;
        }
        int tempz = Short.MIN_VALUE;
        while (layers > 0) {
            height = geo.getShort(index);
            height = (short)(height & 0xFFF0);
            if ((z - tempz) * (z - tempz) > (z - (height = (int)((short)(height >> 1)))) * (z - height)) {
                tempz = height;
                NSWE = geo.getShort(index);
                NSWE = (short)(NSWE & 0xF);
            }
            layers = (byte)(layers - 1);
            index += 2;
        }
        if (GeoEngine.checkNSWE(NSWE, x, y, tx, ty)) {
            return tempz;
        }
        return Double.MIN_VALUE;
    }

    private static boolean nLOS(int x, int y, int z, int inc_x, int inc_y, double inc_z, int tz, boolean debug) {
        short region = GeoEngine.getRegionOffset(x, y);
        int blockX = GeoEngine.getBlock(x);
        int blockY = GeoEngine.getBlock(y);
        short NSWE = 0;
        int index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return true;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            short height = geo.getShort(index);
            if (debug) {
                _log.warning("flatheight:" + height);
            }
            if (z > height) {
                return inc_z > (double)height;
            }
            return inc_z < (double)height;
        }
        if (type == 1) {
            int cellX = GeoEngine.getCell(x);
            int cellY = GeoEngine.getCell(y);
            short height = geo.getShort(index += (cellX << 3) + cellY << 1);
            NSWE = (short)(height & 0xF);
            height = (short)(height & 0xFFF0);
            height = (short)(height >> 1);
            if (!GeoEngine.checkNSWE(NSWE, x, y, x + inc_x, y + inc_y)) {
                if (debug) {
                    _log.warning("height:" + height + " z" + z);
                }
                return z >= GeoEngine.nGetUpperHeight(x + inc_x, y + inc_y, height);
            }
            return true;
        }
        int cellX = GeoEngine.getCell(x);
        int cellY = GeoEngine.getCell(y);
        for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
            byte lc = geo.get(index);
            index += (lc << 1) + 1;
        }
        byte layers = geo.get(index);
        ++index;
        short tempZ = -1;
        if (layers <= 0 || layers > 125) {
            _log.warning("Broken geofile (case4), region: " + region + " - invalid layer count: " + layers + " at: " + x + " " + y);
            return false;
        }
        short upperHeight = Short.MAX_VALUE;
        short lowerHeight = Short.MIN_VALUE;
        byte temp_layers = layers;
        boolean highestlayer = false;
        while (temp_layers > 0) {
            tempZ = geo.getShort(index);
            tempZ = (short)(tempZ & 0xFFF0);
            if (z > (tempZ = (short)((short)(tempZ >> 1)))) {
                lowerHeight = tempZ;
                NSWE = geo.getShort(index);
                NSWE = (short)(NSWE & 0xF);
                break;
            }
            highestlayer = false;
            upperHeight = tempZ;
            temp_layers = (byte)(temp_layers - 1);
            index += 2;
        }
        if (debug) {
            _log.warning("z:" + z + " x: " + cellX + " y:" + cellY + " la " + layers + " lo:" + lowerHeight + " up:" + upperHeight);
        }
        if (z - upperHeight < -10 && (double)(z - upperHeight) > inc_z - 20.0 && z - lowerHeight > 40) {
            if (debug) {
                _log.warning("false, incz" + inc_z);
            }
            return false;
        }
        if (!highestlayer) {
            if (!GeoEngine.checkNSWE(NSWE, x, y, x + inc_x, y + inc_y)) {
                if (debug) {
                    _log.warning("block and next in x" + inc_x + " y" + inc_y + " is:" + GeoEngine.nGetUpperHeight(x + inc_x, y + inc_y, lowerHeight));
                }
                return z >= GeoEngine.nGetUpperHeight(x + inc_x, y + inc_y, lowerHeight);
            }
            return true;
        }
        if (!GeoEngine.checkNSWE(NSWE, x, y, x + inc_x, y + inc_y)) {
            return z >= GeoEngine.nGetUpperHeight(x + inc_x, y + inc_y, lowerHeight);
        }
        return true;
    }

    private short nGetNSWE(int x, int y, int z) {
        short region = GeoEngine.getRegionOffset(x, y);
        int blockX = GeoEngine.getBlock(x);
        int blockY = GeoEngine.getBlock(y);
        short NSWE = 0;
        int index = 0;
        index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return 15;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            return 15;
        }
        if (type == 1) {
            int cellX = GeoEngine.getCell(x);
            int cellY = GeoEngine.getCell(y);
            short height = geo.getShort(index += (cellX << 3) + cellY << 1);
            NSWE = (short)(height & 0xF);
        } else {
            int cellX = GeoEngine.getCell(x);
            int cellY = GeoEngine.getCell(y);
            for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
                byte lc = geo.get(index);
                index += (lc << 1) + 1;
            }
            byte layers = geo.get(index);
            ++index;
            int height = -1;
            if (layers <= 0 || layers > 125) {
                _log.warning("Broken geofile (case5), region: " + region + " - invalid layer count: " + layers + " at: " + x + " " + y);
                return 15;
            }
            int tempz = Short.MIN_VALUE;
            while (layers > 0) {
                height = geo.getShort(index);
                height = (short)(height & 0xFFF0);
                if ((z - tempz) * (z - tempz) > (z - (height = (int)((short)(height >> 1)))) * (z - height)) {
                    tempz = height;
                    NSWE = geo.get(index);
                    NSWE = (short)(NSWE & 0xF);
                }
                layers = (byte)(layers - 1);
                index += 2;
            }
        }
        return NSWE;
    }

    @Override
    public Node[] getNeighbors(Node n) {
        short height;
        FastList Neighbors = new FastList(4);
        int x = n.getLoc().getNodeX();
        int y = n.getLoc().getNodeY();
        int parentdirection = 0;
        if (n.getParent() != null) {
            if (n.getParent().getLoc().getNodeX() > x) {
                parentdirection = 1;
            }
            if (n.getParent().getLoc().getNodeX() < x) {
                parentdirection = -1;
            }
            if (n.getParent().getLoc().getNodeY() > y) {
                parentdirection = 2;
            }
            if (n.getParent().getLoc().getNodeY() < y) {
                parentdirection = -2;
            }
        }
        short z = n.getLoc().getZ();
        short region = GeoEngine.getRegionOffset(x, y);
        int blockX = GeoEngine.getBlock(x);
        int blockY = GeoEngine.getBlock(y);
        short NSWE = 0;
        int index = 0;
        index = _geodataIndex.get(region) == null ? ((blockX << 8) + blockY) * 3 : _geodataIndex.get(region).get((blockX << 8) + blockY);
        ByteBuffer geo = _geodata.get(region);
        if (geo == null) {
            if (Config.DEBUG) {
                _log.warning("Geo Region - Region Offset: " + region + " dosnt exist!!");
            }
            return null;
        }
        byte type = geo.get(index);
        ++index;
        if (type == 0) {
            Node newNode;
            height = geo.getShort(index);
            n.getLoc().setZ(height);
            if (parentdirection != 1) {
                newNode = CellPathFinding.getInstance().readNode(x + 1, y, height);
                Neighbors.add(newNode);
            }
            if (parentdirection != 2) {
                newNode = CellPathFinding.getInstance().readNode(x, y + 1, height);
                Neighbors.add(newNode);
            }
            if (parentdirection != -2) {
                newNode = CellPathFinding.getInstance().readNode(x, y - 1, height);
                Neighbors.add(newNode);
            }
            if (parentdirection != -1) {
                newNode = CellPathFinding.getInstance().readNode(x - 1, y, height);
                Neighbors.add(newNode);
            }
        } else if (type == 1) {
            Node newNode;
            int cellX = GeoEngine.getCell(x);
            int cellY = GeoEngine.getCell(y);
            height = geo.getShort(index += (cellX << 3) + cellY << 1);
            NSWE = (short)(height & 0xF);
            height = (short)(height & 0xFFF0);
            height = (short)(height >> 1);
            n.getLoc().setZ(height);
            if (NSWE != 15 && parentdirection != 0) {
                return null;
            }
            if (parentdirection != 1 && GeoEngine.checkNSWE(NSWE, x, y, x + 1, y)) {
                newNode = CellPathFinding.getInstance().readNode(x + 1, y, height);
                Neighbors.add(newNode);
            }
            if (parentdirection != 2 && GeoEngine.checkNSWE(NSWE, x, y, x, y + 1)) {
                newNode = CellPathFinding.getInstance().readNode(x, y + 1, height);
                Neighbors.add(newNode);
            }
            if (parentdirection != -2 && GeoEngine.checkNSWE(NSWE, x, y, x, y - 1)) {
                newNode = CellPathFinding.getInstance().readNode(x, y - 1, height);
                Neighbors.add(newNode);
            }
            if (parentdirection != -1 && GeoEngine.checkNSWE(NSWE, x, y, x - 1, y)) {
                newNode = CellPathFinding.getInstance().readNode(x - 1, y, height);
                Neighbors.add(newNode);
            }
        } else {
            Node newNode;
            int cellX = GeoEngine.getCell(x);
            int cellY = GeoEngine.getCell(y);
            for (int offset = (cellX << 3) + cellY; offset > 0; --offset) {
                byte lc = geo.get(index);
                index += (lc << 1) + 1;
            }
            byte layers = geo.get(index);
            ++index;
            short height2 = -1;
            if (layers <= 0 || layers > 125) {
                _log.warning("Broken geofile (case5), region: " + region + " - invalid layer count: " + layers + " at: " + x + " " + y);
                return null;
            }
            short tempz = Short.MIN_VALUE;
            while (layers > 0) {
                height2 = geo.getShort(index);
                height2 = (short)(height2 & 0xFFF0);
                if ((z - tempz) * (z - tempz) > (z - (height2 = (short)((short)(height2 >> 1)))) * (z - height2)) {
                    tempz = height2;
                    NSWE = geo.get(index);
                    NSWE = (short)(NSWE & 0xF);
                }
                layers = (byte)(layers - 1);
                index += 2;
            }
            n.getLoc().setZ(tempz);
            if (NSWE != 15 && parentdirection != 0) {
                return null;
            }
            if (parentdirection != 1 && GeoEngine.checkNSWE(NSWE, x, y, x + 1, y)) {
                newNode = CellPathFinding.getInstance().readNode(x + 1, y, tempz);
                Neighbors.add(newNode);
            }
            if (parentdirection != 2 && GeoEngine.checkNSWE(NSWE, x, y, x, y + 1)) {
                newNode = CellPathFinding.getInstance().readNode(x, y + 1, tempz);
                Neighbors.add(newNode);
            }
            if (parentdirection != -2 && GeoEngine.checkNSWE(NSWE, x, y, x, y - 1)) {
                newNode = CellPathFinding.getInstance().readNode(x, y - 1, tempz);
                Neighbors.add(newNode);
            }
            if (parentdirection != -1 && GeoEngine.checkNSWE(NSWE, x, y, x - 1, y)) {
                newNode = CellPathFinding.getInstance().readNode(x - 1, y, tempz);
                Neighbors.add(newNode);
            }
        }
        Node[] result = new Node[Neighbors.size()];
        return Neighbors.toArray(result);
    }

    private static boolean checkNSWE(short NSWE, int x, int y, int tx, int ty) {
        if (NSWE == 15) {
            return true;
        }
        if (tx > x ? (NSWE & 1) == 0 : tx < x && (NSWE & 2) == 0) {
            return false;
        }
        return !(ty > y ? (NSWE & 4) == 0 : ty < y && (NSWE & 8) == 0);
    }

    private static class SingletonHolder {
        protected static final GeoEngine _instance = new GeoEngine();

        private SingletonHolder() {
        }
    }
}

