/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai2;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.ai2.AiEvent;
import com.l2jserver.gameserver.ai2.AiEventType;
import com.l2jserver.gameserver.ai2.AiManager;
import com.l2jserver.gameserver.ai2.AiParameters;
import com.l2jserver.gameserver.ai2.AiPlugingParameters;
import com.l2jserver.gameserver.ai2.EventHandler;
import com.l2jserver.gameserver.ai2.EventHandlerSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javolution.util.FastMap;

public class AiInstance {
    private Map<AiEventType, EventHandlerSet> _eventHandlers;
    private AiPlugingParameters _pluginigParams;

    public AiInstance(AiPlugingParameters params) {
        if (params.isConverted()) {
            throw new IllegalArgumentException("AiPluginingParameters of an Ai instance must be converted");
        }
        this._pluginigParams = params;
        this._eventHandlers = new FastMap();
        AiManager.getInstance().addAiInstance(this);
    }

    public AiInstance(AiInstance instance, AiPlugingParameters params) {
        this(params);
        this.copyHanlders(instance);
    }

    public void copyHanlders(AiInstance instance) {
        for (EventHandlerSet set : instance.getEventHandlerSets()) {
            this.addHandlerSet(set.getEventType(), set);
        }
    }

    public void addHandler(EventHandler handler) {
        EventHandlerSet set = this._eventHandlers.get((Object)handler.getEvenType());
        if (set == null) {
            set = new EventHandlerSet(handler, TaskPriority.PR_NORMAL);
            this._eventHandlers.put(handler.getEvenType(), set);
        } else {
            set.addHandler(handler);
        }
    }

    public void addHandlerSet(AiEventType event, EventHandlerSet set) {
        this._eventHandlers.put(event, set);
    }

    public void launchNextEvent(AiParameters aiParams) {
        if (aiParams.hasEvents()) {
            AiEvent event = aiParams.nextEvent();
            AiManager.getInstance().executeEventHandler(new QueueEventRunner(this._eventHandlers.get((Object)event.getType()), aiParams, event));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerEvent(AiEvent event, AiParameters aiParams) {
        if (aiParams.isEventInhibited(event.getType())) {
            return;
        }
        boolean restart = false;
        AiParameters aiParameters = aiParams;
        synchronized (aiParameters) {
            if (!aiParams.hasEvents()) {
                restart = true;
            }
            aiParams.queueEvents(event);
            if (restart) {
                this.launchNextEvent(aiParams);
            }
        }
    }

    public AiPlugingParameters getPluginingParamaters() {
        return this._pluginigParams;
    }

    public Collection<EventHandlerSet> getEventHandlerSets() {
        return this._eventHandlers.values();
    }

    public Set<Integer> getHandledNPCIds() {
        return this._pluginigParams.getIDs();
    }

    public class QueueEventRunner
    implements Runnable {
        private EventHandlerSet _set;
        private AiParameters _ai;
        private AiEvent _event;

        public QueueEventRunner(EventHandlerSet set, AiParameters ai, AiEvent event) {
            this._set = set;
            this._ai = ai;
            this._event = event;
        }

        @Override
        public void run() {
            for (EventHandler handler : this._set.getHandlers()) {
                handler.runImpl(this._ai, this._event);
            }
            AiInstance.this.launchNextEvent(this._ai);
        }
    }
}

