/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handlers.admincommandhandlers;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.Shutdown;
import com.l2jserver.gameserver.handler.IAdminCommandHandler;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class AdminShutdown
implements IAdminCommandHandler {
    private static final String[] ADMIN_COMMANDS = new String[]{"admin_server_shutdown", "admin_server_restart", "admin_server_abort"};

    @Override
    public boolean useAdminCommand(String command, L2PcInstance activeChar) {
        if (command.startsWith("admin_server_shutdown")) {
            try {
                int val = Integer.parseInt(command.substring(22));
                this.serverShutdown(activeChar, val, false);
            }
            catch (StringIndexOutOfBoundsException e) {
                this.sendHtmlForm(activeChar);
            }
        } else if (command.startsWith("admin_server_restart")) {
            try {
                int val = Integer.parseInt(command.substring(21));
                this.serverShutdown(activeChar, val, true);
            }
            catch (StringIndexOutOfBoundsException e) {
                this.sendHtmlForm(activeChar);
            }
        } else if (command.startsWith("admin_server_abort")) {
            this.serverAbort(activeChar);
        }
        return true;
    }

    @Override
    public String[] getAdminCommandList() {
        return ADMIN_COMMANDS;
    }

    private void sendHtmlForm(L2PcInstance activeChar) {
        NpcHtmlMessage adminReply = new NpcHtmlMessage(5);
        int t = GameTimeController.getInstance().getGameTime();
        int h = t / 60;
        int m = t % 60;
        SimpleDateFormat format = new SimpleDateFormat("h:mm a");
        Calendar cal = Calendar.getInstance();
        cal.set(11, h);
        cal.set(12, m);
        adminReply.setFile("data/html/admin/shutdown.htm");
        adminReply.replace((CharSequence)"%count%", String.valueOf(L2World.getInstance().getAllPlayersCount()));
        adminReply.replace((CharSequence)"%used%", String.valueOf(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        adminReply.replace((CharSequence)"%xp%", String.valueOf(Config.RATE_XP));
        adminReply.replace((CharSequence)"%sp%", String.valueOf(Config.RATE_SP));
        adminReply.replace((CharSequence)"%adena%", String.valueOf(Config.RATE_DROP_ITEMS_ID.get(57)));
        adminReply.replace((CharSequence)"%drop%", String.valueOf(Config.RATE_DROP_ITEMS));
        adminReply.replace((CharSequence)"%time%", String.valueOf(format.format(cal.getTime())));
        activeChar.sendPacket(adminReply);
    }

    private void serverShutdown(L2PcInstance activeChar, int seconds, boolean restart) {
        Shutdown.getInstance().startShutdown(activeChar, seconds, restart);
    }

    private void serverAbort(L2PcInstance activeChar) {
        Shutdown.getInstance().abort(activeChar);
    }
}

