/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class AutoSpawnHandler {
    protected static final Logger _log = Logger.getLogger(AutoSpawnHandler.class.getName());
    private static final int DEFAULT_INITIAL_SPAWN = 30000;
    private static final int DEFAULT_RESPAWN = 3600000;
    private static final int DEFAULT_DESPAWN = 3600000;
    protected Map<Integer, AutoSpawnInstance> _registeredSpawns = new FastMap();
    protected Map<Integer, ScheduledFuture<?>> _runningSpawns = new FastMap();
    protected boolean _activeState = true;

    private AutoSpawnHandler() {
        this.restoreSpawnData();
    }

    public static AutoSpawnHandler getInstance() {
        return SingletonHolder._instance;
    }

    public final int size() {
        return this._registeredSpawns.size();
    }

    public void reload() {
        for (ScheduledFuture<?> sf : this._runningSpawns.values()) {
            if (sf == null) continue;
            sf.cancel(true);
        }
        for (AutoSpawnInstance asi : this._registeredSpawns.values()) {
            if (asi == null) continue;
            this.removeSpawn(asi);
        }
        this._registeredSpawns = new FastMap();
        this._runningSpawns = new FastMap();
        this.restoreSpawnData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreSpawnData() {
        int numLoaded = 0;
        Connection con = null;
        try {
            PreparedStatement statement = null;
            PreparedStatement statement2 = null;
            ResultSet rs = null;
            ResultSet rs2 = null;
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT * FROM random_spawn ORDER BY groupId ASC");
            rs = statement.executeQuery();
            while (rs.next()) {
                AutoSpawnInstance spawnInst = this.registerSpawn(rs.getInt("npcId"), rs.getInt("initialDelay"), rs.getInt("respawnDelay"), rs.getInt("despawnDelay"));
                spawnInst.setSpawnCount(rs.getInt("count"));
                spawnInst.setBroadcast(rs.getBoolean("broadcastSpawn"));
                spawnInst.setRandomSpawn(rs.getBoolean("randomSpawn"));
                ++numLoaded;
                statement2 = con.prepareStatement("SELECT * FROM random_spawn_loc WHERE groupId=?");
                statement2.setInt(1, rs.getInt("groupId"));
                rs2 = statement2.executeQuery();
                while (rs2.next()) {
                    spawnInst.addSpawnLocation(rs2.getInt("x"), rs2.getInt("y"), rs2.getInt("z"), rs2.getInt("heading"));
                }
                statement2.close();
            }
            statement.close();
            if (Config.DEBUG) {
                _log.config("AutoSpawnHandler: Loaded " + numLoaded + " spawn group(s) from the database.");
            }
        }
        catch (Exception e) {
            _log.warning("AutoSpawnHandler: Could not restore spawn data: " + e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public AutoSpawnInstance registerSpawn(int npcId, int[][] spawnPoints, int initialDelay, int respawnDelay, int despawnDelay) {
        int newId;
        if (initialDelay < 0) {
            initialDelay = 30000;
        }
        if (respawnDelay < 0) {
            respawnDelay = 3600000;
        }
        if (despawnDelay < 0) {
            despawnDelay = 3600000;
        }
        AutoSpawnInstance newSpawn = new AutoSpawnInstance(npcId, initialDelay, respawnDelay, despawnDelay);
        if (spawnPoints != null) {
            for (int[] spawnPoint : spawnPoints) {
                newSpawn.addSpawnLocation(spawnPoint);
            }
        }
        newSpawn._objectId = newId = IdFactory.getInstance().getNextId();
        this._registeredSpawns.put(newId, newSpawn);
        this.setSpawnActive(newSpawn, true);
        if (Config.DEBUG) {
            _log.config("AutoSpawnHandler: Registered auto spawn for NPC ID " + npcId + " (Object ID = " + newId + ").");
        }
        return newSpawn;
    }

    public AutoSpawnInstance registerSpawn(int npcId, int initialDelay, int respawnDelay, int despawnDelay) {
        return this.registerSpawn(npcId, null, initialDelay, respawnDelay, despawnDelay);
    }

    public boolean removeSpawn(AutoSpawnInstance spawnInst) {
        if (!this.isSpawnRegistered(spawnInst)) {
            return false;
        }
        try {
            this._registeredSpawns.remove(spawnInst.getNpcId());
            ScheduledFuture<?> respawnTask = this._runningSpawns.remove(spawnInst._objectId);
            respawnTask.cancel(false);
            if (Config.DEBUG) {
                _log.config("AutoSpawnHandler: Removed auto spawn for NPC ID " + spawnInst._npcId + " (Object ID = " + spawnInst._objectId + ").");
            }
        }
        catch (Exception e) {
            _log.warning("AutoSpawnHandler: Could not auto spawn for NPC ID " + spawnInst._npcId + " (Object ID = " + spawnInst._objectId + "): " + e);
            return false;
        }
        return true;
    }

    public void removeSpawn(int objectId) {
        this.removeSpawn(this._registeredSpawns.get(objectId));
    }

    public void setSpawnActive(AutoSpawnInstance spawnInst, boolean isActive) {
        if (spawnInst == null) {
            return;
        }
        int objectId = spawnInst._objectId;
        if (this.isSpawnRegistered(objectId)) {
            ScheduledFuture<?> spawnTask = null;
            if (isActive) {
                AutoSpawner rs = new AutoSpawner(objectId);
                spawnTask = spawnInst._desDelay > 0 ? ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(rs, spawnInst._initDelay, spawnInst._resDelay) : ThreadPoolManager.getInstance().scheduleEffect(rs, spawnInst._initDelay);
                this._runningSpawns.put(objectId, spawnTask);
            } else {
                AutoDespawner rd = new AutoDespawner(objectId);
                spawnTask = this._runningSpawns.remove(objectId);
                if (spawnTask != null) {
                    spawnTask.cancel(false);
                }
                ThreadPoolManager.getInstance().scheduleEffect(rd, 0L);
            }
            spawnInst.setSpawnActive(isActive);
        }
    }

    public void setAllActive(boolean isActive) {
        if (this._activeState == isActive) {
            return;
        }
        for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
            this.setSpawnActive(spawnInst, isActive);
        }
        this._activeState = isActive;
    }

    public final long getTimeToNextSpawn(AutoSpawnInstance spawnInst) {
        int objectId = spawnInst.getObjectId();
        if (!this.isSpawnRegistered(objectId)) {
            return -1L;
        }
        return this._runningSpawns.get(objectId).getDelay(TimeUnit.MILLISECONDS);
    }

    public final AutoSpawnInstance getAutoSpawnInstance(int id, boolean isObjectId) {
        if (isObjectId) {
            if (this.isSpawnRegistered(id)) {
                return this._registeredSpawns.get(id);
            }
        } else {
            for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
                if (spawnInst.getNpcId() != id) continue;
                return spawnInst;
            }
        }
        return null;
    }

    public Map<Integer, AutoSpawnInstance> getAutoSpawnInstances(int npcId) {
        FastMap spawnInstList = new FastMap();
        for (AutoSpawnInstance spawnInst : this._registeredSpawns.values()) {
            if (spawnInst.getNpcId() != npcId) continue;
            spawnInstList.put(spawnInst.getObjectId(), spawnInst);
        }
        return spawnInstList;
    }

    public final boolean isSpawnRegistered(int objectId) {
        return this._registeredSpawns.containsKey(objectId);
    }

    public final boolean isSpawnRegistered(AutoSpawnInstance spawnInst) {
        return this._registeredSpawns.containsValue(spawnInst);
    }

    private static class SingletonHolder {
        protected static final AutoSpawnHandler _instance = new AutoSpawnHandler();

        private SingletonHolder() {
        }
    }

    public class AutoSpawnInstance {
        protected int _objectId;
        protected int _spawnIndex;
        protected int _npcId;
        protected int _initDelay;
        protected int _resDelay;
        protected int _desDelay;
        protected int _spawnCount = 1;
        protected int _lastLocIndex = -1;
        private List<L2Npc> _npcList = new FastList();
        private List<Location> _locList = new FastList();
        private boolean _spawnActive;
        private boolean _randomSpawn = false;
        private boolean _broadcastAnnouncement = false;

        protected AutoSpawnInstance(int npcId, int initDelay, int respawnDelay, int despawnDelay) {
            this._npcId = npcId;
            this._initDelay = initDelay;
            this._resDelay = respawnDelay;
            this._desDelay = despawnDelay;
        }

        protected void setSpawnActive(boolean activeValue) {
            this._spawnActive = activeValue;
        }

        protected boolean addNpcInstance(L2Npc npcInst) {
            return this._npcList.add(npcInst);
        }

        protected boolean removeNpcInstance(L2Npc npcInst) {
            return this._npcList.remove(npcInst);
        }

        public int getObjectId() {
            return this._objectId;
        }

        public int getInitialDelay() {
            return this._initDelay;
        }

        public int getRespawnDelay() {
            return this._resDelay;
        }

        public int getDespawnDelay() {
            return this._desDelay;
        }

        public int getNpcId() {
            return this._npcId;
        }

        public int getSpawnCount() {
            return this._spawnCount;
        }

        public Location[] getLocationList() {
            return this._locList.toArray(new Location[this._locList.size()]);
        }

        List<L2Npc> getNPCInstanceList$() {
            return this._npcList;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public L2Npc[] getNPCInstanceList() {
            L2Npc[] ret;
            List<L2Npc> list = this._npcList;
            synchronized (list) {
                ret = new L2Npc[this._npcList.size()];
                this._npcList.toArray(ret);
            }
            return ret;
        }

        @Deprecated
        public L2Spawn[] getSpawns() {
            FastList npcSpawns = new FastList();
            for (L2Npc npcInst : this._npcList) {
                npcSpawns.add(npcInst.getSpawn());
            }
            return npcSpawns.toArray(new L2Spawn[npcSpawns.size()]);
        }

        public void setSpawnCount(int spawnCount) {
            this._spawnCount = spawnCount;
        }

        public void setRandomSpawn(boolean randValue) {
            this._randomSpawn = randValue;
        }

        public void setBroadcast(boolean broadcastValue) {
            this._broadcastAnnouncement = broadcastValue;
        }

        public boolean isSpawnActive() {
            return this._spawnActive;
        }

        public boolean isRandomSpawn() {
            return this._randomSpawn;
        }

        public boolean isBroadcasting() {
            return this._broadcastAnnouncement;
        }

        public boolean addSpawnLocation(int x, int y, int z, int heading) {
            return this._locList.add(new Location(x, y, z, heading));
        }

        public boolean addSpawnLocation(int[] spawnLoc) {
            if (spawnLoc.length != 3) {
                return false;
            }
            return this.addSpawnLocation(spawnLoc[0], spawnLoc[1], spawnLoc[2], -1);
        }

        public Location removeSpawnLocation(int locIndex) {
            try {
                return this._locList.remove(locIndex);
            }
            catch (IndexOutOfBoundsException e) {
                return null;
            }
        }
    }

    private class AutoDespawner
    implements Runnable {
        private int _objectId;

        protected AutoDespawner(int objectId) {
            this._objectId = objectId;
        }

        @Override
        public void run() {
            try {
                AutoSpawnInstance spawnInst = AutoSpawnHandler.this._registeredSpawns.get(this._objectId);
                if (spawnInst == null) {
                    _log.info("AutoSpawnHandler: No spawn registered for object ID = " + this._objectId + ".");
                    return;
                }
                for (L2Npc npcInst : spawnInst.getNPCInstanceList$()) {
                    if (npcInst == null) continue;
                    npcInst.deleteMe();
                    spawnInst.removeNpcInstance(npcInst);
                    if (!Config.DEBUG) continue;
                    _log.info("AutoSpawnHandler: Spawns removed for spawn instance (Object ID = " + this._objectId + ").");
                }
            }
            catch (Exception e) {
                _log.warning("AutoSpawnHandler: An error occurred while despawning spawn (Object ID = " + this._objectId + "): " + e);
                e.printStackTrace();
            }
        }
    }

    private class AutoSpawner
    implements Runnable {
        private int _objectId;

        protected AutoSpawner(int objectId) {
            this._objectId = objectId;
        }

        @Override
        public void run() {
            try {
                AutoSpawnInstance spawnInst = AutoSpawnHandler.this._registeredSpawns.get(this._objectId);
                if (!spawnInst.isSpawnActive()) {
                    return;
                }
                Location[] locationList = spawnInst.getLocationList();
                if (locationList.length == 0) {
                    _log.info("AutoSpawnHandler: No location co-ords specified for spawn instance (Object ID = " + this._objectId + ").");
                    return;
                }
                int locationCount = locationList.length;
                int locationIndex = Rnd.nextInt(locationCount);
                if (!spawnInst.isRandomSpawn()) {
                    locationIndex = spawnInst._lastLocIndex + 1;
                    if (locationIndex == locationCount) {
                        locationIndex = 0;
                    }
                    spawnInst._lastLocIndex = locationIndex;
                }
                int x = locationList[locationIndex].getX();
                int y = locationList[locationIndex].getY();
                int z = locationList[locationIndex].getZ();
                int heading = locationList[locationIndex].getHeading();
                L2NpcTemplate npcTemp = NpcTable.getInstance().getTemplate(spawnInst.getNpcId());
                if (npcTemp == null) {
                    _log.warning("Couldnt find NPC id" + spawnInst.getNpcId() + " Try to update your DP");
                    return;
                }
                L2Spawn newSpawn = new L2Spawn(npcTemp);
                newSpawn.setLocx(x);
                newSpawn.setLocy(y);
                newSpawn.setLocz(z);
                if (heading != -1) {
                    newSpawn.setHeading(heading);
                }
                newSpawn.setAmount(spawnInst.getSpawnCount());
                if (spawnInst._desDelay == 0) {
                    newSpawn.setRespawnDelay(spawnInst._resDelay);
                }
                SpawnTable.getInstance().addNewSpawn(newSpawn, false);
                L2Npc npcInst = null;
                if (spawnInst._spawnCount == 1) {
                    npcInst = newSpawn.doSpawn();
                    npcInst.setXYZ(npcInst.getX(), npcInst.getY(), npcInst.getZ());
                    spawnInst.addNpcInstance(npcInst);
                } else {
                    for (int i = 0; i < spawnInst._spawnCount; ++i) {
                        npcInst = newSpawn.doSpawn();
                        npcInst.setXYZ(npcInst.getX() + Rnd.nextInt(50), npcInst.getY() + Rnd.nextInt(50), npcInst.getZ());
                        spawnInst.addNpcInstance(npcInst);
                    }
                }
                String nearestTown = MapRegionTable.getInstance().getClosestTownName(npcInst);
                if (spawnInst.isBroadcasting()) {
                    Announcements.getInstance().announceToAll(new SystemMessage(SystemMessageId.S2_S1).addString("\u306b" + npcInst.getName() + "\u304c\u3084\u3063\u3066\u307e\u3044\u308a\u307e\u3057\u305f\uff01").addZoneName(x, y, z));
                }
                if (Config.DEBUG) {
                    _log.info("AutoSpawnHandler: Spawned NPC ID " + spawnInst.getNpcId() + " at " + x + ", " + y + ", " + z + " (Near " + nearestTown + ") for " + spawnInst.getRespawnDelay() / 60000 + " minute(s).");
                }
                if (spawnInst.getDespawnDelay() > 0) {
                    AutoDespawner rd = new AutoDespawner(this._objectId);
                    ThreadPoolManager.getInstance().scheduleAi(rd, spawnInst.getDespawnDelay() - 1000);
                }
            }
            catch (Exception e) {
                _log.warning("AutoSpawnHandler: An error occurred while initializing spawn instance (Object ID = " + this._objectId + "): " + e);
                e.printStackTrace();
            }
        }
    }
}

