/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.ObjectKnownList;
import com.l2jserver.gameserver.model.actor.poly.ObjectPoly;
import com.l2jserver.gameserver.model.actor.position.ObjectPosition;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public abstract class L2Object {
    private boolean _isVisible;
    private ObjectKnownList _knownList;
    private String _name;
    private int _objectId;
    private ObjectPoly _poly;
    private ObjectPosition _position;
    private int _instanceId = 0;

    public L2Object(int objectId) {
        this._objectId = objectId;
        this.initKnownList();
        this.initPosition();
    }

    public final void onAction(L2PcInstance player) {
        this.onAction(player, true);
    }

    public void onAction(L2PcInstance player, boolean interact) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Deprecated
    public void onActionShift(L2GameClient client) {
        client.getActiveChar().sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onActionShift(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onForcedAttack(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onSpawn() {
    }

    public final void setXYZ(int x, int y, int z) {
        this.getPosition().setXYZ(x, y, z);
    }

    public final void setXYZInvisible(int x, int y, int z) {
        this.getPosition().setXYZInvisible(x, y, z);
    }

    public final int getX() {
        if (Config.ASSERT) assert (this.getPosition().getWorldRegion() != null || this._isVisible);
        return this.getPosition().getX();
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public void setInstanceId(int instanceId) {
        if (this._instanceId == instanceId) {
            return;
        }
        Instance oldI = InstanceManager.getInstance().getInstance(this._instanceId);
        Instance newI = InstanceManager.getInstance().getInstance(instanceId);
        if (newI == null) {
            return;
        }
        if (this instanceof L2PcInstance) {
            if (this._instanceId > 0 && oldI != null) {
                oldI.removePlayer(this.getObjectId());
            }
            if (instanceId > 0) {
                newI.addPlayer(this.getObjectId());
            }
            if (((L2PcInstance)this).getPet() != null) {
                ((L2PcInstance)this).getPet().setInstanceId(instanceId);
            }
        } else if (this instanceof L2Npc) {
            if (this._instanceId > 0 && oldI != null) {
                oldI.removeNpc((L2Npc)this);
            }
            if (instanceId > 0) {
                newI.addNpc((L2Npc)this);
            }
        }
        this._instanceId = instanceId;
        if (this._isVisible && this._knownList != null && !(this instanceof L2PcInstance)) {
            this.decayMe();
            this.spawnMe();
        }
    }

    public final int getY() {
        if (Config.ASSERT) assert (this.getPosition().getWorldRegion() != null || this._isVisible);
        return this.getPosition().getY();
    }

    public final int getZ() {
        if (Config.ASSERT) assert (this.getPosition().getWorldRegion() != null || this._isVisible);
        return this.getPosition().getZ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void decayMe() {
        if (Config.ASSERT) assert (this.getPosition().getWorldRegion() != null);
        L2WorldRegion reg = this.getPosition().getWorldRegion();
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = false;
            this.getPosition().setWorldRegion(null);
        }
        L2World.getInstance().removeVisibleObject(this, reg);
        L2World.getInstance().removeObject(this);
        if (Config.SAVE_DROPPED_ITEM) {
            ItemsOnGroundManager.getInstance().removeObject(this);
        }
    }

    public void refreshID() {
        L2World.getInstance().removeObject(this);
        IdFactory.getInstance().releaseId(this.getObjectId());
        this._objectId = IdFactory.getInstance().getNextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe() {
        if (Config.ASSERT) assert (this.getPosition().getWorldRegion() == null && this.getPosition().getWorldPosition().getX() != 0 && this.getPosition().getWorldPosition().getY() != 0 && this.getPosition().getWorldPosition().getZ() != 0);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = true;
            this.getPosition().setWorldRegion(L2World.getInstance().getRegion(this.getPosition().getWorldPosition()));
            L2World.getInstance().storeObject(this);
            this.getPosition().getWorldRegion().addVisibleObject(this);
        }
        L2World.getInstance().addVisibleObject(this, this.getPosition().getWorldRegion());
        this.onSpawn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe(int x, int y, int z) {
        if (Config.ASSERT) assert (this.getPosition().getWorldRegion() == null);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = true;
            if (x > 229376) {
                x = 224376;
            }
            if (x < -327680) {
                x = -322680;
            }
            if (y > 294912) {
                y = 289912;
            }
            if (y < -262144) {
                y = -257144;
            }
            this.getPosition().setWorldPosition(x, y, z);
            this.getPosition().setWorldRegion(L2World.getInstance().getRegion(this.getPosition().getWorldPosition()));
        }
        L2World.getInstance().storeObject(this);
        this.getPosition().getWorldRegion().addVisibleObject(this);
        L2World.getInstance().addVisibleObject(this, this.getPosition().getWorldRegion());
        this.onSpawn();
    }

    public void toggleVisible() {
        if (this.isVisible()) {
            this.decayMe();
        } else {
            this.spawnMe();
        }
    }

    public boolean isAttackable() {
        return false;
    }

    public abstract boolean isAutoAttackable(L2Character var1);

    public boolean isMarker() {
        return false;
    }

    public final boolean isVisible() {
        return this.getPosition().getWorldRegion() != null;
    }

    public final void setIsVisible(boolean value) {
        this._isVisible = value;
        if (!this._isVisible) {
            this.getPosition().setWorldRegion(null);
        }
    }

    public ObjectKnownList getKnownList() {
        return this._knownList;
    }

    public void initKnownList() {
        this._knownList = new ObjectKnownList(this);
    }

    public final void setKnownList(ObjectKnownList value) {
        this._knownList = value;
    }

    public final String getName() {
        return this._name;
    }

    public final void setName(String value) {
        this._name = value;
    }

    public final int getObjectId() {
        return this._objectId;
    }

    public final ObjectPoly getPoly() {
        if (this._poly == null) {
            this._poly = new ObjectPoly(this);
        }
        return this._poly;
    }

    public ObjectPosition getPosition() {
        return this._position;
    }

    public void initPosition() {
        this._position = new ObjectPosition(this);
    }

    public final void setObjectPosition(ObjectPosition value) {
        this._position = value;
    }

    public L2WorldRegion getWorldRegion() {
        return this.getPosition().getWorldRegion();
    }

    public L2PcInstance getActingPlayer() {
        return null;
    }

    public void sendInfo(L2PcInstance activeChar) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName() + "[" + this.getObjectId() + "]";
    }

    public void sendPacket(L2GameServerPacket mov) {
    }
}

