/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.communitybbs.Manager.FavoriteManager;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.entity.DimensionalRift;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.ExCloseMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExOpenMPCC;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.ExPartyPetWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PartyMemberPosition;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowAdd;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowAll;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowDelete;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowDeleteAll;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Stats;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.NoSuchElementException;
import javolution.util.FastList;

public class L2Party {
    private static final double[] BONUS_EXP_SP = new double[]{1.0, 1.3, 1.39, 1.5, 1.54, 1.58, 1.63, 1.67, 1.71};
    private final FastList<L2PcInstance> _members = new FastList();
    private boolean _pendingInvitation = false;
    private int _partyLvl = 0;
    private int _itemDistribution = 0;
    private int _itemLastLoot = 0;
    private L2CommandChannel _commandChannel = null;
    private DimensionalRift _dr;
    public static final int ITEM_LOOTER = 0;
    public static final int ITEM_RANDOM = 1;
    public static final int ITEM_RANDOM_SPOIL = 2;
    public static final int ITEM_ORDER = 3;
    public static final int ITEM_ORDER_SPOIL = 4;

    public L2Party(L2PcInstance leader, int itemDistribution) {
        this._itemDistribution = itemDistribution;
        this.getPartyMembers().add((Object)leader);
        this._partyLvl = leader.getLevel();
    }

    public int getMemberCount() {
        return this.getPartyMembers().size();
    }

    public boolean getPendingInvitation() {
        return this._pendingInvitation;
    }

    public void setPendingInvitation(boolean val) {
        this._pendingInvitation = val;
    }

    public final FastList<L2PcInstance> getPartyMembers() {
        return this._members;
    }

    private L2PcInstance getCheckedRandomMember(int ItemId, L2Character target) {
        FastList availableMembers = new FastList();
        for (L2PcInstance member : this.getPartyMembers()) {
            if (!member.getInventory().validateCapacityByItemId(ItemId) || !Util.checkIfInRange(Config.ALT_PARTY_RANGE2, target, member, true)) continue;
            availableMembers.add(member);
        }
        if (!availableMembers.isEmpty()) {
            return (L2PcInstance)availableMembers.get(Rnd.get(availableMembers.size()));
        }
        return null;
    }

    private L2PcInstance getCheckedNextLooter(int ItemId, L2Character target) {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            if (++this._itemLastLoot >= this.getMemberCount()) {
                this._itemLastLoot = 0;
            }
            try {
                L2PcInstance member = (L2PcInstance)this.getPartyMembers().get(this._itemLastLoot);
                if (!member.getInventory().validateCapacityByItemId(ItemId) || !Util.checkIfInRange(Config.ALT_PARTY_RANGE2, target, member, true)) continue;
                return member;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return null;
    }

    private L2PcInstance getActualLooter(L2PcInstance player, int ItemId, boolean spoil, L2Character target) {
        L2PcInstance looter = player;
        switch (this._itemDistribution) {
            case 1: {
                if (spoil) break;
                looter = this.getCheckedRandomMember(ItemId, target);
                break;
            }
            case 2: {
                looter = this.getCheckedRandomMember(ItemId, target);
                break;
            }
            case 3: {
                if (spoil) break;
                looter = this.getCheckedNextLooter(ItemId, target);
                break;
            }
            case 4: {
                looter = this.getCheckedNextLooter(ItemId, target);
            }
        }
        if (looter == null) {
            looter = player;
        }
        return looter;
    }

    public boolean isLeader(L2PcInstance player) {
        return this.getLeader().equals(player);
    }

    public int getPartyLeaderOID() {
        return this.getLeader().getObjectId();
    }

    public void broadcastToPartyMembers(L2GameServerPacket msg) {
        for (L2PcInstance member : this.getPartyMembers()) {
            if (member == null) continue;
            member.sendPacket(msg);
        }
    }

    public void broadcastToPartyMembersNewLeader() {
        for (L2PcInstance member : this.getPartyMembers()) {
            if (member == null) continue;
            member.sendPacket(new PartySmallWindowDeleteAll());
            member.sendPacket(new PartySmallWindowAll(member, this));
            member.broadcastUserInfo();
        }
    }

    public void broadcastCSToPartyMembers(CreatureSay msg, L2PcInstance broadcaster) {
        for (L2PcInstance member : this.getPartyMembers()) {
            if (member == null || BlockList.isBlocked(member, broadcaster)) continue;
            member.sendPacket(msg);
        }
    }

    public void broadcastToPartyMembers(L2PcInstance player, L2GameServerPacket msg) {
        for (L2PcInstance member : this.getPartyMembers()) {
            if (member == null || member.equals(player)) continue;
            member.sendPacket(msg);
        }
    }

    public synchronized void addPartyMember(L2PcInstance player) {
        int roomId;
        L2Summon summon;
        if (this.getPartyMembers().contains((Object)player)) {
            return;
        }
        player.sendPacket(new PartySmallWindowAll(player, this));
        for (L2PcInstance pMember : this.getPartyMembers()) {
            if (pMember == null || (summon = pMember.getPet()) == null) continue;
            player.sendPacket(new ExPartyPetWindowAdd(summon));
        }
        SystemMessage msg = new SystemMessage(SystemMessageId.YOU_JOINED_S1_PARTY);
        msg.addString(this.getLeader().getName());
        player.sendPacket(msg);
        msg = new SystemMessage(SystemMessageId.C1_JOINED_PARTY);
        msg.addString(player.getName());
        this.broadcastToPartyMembers(msg);
        this.broadcastToPartyMembers(new PartySmallWindowAdd(player));
        player.sendPacket(new PartyMemberPosition(player));
        this.broadcastToPartyMembers(player, new PartyMemberPosition(player));
        if (player.getPet() != null) {
            this.broadcastToPartyMembers(new ExPartyPetWindowAdd(player.getPet()));
        }
        if ((roomId = FavoriteManager.getInstance().getRoomIdByCharId(player.getObjectId())) != -1) {
            FavoriteManager.getInstance().brodeCastRoomInfo(player, roomId);
        }
        this.getPartyMembers().add((Object)player);
        if (player.getLevel() > this._partyLvl) {
            this._partyLvl = player.getLevel();
        }
        for (L2PcInstance member : this.getPartyMembers()) {
            if (member == null) continue;
            member.updateEffectIcons(true);
            summon = member.getPet();
            member.broadcastUserInfo();
            if (summon == null) continue;
            summon.updateEffectIcons();
        }
        if (this.isInDimensionalRift()) {
            this._dr.partyMemberInvited();
        }
        if (this.isInCommandChannel()) {
            player.sendPacket(new ExOpenMPCC());
        }
    }

    public void removePartyMember(String name) {
        L2PcInstance player = this.getPlayerByName(name);
        if (player != null) {
            this.removePartyMember(player);
        }
    }

    public synchronized void removePartyMember(L2PcInstance player) {
        if (this.getPartyMembers().contains((Object)player)) {
            int roomId;
            boolean isLeader = this.isLeader(player);
            this.getPartyMembers().remove((Object)player);
            this.recalculatePartyLevel();
            if (player.isFestivalParticipant()) {
                SevenSignsFestival.getInstance().updateParticipants(player, this);
            }
            if (player.isInDuel()) {
                DuelManager.getInstance().onRemoveFromParty(player);
            }
            try {
                if (player.getFusionSkill() != null) {
                    player.abortCast();
                }
                for (L2Character character : player.getKnownList().getKnownCharacters()) {
                    if (character.getFusionSkill() == null || character.getFusionSkill().getTarget() != player) continue;
                    character.abortCast();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            SystemMessage msg = new SystemMessage(SystemMessageId.YOU_LEFT_PARTY);
            player.sendPacket(msg);
            player.sendPacket(new PartySmallWindowDeleteAll());
            player.setParty(null);
            msg = new SystemMessage(SystemMessageId.C1_LEFT_PARTY);
            msg.addString(player.getName());
            this.broadcastToPartyMembers(msg);
            this.broadcastToPartyMembers(new PartySmallWindowDelete(player));
            L2Summon summon = player.getPet();
            if (summon != null) {
                this.broadcastToPartyMembers(new ExPartyPetWindowDelete(summon));
            }
            if ((roomId = FavoriteManager.getInstance().getRoomIdByCharId(player.getObjectId())) != -1) {
                FavoriteManager.getInstance().brodeCastRoomInfo(player, roomId);
            }
            if (this.isInDimensionalRift()) {
                this._dr.partyMemberExited(player);
            }
            if (this.isInCommandChannel()) {
                player.sendPacket(new ExCloseMPCC());
            }
            if (isLeader && this.getPartyMembers().size() > 1) {
                msg = new SystemMessage(SystemMessageId.C1_HAS_BECOME_A_PARTY_LEADER);
                msg.addString(this.getLeader().getName());
                this.broadcastToPartyMembers(msg);
                this.broadcastToPartyMembersNewLeader();
            }
            if (this.getPartyMembers().size() == 1) {
                L2PcInstance leader;
                if (this.isInCommandChannel()) {
                    if (this.getCommandChannel().getChannelLeader().equals(this.getLeader())) {
                        this.getCommandChannel().disbandChannel();
                    } else {
                        this.getCommandChannel().removeParty(this);
                    }
                }
                if ((leader = this.getLeader()) != null) {
                    leader.setParty(null);
                    if (leader.isInDuel()) {
                        DuelManager.getInstance().onRemoveFromParty(leader);
                    }
                }
                this._members.clear();
            }
        }
    }

    public void changePartyLeader(String name) {
        L2PcInstance player = this.getPlayerByName(name);
        if (player != null && !player.isInDuel()) {
            if (this.getPartyMembers().contains((Object)player)) {
                if (this.isLeader(player)) {
                    player.sendPacket(new SystemMessage(SystemMessageId.YOU_CANNOT_TRANSFER_RIGHTS_TO_YOURSELF));
                } else {
                    int p1 = this.getPartyMembers().indexOf((Object)player);
                    L2PcInstance temp = this.getLeader();
                    this.getPartyMembers().set(0, this.getPartyMembers().get(p1));
                    this.getPartyMembers().set(p1, (Object)temp);
                    SystemMessage msg = new SystemMessage(SystemMessageId.C1_HAS_BECOME_A_PARTY_LEADER);
                    msg.addString(this.getLeader().getName());
                    this.broadcastToPartyMembers(msg);
                    this.broadcastToPartyMembersNewLeader();
                    if (this.isInCommandChannel() && temp.equals(this._commandChannel.getChannelLeader())) {
                        this._commandChannel.setChannelLeader(this.getLeader());
                        msg = new SystemMessage(SystemMessageId.COMMAND_CHANNEL_LEADER_NOW_C1);
                        msg.addString(this._commandChannel.getChannelLeader().getName());
                        this._commandChannel.broadcastToChannelMembers(msg);
                    }
                }
            } else {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_CAN_TRANSFER_RIGHTS_ONLY_TO_ANOTHER_PARTY_MEMBER));
            }
        }
    }

    private L2PcInstance getPlayerByName(String name) {
        for (L2PcInstance member : this.getPartyMembers()) {
            if (!member.getName().equalsIgnoreCase(name)) continue;
            return member;
        }
        return null;
    }

    public void distributeItem(L2PcInstance player, L2ItemInstance item) {
        if (item.getItemId() == 57) {
            this.distributeAdena(player, item.getCount(), player);
            ItemTable.getInstance().destroyItem("Party", item, player, null);
            return;
        }
        L2PcInstance target = this.getActualLooter(player, item.getItemId(), false, player);
        target.addItem("Party", item, player, true);
        if (item.getCount() > 1L) {
            SystemMessage msg = new SystemMessage(SystemMessageId.C1_OBTAINED_S3_S2);
            msg.addString(target.getName());
            msg.addItemName(item);
            msg.addItemNumber(item.getCount());
            this.broadcastToPartyMembers(target, msg);
        } else {
            SystemMessage msg = new SystemMessage(SystemMessageId.C1_OBTAINED_S2);
            msg.addString(target.getName());
            msg.addItemName(item);
            this.broadcastToPartyMembers(target, msg);
        }
    }

    public void distributeItem(L2PcInstance player, L2Attackable.RewardItem item, boolean spoil, L2Attackable target) {
        if (item == null) {
            return;
        }
        if (item.getItemId() == 57) {
            this.distributeAdena(player, item.getCount(), target);
            return;
        }
        L2PcInstance looter = this.getActualLooter(player, item.getItemId(), spoil, target);
        looter.addItem(spoil ? "Sweep" : "Party", item.getItemId(), item.getCount(), player, true);
        if (item.getCount() > 1) {
            SystemMessage msg = spoil ? new SystemMessage(SystemMessageId.C1_SWEEPED_UP_S3_S2) : new SystemMessage(SystemMessageId.C1_OBTAINED_S3_S2);
            msg.addString(looter.getName());
            msg.addItemName(item.getItemId());
            msg.addItemNumber(item.getCount());
            this.broadcastToPartyMembers(looter, msg);
        } else {
            SystemMessage msg = spoil ? new SystemMessage(SystemMessageId.C1_SWEEPED_UP_S2) : new SystemMessage(SystemMessageId.C1_OBTAINED_S2);
            msg.addString(looter.getName());
            msg.addItemName(item.getItemId());
            this.broadcastToPartyMembers(looter, msg);
        }
    }

    public void distributeAdena(L2PcInstance player, long adena, L2Character target) {
        FastList<L2PcInstance> membersList = this.getPartyMembers();
        FastList ToReward = new FastList();
        for (L2PcInstance member : membersList) {
            if (!Util.checkIfInRange(Config.ALT_PARTY_RANGE2, target, member, true)) continue;
            ToReward.add(member);
        }
        if (ToReward == null || ToReward.isEmpty()) {
            return;
        }
        long count = adena / (long)ToReward.size();
        for (L2PcInstance member : ToReward) {
            member.addAdena("Party", count, player, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void distributeXpAndSp(long xpReward, int spReward, List<L2Playable> rewardedMembers, int topLvl, int partyDmg, L2Attackable target) {
        L2SummonInstance summon = null;
        List<L2Playable> validMembers = this.getValidMembers(rewardedMembers, topLvl);
        xpReward = (long)((double)xpReward * this.getExpBonus(validMembers.size()));
        spReward = (int)((double)spReward * this.getSpBonus(validMembers.size()));
        double sqLevelSum = 0.0;
        for (L2Playable character : validMembers) {
            sqLevelSum += (double)(character.getLevel() * character.getLevel());
        }
        float vitalityPoints = target.getVitalityPoints(partyDmg) * Config.RATE_PARTY_XP / (float)validMembers.size();
        boolean useVitalityRate = target.useVitalityRate();
        List<L2Playable> list = rewardedMembers;
        synchronized (list) {
            for (L2Playable member : rewardedMembers) {
                if (member.isDead()) continue;
                float penalty = 0.0f;
                if (member.getPet() instanceof L2SummonInstance) {
                    summon = (L2SummonInstance)member.getPet();
                    penalty = summon.getExpPenalty();
                }
                if (member instanceof L2PetInstance) {
                    if (((L2PetInstance)member).getPetData().getOwnerExpTaken() > 0.0f) continue;
                    penalty = 0.85f;
                }
                if (validMembers.contains(member)) {
                    double sqLevel = member.getLevel() * member.getLevel();
                    double preCalculation = sqLevel / sqLevelSum * (double)(1.0f - penalty);
                    if (member.isDead()) continue;
                    long addexp = Math.round(member.calcStat(Stats.EXPSP_RATE, (double)xpReward * preCalculation, null, null));
                    int addsp = (int)member.calcStat(Stats.EXPSP_RATE, (double)spReward * preCalculation, null, null);
                    if (member instanceof L2PcInstance) {
                        L2Skill skill;
                        L2PcInstance player = (L2PcInstance)member;
                        if (target != null && player.getSkillLevel(467) > 0 && (long)(skill = SkillTable.getInstance().getInfo(467, player.getSkillLevel(467))).getExpNeeded() <= addexp) {
                            player.absorbSoul(skill, target);
                        }
                        player.addExpAndSp(addexp, addsp, useVitalityRate);
                        if (addexp <= 0L) continue;
                        player.updateVitalityPoints(vitalityPoints, true, false);
                        continue;
                    }
                    member.addExpAndSp(addexp, addsp);
                    continue;
                }
                member.addExpAndSp(0L, 0);
            }
        }
    }

    public void recalculatePartyLevel() {
        int newLevel = 0;
        for (L2PcInstance member : this.getPartyMembers()) {
            if (member == null) {
                this.getPartyMembers().remove((Object)member);
                continue;
            }
            if (member.getLevel() <= newLevel) continue;
            newLevel = member.getLevel();
        }
        this._partyLvl = newLevel;
    }

    private List<L2Playable> getValidMembers(List<L2Playable> members, int topLvl) {
        FastList validMembers;
        block8: {
            block9: {
                block7: {
                    validMembers = new FastList();
                    if (!Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("level")) break block7;
                    for (L2Playable member : members) {
                        if (topLvl - member.getLevel() > Config.PARTY_XP_CUTOFF_LEVEL) continue;
                        validMembers.add(member);
                    }
                    break block8;
                }
                if (!Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("percentage")) break block9;
                int sqLevelSum = 0;
                for (L2Playable member : members) {
                    sqLevelSum += member.getLevel() * member.getLevel();
                }
                for (L2Playable member : members) {
                    int sqLevel = member.getLevel() * member.getLevel();
                    if (!((double)(sqLevel * 100) >= (double)sqLevelSum * Config.PARTY_XP_CUTOFF_PERCENT)) continue;
                    validMembers.add(member);
                }
                break block8;
            }
            if (!Config.PARTY_XP_CUTOFF_METHOD.equalsIgnoreCase("auto")) break block8;
            int sqLevelSum = 0;
            for (L2Playable member : members) {
                sqLevelSum += member.getLevel() * member.getLevel();
            }
            int i = members.size() - 1;
            if (i < 1) {
                return members;
            }
            if (i >= BONUS_EXP_SP.length) {
                i = BONUS_EXP_SP.length - 1;
            }
            for (L2Playable member : members) {
                int sqLevel = member.getLevel() * member.getLevel();
                if (!((double)sqLevel >= (double)sqLevelSum * (1.0 - 1.0 / (1.0 + BONUS_EXP_SP[i] - BONUS_EXP_SP[i - 1])))) continue;
                validMembers.add(member);
            }
        }
        return validMembers;
    }

    private double getBaseExpSpBonus(int membersCount) {
        int i = membersCount - 1;
        if (i < 1) {
            return 1.0;
        }
        if (i >= BONUS_EXP_SP.length) {
            i = BONUS_EXP_SP.length - 1;
        }
        return BONUS_EXP_SP[i];
    }

    private double getExpBonus(int membersCount) {
        if (membersCount < 2) {
            return this.getBaseExpSpBonus(membersCount);
        }
        return this.getBaseExpSpBonus(membersCount) * (double)Config.RATE_PARTY_XP;
    }

    private double getSpBonus(int membersCount) {
        if (membersCount < 2) {
            return this.getBaseExpSpBonus(membersCount);
        }
        return this.getBaseExpSpBonus(membersCount) * (double)Config.RATE_PARTY_SP;
    }

    public int getLevel() {
        return this._partyLvl;
    }

    public int getLootDistribution() {
        return this._itemDistribution;
    }

    public boolean isInCommandChannel() {
        return this._commandChannel != null;
    }

    public L2CommandChannel getCommandChannel() {
        return this._commandChannel;
    }

    public void setCommandChannel(L2CommandChannel channel) {
        this._commandChannel = channel;
    }

    public boolean isInDimensionalRift() {
        return this._dr != null;
    }

    public void setDimensionalRift(DimensionalRift dr) {
        this._dr = dr;
    }

    public DimensionalRift getDimensionalRift() {
        return this._dr;
    }

    public L2PcInstance getLeader() {
        try {
            return (L2PcInstance)this._members.getFirst();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }
}

