/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public final class L2ArtefactInstance
extends L2Npc {
    public L2ArtefactInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this.getCastle().registerArtefact(this);
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }

    @Override
    public boolean isAttackable() {
        return false;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (!this.canTarget(player)) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact && !this.canInteract(player)) {
            player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onForcedAttack(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, L2Skill skill) {
    }

    @Override
    public void reduceCurrentHp(double damage, L2Character attacker, boolean awake, boolean isDOT, L2Skill skill) {
    }
}

