/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2CastleBlacksmithInstance
extends L2NpcInstance {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;

    public L2CastleBlacksmithInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (CastleManorManager.getInstance().isDisabled()) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile("data/html/npcdefault.htm");
            html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
            html.replace((CharSequence)"%npcname%", this.getName());
            player.sendPacket(html);
            return;
        }
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            return;
        }
        if (condition == 1) {
            return;
        }
        if (condition == 2) {
            if (command.startsWith("Chat")) {
                int val = 0;
                try {
                    val = Integer.parseInt(command.substring(5));
                }
                catch (IndexOutOfBoundsException ioobe) {
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                this.showChatWindow(player, val);
                return;
            }
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        if (CastleManorManager.getInstance().isDisabled()) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile("data/html/npcdefault.htm");
            html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
            html.replace((CharSequence)"%npcname%", this.getName());
            player.sendPacket(html);
            return;
        }
        String filename = "data/html/castleblacksmith/castleblacksmith-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/castleblacksmith/castleblacksmith-busy.htm";
            } else if (condition == 2) {
                filename = val == 0 ? "data/html/castleblacksmith/castleblacksmith.htm" : "data/html/castleblacksmith/castleblacksmith-" + val + ".htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        html.replace((CharSequence)"%npcname%", this.getName());
        html.replace((CharSequence)"%castleid%", Integer.toString(this.getCastle().getCastleId()));
        player.sendPacket(html);
    }

    protected int validateCondition(L2PcInstance player) {
        if (player.isGM()) {
            return 2;
        }
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getSiege().getIsInProgress()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId() && (player.getClanPrivileges() & 0x20000) == 131072) {
                return 2;
            }
        }
        return 0;
    }
}

