/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.util.Rnd;

public class L2CastleMagicianInstance
extends L2NpcInstance {
    protected static final int COND_ALL_FALSE = 0;
    protected static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    protected static final int COND_OWNER = 2;
    private static final int[] TalismanIds = new int[]{9914, 9915, 9917, 9918, 9919, 9920, 9921, 9922, 9923, 9924, 9926, 9927, 9928, 9930, 9931, 9932, 9933, 9934, 9935, 9936, 9937, 9938, 9939, 9940, 9941, 9942, 9943, 9944, 9945, 9946, 9947, 9948, 9949, 9950, 9951, 9952, 9953, 9954, 9955, 9956, 9957, 9958, 9959, 9960, 9961, 9962, 9963, 9964, 9965, 9966, 10141, 10142, 10158};

    public L2CastleMagicianInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void showChatWindow(L2PcInstance player, int val) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        String filename = "data/html/castlemagician/magician-no.htm";
        int condition = this.validateCondition(player);
        if (condition > 0) {
            if (condition == 1) {
                filename = "data/html/castlemagician/magician-busy.htm";
            } else if (condition == 2) {
                filename = val == 0 ? "data/html/castlemagician/magician.htm" : "data/html/castlemagician/magician-" + val + ".htm";
            }
        }
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(filename);
        html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
        player.sendPacket(html);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.startsWith("Chat")) {
            int val = 0;
            try {
                val = Integer.parseInt(command.substring(5));
            }
            catch (IndexOutOfBoundsException ioobe) {
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            this.showChatWindow(player, val);
            return;
        }
        if (command.startsWith("ExchangeKE")) {
            String filename = null;
            int item = TalismanIds[Rnd.get(TalismanIds.length)];
            if (player.destroyItemByItemId("ExchangeKE", 9912, 10L, this, false)) {
                SystemMessage msg = new SystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                msg.addItemName(9912);
                msg.addNumber(10);
                player.sendPacket(msg);
                player.addItem("ExchangeKE", item, 1L, player, true);
                filename = "data/html/castlemagician/magician-KE-Exchange.htm";
            } else {
                filename = "data/html/castlemagician/magician-no-KE.htm";
            }
            this.showChatWindow(player, filename);
            return;
        }
        if (command.equals("gotoleader")) {
            if (player.getClan() != null) {
                L2PcInstance clanLeader = player.getClan().getLeader().getPlayerInstance();
                if (clanLeader == null) {
                    return;
                }
                if (clanLeader.getFirstEffect(L2EffectType.CLAN_GATE) != null) {
                    if (!L2CastleMagicianInstance.validateGateCondition(clanLeader, player)) {
                        return;
                    }
                    player.teleToLocation(clanLeader.getX(), clanLeader.getY(), clanLeader.getZ(), false);
                    return;
                }
                String filename = "data/html/castlemagician/magician-nogate.htm";
                this.showChatWindow(player, filename);
            }
            return;
        }
        super.onBypassFeedback(player, command);
    }

    protected int validateCondition(L2PcInstance player) {
        if (player.isGM()) {
            return 2;
        }
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && player.getClan() != null) {
            if (this.getCastle().getSiege().getIsInProgress()) {
                return 1;
            }
            if (this.getCastle().getOwnerId() == player.getClanId()) {
                return 2;
            }
        }
        return 0;
    }

    private static final boolean validateGateCondition(L2PcInstance clanLeader, L2PcInstance player) {
        if (clanLeader.isAlikeDead()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInStoreMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isRooted() || clanLeader.isInCombat()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInOlympiadMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isFestivalParticipant()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.inObserverMode()) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.isInsideZone((byte)12)) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (clanLeader.getInstanceId() > 0 && (!Config.ALLOW_SUMMON_TO_INSTANCE || InstanceManager.getInstance().getInstance(player.getInstanceId()).isSummonAllowed())) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        if (player.isIn7sDungeon()) {
            int targetCabal = SevenSigns.getInstance().getPlayerCabal(clanLeader);
            if (SevenSigns.getInstance().isSealValidationPeriod()) {
                if (targetCabal != SevenSigns.getInstance().getCabalHighestScore()) {
                    player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
                    return false;
                }
            } else if (targetCabal == 0) {
                player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
                return false;
            }
        }
        if (!TvTEvent.onEscapeUse(player.getObjectId())) {
            player.sendMessage("You on TvT Event, teleporting disabled.");
            return false;
        }
        if (!TvTEvent.onEscapeUse(clanLeader.getObjectId())) {
            player.sendMessage("Couldn't teleport to clan leader. The requirements was not meet.");
            return false;
        }
        return true;
    }
}

