/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2DoorAI;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.model.actor.knownlist.DoorKnownList;
import com.l2jserver.gameserver.model.actor.stat.DoorStat;
import com.l2jserver.gameserver.model.actor.status.DoorStatus;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.ClanHall;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ConfirmDlg;
import com.l2jserver.gameserver.network.serverpackets.DoorStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.StaticObject;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.Collection;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2DoorInstance
extends L2Character {
    protected static final Logger log = Logger.getLogger(L2DoorInstance.class.getName());
    private int _castleIndex = -2;
    private int _mapRegion = -1;
    private int _fortIndex = -2;
    private int _rangeXMin = 0;
    private int _rangeYMin = 0;
    private int _rangeZMin = 0;
    private int _rangeXMax = 0;
    private int _rangeYMax = 0;
    private int _rangeZMax = 0;
    private int _A = 0;
    private int _B = 0;
    private int _C = 0;
    private int _D = 0;
    protected final int _doorId;
    protected final String _name;
    private boolean _open;
    private boolean _isCommanderDoor;
    private boolean _unlockable;
    private int _level;
    private ClanHall _clanHall;
    protected int _autoActionDelay = -1;
    private ScheduledFuture<?> _autoActionTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public L2CharacterAI getAI() {
        L2CharacterAI ai = this._ai;
        if (ai == null) {
            L2DoorInstance l2DoorInstance = this;
            synchronized (l2DoorInstance) {
                if (this._ai == null) {
                    this._ai = new L2DoorAI(new AIAccessor());
                }
                return this._ai;
            }
        }
        return ai;
    }

    public L2DoorInstance(int objectId, L2CharTemplate template, int doorId, String name, boolean unlockable) {
        super(objectId, template);
        this.setIsInvul(false);
        this._doorId = doorId;
        this._name = name;
        this._unlockable = unlockable;
    }

    @Override
    public final DoorKnownList getKnownList() {
        return (DoorKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new DoorKnownList(this));
    }

    @Override
    public final DoorStat getStat() {
        return (DoorStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new DoorStat(this));
    }

    @Override
    public final DoorStatus getStatus() {
        return (DoorStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new DoorStatus(this));
    }

    public final boolean isUnlockable() {
        return this._unlockable;
    }

    public final void setLevel(int newLevel) {
        this._level = newLevel;
    }

    @Override
    public final int getLevel() {
        return this._level;
    }

    public int getDoorId() {
        return this._doorId;
    }

    public boolean getOpen() {
        return this._open;
    }

    public void setOpen(boolean open) {
        this._open = open;
    }

    public void setIsCommanderDoor(boolean val) {
        this._isCommanderDoor = val;
    }

    public boolean getIsCommanderDoor() {
        return this._isCommanderDoor;
    }

    public void setAutoActionDelay(int actionDelay) {
        if (this._autoActionDelay == actionDelay) {
            return;
        }
        if (actionDelay > -1) {
            AutoOpenClose ao = new AutoOpenClose();
            ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(ao, actionDelay, actionDelay);
        } else if (this._autoActionTask != null) {
            this._autoActionTask.cancel(false);
        }
        this._autoActionDelay = actionDelay;
    }

    public int getDamage() {
        int dmg = 6 - (int)Math.ceil(this.getCurrentHp() / (double)this.getMaxHp() * 6.0);
        if (dmg > 6) {
            return 6;
        }
        if (dmg < 0) {
            return 0;
        }
        return dmg;
    }

    public final Castle getCastle() {
        if (this._castleIndex < 0) {
            this._castleIndex = CastleManager.getInstance().getCastleIndex(this);
        }
        if (this._castleIndex < 0) {
            return null;
        }
        return CastleManager.getInstance().getCastles().get(this._castleIndex);
    }

    public final Fort getFort() {
        if (this._fortIndex < 0) {
            this._fortIndex = FortManager.getInstance().getFortIndex(this);
        }
        if (this._fortIndex < 0) {
            return null;
        }
        return FortManager.getInstance().getForts().get(this._fortIndex);
    }

    public void setClanHall(ClanHall clanhall) {
        this._clanHall = clanhall;
    }

    public ClanHall getClanHall() {
        return this._clanHall;
    }

    public boolean isEnemy() {
        if (this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress()) {
            return true;
        }
        return this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getSiege().getIsInProgress() && !this.getIsCommanderDoor();
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        L2Clan clan;
        boolean isFort;
        if (this.isUnlockable() && this.getFort() == null) {
            return true;
        }
        if (!(attacker instanceof L2Playable)) {
            return false;
        }
        boolean isCastle = this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress();
        boolean bl = isFort = this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getSiege().getIsInProgress() && !this.getIsCommanderDoor();
        if (isFort ? (attacker instanceof L2SummonInstance ? (clan = ((L2SummonInstance)attacker).getOwner().getClan()) != null && clan == this.getFort().getOwnerClan() : attacker instanceof L2PcInstance && (clan = ((L2PcInstance)attacker).getClan()) != null && clan == this.getFort().getOwnerClan()) : isCastle && (attacker instanceof L2SummonInstance ? (clan = ((L2SummonInstance)attacker).getOwner().getClan()) != null && clan.getClanId() == this.getCastle().getOwnerId() : attacker instanceof L2PcInstance && (clan = ((L2PcInstance)attacker).getClan()) != null && clan.getClanId() == this.getCastle().getOwnerId())) {
            return false;
        }
        return isCastle || isFort;
    }

    public boolean isAttackable(L2Character attacker) {
        return this.isAutoAttackable(attacker);
    }

    @Override
    public void updateAbnormalEffect() {
    }

    public int getDistanceToWatchObject(L2Object object) {
        if (!(object instanceof L2PcInstance)) {
            return 0;
        }
        return 2000;
    }

    public int getDistanceToForgetObject(L2Object object) {
        if (!(object instanceof L2PcInstance)) {
            return 0;
        }
        return 4000;
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        return null;
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return null;
    }

    @Override
    public L2Weapon getSecondaryWeaponItem() {
        return null;
    }

    @Override
    public void onAction(L2PcInstance player, boolean interact) {
        if (player == null) {
            return;
        }
        if (this != player.getTarget()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), 0);
            player.sendPacket(my);
            StaticObject su = new StaticObject(this, false);
            if (this.getCastle() != null && this.getCastle().getCastleId() > 0 || this.getFort() != null && this.getFort().getFortId() > 0 && !this.getIsCommanderDoor()) {
                su = new StaticObject(this, true);
            }
            player.sendPacket(su);
            player.sendPacket(new ValidateLocation(this));
        } else if (interact) {
            if (this.isAutoAttackable(player)) {
                if (Math.abs(player.getZ() - this.getZ()) < 400) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this);
                }
            } else if (player.getClan() != null && this.getClanHall() != null && player.getClanId() == this.getClanHall().getOwnerId()) {
                if (!this.isInsideRadius(player, 150, false, false)) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                } else {
                    player.gatesRequest(this);
                    if (!this.getOpen()) {
                        player.sendPacket(new ConfirmDlg(1140));
                    } else {
                        player.sendPacket(new ConfirmDlg(1141));
                    }
                }
            } else if (player.getClan() != null && this.getFort() != null && player.getClan() == this.getFort().getOwnerClan() && this.isUnlockable() && !this.getFort().getSiege().getIsInProgress()) {
                if (!this.isInsideRadius(player, 150, false, false)) {
                    player.getAI().setIntention(CtrlIntention.AI_INTENTION_INTERACT, this);
                } else {
                    player.gatesRequest(this);
                    if (!this.getOpen()) {
                        player.sendPacket(new ConfirmDlg(1140));
                    } else {
                        player.sendPacket(new ConfirmDlg(1141));
                    }
                }
            }
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onActionShift(L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (player.getAccessLevel().isGm()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel());
            player.sendPacket(my);
            StaticObject su = new StaticObject(this, false);
            if (this.getCastle() != null && this.getCastle().getCastleId() > 0 || this.getFort() != null && this.getFort().getFortId() > 0 && !this.getIsCommanderDoor()) {
                su = new StaticObject(this, true);
            }
            player.sendPacket(su);
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            String html1 = StringUtil.concat("<html><body><center><font color=\"LEVEL\">Door Info</font></center><br><table border=0><tr><td>HP: </td><td>", String.valueOf(this.getCurrentHp()), " / ", String.valueOf(this.getMaxHp()), "</td></tr><tr><td>Level       ", String.valueOf(this.getLevel()), "</td></tr><tr><td>Unlockable  ", String.valueOf(this.isUnlockable()), "</td></tr><tr><td> </td></tr><tr><td>Max X,Y,Z: </td><td>", String.valueOf(this.getXMax()), ", ", String.valueOf(this.getYMax()), ", ", String.valueOf(this.getZMax()), "</td></tr><tr><td>Min X,Y,Z: </td><td>", String.valueOf(this.getXMin()), ", ", String.valueOf(this.getYMin()), ", ", String.valueOf(this.getZMin()), "</td></tr><tr><td>Object ID: </td><td>", String.valueOf(this.getObjectId()), "</td></tr><tr><td>Door ID: </td><td>", String.valueOf(this.getDoorId()), "</td></tr><tr><td><br></td></tr><tr><td>Class: </td><td>", this.getClass().getSimpleName(), "</td></tr></table><br><table><tr><td><button value=\"Open\" action=\"bypass -h admin_open ", String.valueOf(this.getDoorId()), "\" width=40 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td><td><button value=\"Close\" action=\"bypass -h admin_close ", String.valueOf(this.getDoorId()), "\" width=40 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td><td><button value=\"Kill\" action=\"bypass -h admin_kill\" width=40 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td><td><button value=\"Delete\" action=\"bypass -h admin_delete\" width=40 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr></table></body></html>");
            html.setHtml(html1);
            player.sendPacket(html);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void broadcastStatusUpdate() {
        Collection<L2PcInstance> knownPlayers = this.getKnownList().getKnownPlayers().values();
        if (knownPlayers == null || knownPlayers.isEmpty()) {
            return;
        }
        StaticObject su = new StaticObject(this, false);
        DoorStatusUpdate dsu = new DoorStatusUpdate(this);
        for (L2PcInstance player : knownPlayers) {
            if (this.getCastle() != null && this.getCastle().getCastleId() > 0 || this.getFort() != null && this.getFort().getFortId() > 0 && !this.getIsCommanderDoor()) {
                su = new StaticObject(this, true);
            }
            player.sendPacket(su);
            player.sendPacket(dsu);
        }
    }

    public void onOpen() {
        ThreadPoolManager.getInstance().scheduleGeneral(new CloseTask(), 60000L);
    }

    public void onClose() {
        this.closeMe();
    }

    public final void closeMe() {
        this.setOpen(false);
        this.broadcastStatusUpdate();
    }

    public final void openMe() {
        this.setOpen(true);
        this.broadcastStatusUpdate();
    }

    @Override
    public String toString() {
        return "door " + this._doorId;
    }

    public String getDoorName() {
        return this._name;
    }

    public int getXMin() {
        return this._rangeXMin;
    }

    public int getYMin() {
        return this._rangeYMin;
    }

    public int getZMin() {
        return this._rangeZMin;
    }

    public int getXMax() {
        return this._rangeXMax;
    }

    public int getYMax() {
        return this._rangeYMax;
    }

    public int getZMax() {
        return this._rangeZMax;
    }

    public void setRange(int xMin, int yMin, int zMin, int xMax, int yMax, int zMax) {
        this._rangeXMin = xMin;
        this._rangeYMin = yMin;
        this._rangeZMin = zMin;
        this._rangeXMax = xMax;
        this._rangeYMax = yMax;
        this._rangeZMax = zMax;
        this._A = this._rangeYMax * (this._rangeZMax - this._rangeZMin) + this._rangeYMin * (this._rangeZMin - this._rangeZMax);
        this._B = this._rangeZMin * (this._rangeXMax - this._rangeXMin) + this._rangeZMax * (this._rangeXMin - this._rangeXMax);
        this._C = this._rangeXMin * (this._rangeYMax - this._rangeYMin) + this._rangeXMin * (this._rangeYMin - this._rangeYMax);
        this._D = -1 * (this._rangeXMin * (this._rangeYMax * this._rangeZMax - this._rangeYMin * this._rangeZMax) + this._rangeXMax * (this._rangeYMin * this._rangeZMin - this._rangeYMin * this._rangeZMax) + this._rangeXMin * (this._rangeYMin * this._rangeZMax - this._rangeYMax * this._rangeZMin));
    }

    public int getMapRegion() {
        return this._mapRegion;
    }

    public void setMapRegion(int region) {
        this._mapRegion = region;
    }

    public Collection<L2DefenderInstance> getKnownDefenders() {
        FastList result = new FastList();
        Collection<L2Object> objs = this.getKnownList().getKnownObjects().values();
        for (L2Object obj : objs) {
            if (!(obj instanceof L2DefenderInstance)) continue;
            result.add((Object)((L2DefenderInstance)obj));
        }
        return result;
    }

    public int getA() {
        return this._A;
    }

    public int getB() {
        return this._B;
    }

    public int getC() {
        return this._C;
    }

    public int getD() {
        return this._D;
    }

    @Override
    public boolean doDie(L2Character killer) {
        boolean isCastle;
        if (!super.doDie(killer)) {
            return false;
        }
        boolean isFort = this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getSiege().getIsInProgress() && !this.getIsCommanderDoor();
        boolean bl = isCastle = this.getCastle() != null && this.getCastle().getCastleId() > 0 && this.getCastle().getSiege().getIsInProgress();
        if (isFort || isCastle) {
            this.broadcastPacket(new SystemMessage(SystemMessageId.CASTLE_GATE_BROKEN_DOWN));
        }
        return true;
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        activeChar.sendPacket(new StaticObject(this, false));
    }

    class AutoOpenClose
    implements Runnable {
        AutoOpenClose() {
        }

        @Override
        public void run() {
            try {
                String doorAction;
                if (!L2DoorInstance.this.getOpen()) {
                    doorAction = "opened";
                    L2DoorInstance.this.openMe();
                } else {
                    doorAction = "closed";
                    L2DoorInstance.this.closeMe();
                }
                if (Config.DEBUG) {
                    L2Character._log.info("Auto " + doorAction + " door ID " + L2DoorInstance.this._doorId + " (" + L2DoorInstance.this._name + ") for " + L2DoorInstance.this._autoActionDelay / 60000 + " minute(s).");
                }
            }
            catch (Exception e) {
                L2Character._log.warning("Could not auto open/close door ID " + L2DoorInstance.this._doorId + " (" + L2DoorInstance.this._name + ")");
            }
        }
    }

    class CloseTask
    implements Runnable {
        CloseTask() {
        }

        @Override
        public void run() {
            try {
                L2DoorInstance.this.onClose();
            }
            catch (Exception e) {
                L2Character._log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        protected AIAccessor() {
        }

        @Override
        public L2DoorInstance getActor() {
            return L2DoorInstance.this;
        }

        @Override
        public void moveTo(int x, int y, int z, int offset) {
        }

        @Override
        public void moveTo(int x, int y, int z) {
        }

        @Override
        public void stopMove(L2CharPosition pos) {
        }

        @Override
        public void doAttack(L2Character target) {
        }

        @Override
        public void doCast(L2Skill skill) {
        }
    }
}

