/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TradeController;
import com.l2jserver.gameserver.datatables.MerchantPriceConfigTable;
import com.l2jserver.gameserver.model.L2Multisell;
import com.l2jserver.gameserver.model.L2TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExBuySellListPacket;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.ShopPreviewList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.StringUtil;
import java.util.StringTokenizer;

public class L2MerchantInstance
extends L2NpcInstance {
    private MerchantPriceConfigTable.MerchantPriceConfig _mpc;

    public L2MerchantInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        this._mpc = MerchantPriceConfigTable.getInstance().getMerchantPriceConfig(this);
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/merchant/", npcId, val);
    }

    public MerchantPriceConfigTable.MerchantPriceConfig getMpc() {
        return this._mpc;
    }

    private final void showWearWindow(L2PcInstance player, int val) {
        L2TradeList list;
        player.tempInventoryDisable();
        if (Config.DEBUG) {
            _log.fine("Showing wearlist");
        }
        if ((list = TradeController.getInstance().getBuyList(val)) != null) {
            ShopPreviewList bl = new ShopPreviewList(list, player.getAdena(), player.getExpertiseIndex());
            player.sendPacket(bl);
        } else {
            _log.warning("no buylist with id:" + val);
            player.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    protected final void showBuyWindow(L2PcInstance player, int val) {
        L2TradeList list;
        double taxRate = 0.0;
        taxRate = this.getMpc().getTotalTaxRate();
        player.tempInventoryDisable();
        if (Config.DEBUG) {
            _log.fine("Showing buylist");
        }
        if ((list = TradeController.getInstance().getBuyList(val)) != null && list.getNpcId().equals(String.valueOf(this.getNpcId()))) {
            player.sendPacket(new ExBuySellListPacket(player, list, taxRate, false));
        } else {
            _log.warning("possible client hacker: " + player.getName() + " attempting to buy from GM shop! < Ban him!");
            _log.warning("buylist id:" + val);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        StringTokenizer st = new StringTokenizer(command, " ");
        String actualCommand = st.nextToken();
        if (actualCommand.equalsIgnoreCase("Buy")) {
            if (st.countTokens() < 1) {
                return;
            }
            int val = Integer.parseInt(st.nextToken());
            this.showBuyWindow(player, val);
        } else if (actualCommand.equalsIgnoreCase("BuyShadowItem")) {
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            if (player.getLevel() >= 40) {
                html.setFile("data/html/merchant/shadow_item.htm");
            } else {
                html.setFile("data/html/merchant/shadow_item-lowlevel.htm");
            }
            html.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
            player.sendPacket(html);
        } else if (actualCommand.equalsIgnoreCase("RentPet")) {
            if (Config.ALLOW_RENTPET) {
                if (st.countTokens() < 1) {
                    this.showRentPetWindow(player);
                } else {
                    int val = Integer.parseInt(st.nextToken());
                    this.tryRentPet(player, val);
                }
            }
        } else if (actualCommand.equalsIgnoreCase("Wear")) {
            if (!Config.ALLOW_WEAR) {
                return;
            }
            if (st.countTokens() < 1) {
                return;
            }
            int val = Integer.parseInt(st.nextToken());
            this.showWearWindow(player, val);
        } else if (actualCommand.equalsIgnoreCase("Multisell")) {
            if (st.countTokens() < 1) {
                return;
            }
            int val = Integer.parseInt(st.nextToken());
            L2Multisell.getInstance().separateAndSend(val, player, this.getNpcId(), false, this.getCastle().getTaxRate());
        } else if (actualCommand.equalsIgnoreCase("Exc_Multisell")) {
            if (st.countTokens() < 1) {
                return;
            }
            int val = Integer.parseInt(st.nextToken());
            L2Multisell.getInstance().separateAndSend(val, player, this.getNpcId(), true, this.getCastle().getTaxRate());
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    public final void showRentPetWindow(L2PcInstance player) {
        if (!Config.LIST_PET_RENT_NPC.contains(this.getTemplate().npcId)) {
            return;
        }
        this.insertObjectIdAndShowChatWindow(player, "<html><body>\u30da\u30c3\u30c8\u7ba1\u7406\u4eba:<br>\u30ef\u30a4\u30d0\u30fc\u30f3\u3084\u30b9\u30c8\u30e9\u30a4\u30c0\u30fc\u3092\u304a\u624b\u8efd\u306a\u4fa1\u683c\u3067\u30ec\u30f3\u30bf\u30eb\u3057\u3066\u304a\u308a\u307e\u3059\u3088\u3002<br>\u4fa1\u683c:<br1><table border=0><tr><td>\u9a0e\u4e57</td></tr><tr><td>\u30ef\u30a4\u30d0\u30fc\u30f3</td><td>\u30b9\u30c8\u30e9\u30a4\u30c0\u30fc</td></tr><tr><td><a action=\"bypass -h npc_%objectId%_RentPet 1\">30 \u79d2/1800A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 11\">30 \u79d2/900A</a></td></tr><tr><td><a action=\"bypass -h npc_%objectId%_RentPet 2\">1 \u5206/7200A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 12\">1 \u5206/3600A</a></td></tr><tr><td><a action=\"bypass -h npc_%objectId%_RentPet 3\">10 \u5206/720000A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 13\">10 \u5206/360000A</a></td></tr><tr><td><a action=\"bypass -h npc_%objectId%_RentPet 4\">30 \u5206/6480000A</a></td><td><a action=\"bypass -h npc_%objectId%_RentPet 14\">30 \u5206/3240000A</a></td></tr></table></body></html>");
    }

    public final void tryRentPet(L2PcInstance player, int val) {
        int petId;
        if (player == null || player.getPet() != null || player.isMounted() || player.isRentedPet() || player.isTransformed() || player.isCursedWeaponEquipped()) {
            return;
        }
        if (!player.disarmWeapons()) {
            return;
        }
        double price = 1.0;
        int[] cost = new int[]{1800, 7200, 720000, 6480000};
        int[] ridetime = new int[]{30, 60, 600, 1800};
        if (val > 10) {
            petId = 12526;
            val -= 10;
            price /= 2.0;
        } else {
            petId = 12621;
        }
        if (val < 1 || val > 4) {
            return;
        }
        int time = ridetime[val - 1];
        if (!player.reduceAdena("Rent", (long)(price *= (double)cost[val - 1]), player.getLastFolkNPC(), true)) {
            return;
        }
        player.mount(petId, 0, false);
        SetupGauge sg = new SetupGauge(3, time * 1000);
        player.sendPacket(sg);
        player.startRentPet(time);
    }

    @Override
    public final void onActionShift(L2PcInstance player) {
        if (player == null) {
            return;
        }
        if (player.isGM()) {
            player.setTarget(this);
            MyTargetSelected my = new MyTargetSelected(this.getObjectId(), player.getLevel() - this.getLevel());
            player.sendPacket(my);
            if (this.isAutoAttackable(player)) {
                StatusUpdate su = new StatusUpdate(this.getObjectId());
                su.addAttribute(9, (int)this.getCurrentHp());
                su.addAttribute(10, this.getMaxHp());
                player.sendPacket(su);
            }
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            StringBuilder html1 = StringUtil.startAppend(2000, "<html><body><center><font color=\"LEVEL\">Merchant Info</font></center><br><table border=0><tr><td>Object ID: </td><td>", String.valueOf(this.getObjectId()), "</td></tr><tr><td>Template ID: </td><td>", String.valueOf(this.getTemplate().npcId), "</td></tr><tr><td><br></td></tr><tr><td>HP: </td><td>", String.valueOf(this.getCurrentHp()), "</td></tr><tr><td>MP: </td><td>", String.valueOf(this.getCurrentMp()), "</td></tr><tr><td>Level: </td><td>", String.valueOf(this.getLevel()), "</td></tr><tr><td><br></td></tr><tr><td>Class: </td><td>", this.getClass().getSimpleName(), "</td></tr><tr><td><br></td></tr></table><table><tr><td><button value=\"Edit NPC\" action=\"bypass -h admin_edit_npc ", String.valueOf(this.getTemplate().npcId), "\" width=100 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td><td><button value=\"Kill\" action=\"bypass -h admin_kill\" width=60 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr><tr><td><button value=\"Show DropList\" action=\"bypass -h admin_show_droplist ", String.valueOf(this.getTemplate().npcId), "\" width=100 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr><td><button value=\"Delete\" action=\"bypass -h admin_delete\" width=60 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr><tr><td><button value=\"View Shop\" action=\"bypass -h admin_showShop ", String.valueOf(this.getTemplate().npcId), "\" width=100 height=20 back=\"L2UI_ct1.button_df\" fore=\"L2UI_ct1.button_df\"></td></tr></table>");
            html1.append("</body></html>");
            html.setHtml(html1.toString());
            player.sendPacket(html);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }
}

