/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.SetSummonRemainTime;
import com.l2jserver.gameserver.skills.l2skills.L2SkillSummon;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;

public class L2SummonInstance
extends L2Summon {
    protected static final Logger log = Logger.getLogger(L2SummonInstance.class.getName());
    private float _expPenalty = 0.0f;
    private int _itemConsumeId;
    private int _itemConsumeCount;
    private int _itemConsumeSteps;
    private final int _totalLifeTime;
    private final int _timeLostIdle;
    private final int _timeLostActive;
    private int _timeRemaining;
    private int _nextItemConsumeTime;
    public int lastShowntimeRemaining;
    private Future<?> _summonLifeTask;

    public L2SummonInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2Skill skill) {
        super(objectId, template, owner);
        this.setShowSummonAnimation(true);
        if (skill != null) {
            L2SkillSummon summonSkill = (L2SkillSummon)skill;
            this._itemConsumeId = summonSkill.getItemConsumeIdOT();
            this._itemConsumeCount = summonSkill.getItemConsumeOT();
            this._itemConsumeSteps = summonSkill.getItemConsumeSteps();
            this._totalLifeTime = summonSkill.getTotalLifeTime();
            this._timeLostIdle = summonSkill.getTimeLostIdle();
            this._timeLostActive = summonSkill.getTimeLostActive();
        } else {
            this._itemConsumeId = 0;
            this._itemConsumeCount = 0;
            this._itemConsumeSteps = 0;
            this._totalLifeTime = 1200000;
            this._timeLostIdle = 1000;
            this._timeLostActive = 1000;
        }
        this._timeRemaining = this._totalLifeTime;
        this.lastShowntimeRemaining = this._totalLifeTime;
        this._nextItemConsumeTime = this._itemConsumeId == 0 ? -1 : (this._itemConsumeSteps == 0 ? -1 : this._totalLifeTime - this._totalLifeTime / (this._itemConsumeSteps + 1));
        int delay = 1000;
        if (Config.DEBUG && this._itemConsumeCount != 0) {
            _log.warning("L2SummonInstance: Item Consume ID: " + this._itemConsumeId + ", Count: " + this._itemConsumeCount + ", Rate: " + this._itemConsumeSteps + " times.");
        }
        if (Config.DEBUG) {
            _log.warning("L2SummonInstance: Task Delay " + delay / 1000 + " seconds.");
        }
        this._summonLifeTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new SummonLifetime(this.getOwner(), this), delay, delay);
    }

    @Override
    public final int getLevel() {
        return this.getTemplate() != null ? (int)this.getTemplate().level : 0;
    }

    @Override
    public int getSummonType() {
        return 1;
    }

    public void setExpPenalty(float expPenalty) {
        this._expPenalty = expPenalty;
    }

    public float getExpPenalty() {
        return this._expPenalty;
    }

    public int getItemConsumeCount() {
        return this._itemConsumeCount;
    }

    public int getItemConsumeId() {
        return this._itemConsumeId;
    }

    public int getItemConsumeSteps() {
        return this._itemConsumeSteps;
    }

    public int getNextItemConsumeTime() {
        return this._nextItemConsumeTime;
    }

    public int getTotalLifeTime() {
        return this._totalLifeTime;
    }

    public int getTimeLostIdle() {
        return this._timeLostIdle;
    }

    public int getTimeLostActive() {
        return this._timeLostActive;
    }

    public int getTimeRemaining() {
        return this._timeRemaining;
    }

    public void setNextItemConsumeTime(int value) {
        this._nextItemConsumeTime = value;
    }

    public void decNextItemConsumeTime(int value) {
        this._nextItemConsumeTime -= value;
    }

    public void decTimeRemaining(int value) {
        this._timeRemaining -= value;
    }

    public void addExpAndSp(int addToExp, int addToSp) {
        this.getOwner().addExpAndSp(addToExp, addToSp);
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (Config.DEBUG) {
            _log.warning("L2SummonInstance: " + this.getTemplate().name + " (" + this.getOwner().getName() + ") has been killed.");
        }
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(true);
            this._summonLifeTask = null;
        }
        return true;
    }

    @Override
    public void doCast(L2Skill skill) {
        L2Skill skillToCast;
        int petLevel = this.getLevel();
        int skillLevel = petLevel / 10;
        if (petLevel >= 70) {
            skillLevel += (petLevel - 65) / 10;
        }
        if (skillLevel < 1) {
            skillLevel = 1;
        }
        if ((skillToCast = SkillTable.getInstance().getInfo(skill.getId(), skillLevel)) != null) {
            super.doCast(skillToCast);
        } else {
            super.doCast(skill);
        }
    }

    @Override
    public void unSummon(L2PcInstance owner) {
        if (Config.DEBUG) {
            _log.warning("L2SummonInstance: " + this.getTemplate().name + " (" + owner.getName() + ") unsummoned.");
        }
        if (this._summonLifeTask != null) {
            this._summonLifeTask.cancel(true);
            this._summonLifeTask = null;
        }
        super.unSummon(owner);
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        return this.getOwner().destroyItem(process, objectId, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (Config.DEBUG) {
            _log.warning("L2SummonInstance: " + this.getTemplate().name + " (" + this.getOwner().getName() + ") consume.");
        }
        return this.getOwner().destroyItemByItemId(process, itemId, count, reference, sendMessage);
    }

    @Override
    public byte getAttackElement() {
        if (this.getOwner() == null || !this.getOwner().getClassId().isSummoner()) {
            return super.getAttackElement();
        }
        return this.getOwner().getAttackElement();
    }

    @Override
    public int getAttackElementValue(byte attribute) {
        if (this.getOwner() == null || !this.getOwner().getClassId().isSummoner()) {
            return super.getAttackElementValue(attribute);
        }
        return 4 * this.getOwner().getAttackElementValue(attribute);
    }

    @Override
    public int getDefenseElementValue(byte attribute) {
        if (this.getOwner() == null || !this.getOwner().getClassId().isSummoner()) {
            return super.getDefenseElementValue(attribute);
        }
        return super.getDefenseElementValue(attribute) + this.getOwner().getDefenseElementValue(attribute);
    }

    static class SummonLifetime
    implements Runnable {
        private L2PcInstance _activeChar;
        private L2SummonInstance _summon;

        SummonLifetime(L2PcInstance activeChar, L2SummonInstance newpet) {
            this._activeChar = activeChar;
            this._summon = newpet;
        }

        @Override
        public void run() {
            if (Config.DEBUG) {
                log.warning("L2SummonInstance: " + this._summon.getTemplate().name + " (" + this._activeChar.getName() + ") run task.");
            }
            try {
                double oldTimeRemaining = this._summon.getTimeRemaining();
                int maxTime = this._summon.getTotalLifeTime();
                if (this._summon.isAttackingNow()) {
                    this._summon.decTimeRemaining(this._summon.getTimeLostActive());
                } else {
                    this._summon.decTimeRemaining(this._summon.getTimeLostIdle());
                }
                double newTimeRemaining = this._summon.getTimeRemaining();
                if (newTimeRemaining < 0.0) {
                    this._summon.unSummon(this._activeChar);
                } else if (newTimeRemaining <= (double)this._summon.getNextItemConsumeTime() && oldTimeRemaining > (double)this._summon.getNextItemConsumeTime()) {
                    this._summon.decNextItemConsumeTime(maxTime / (this._summon.getItemConsumeSteps() + 1));
                    if (this._summon.getItemConsumeCount() > 0 && this._summon.getItemConsumeId() != 0 && !this._summon.isDead() && !this._summon.destroyItemByItemId("Consume", this._summon.getItemConsumeId(), this._summon.getItemConsumeCount(), this._activeChar, true)) {
                        this._summon.unSummon(this._activeChar);
                    }
                }
                if ((double)this._summon.lastShowntimeRemaining - newTimeRemaining > (double)(maxTime / 352)) {
                    this._summon.getOwner().sendPacket(new SetSummonRemainTime(maxTime, (int)newTimeRemaining));
                    this._summon.lastShowntimeRemaining = (int)newTimeRemaining;
                    this._summon.updateEffectIcons();
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error on player [" + this._activeChar.getName() + "] summon item consume task.", e);
            }
        }
    }
}

