/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.datatables.HennaTreeTable;
import com.l2jserver.gameserver.model.L2HennaInstance;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.HennaEquipList;
import com.l2jserver.gameserver.network.serverpackets.HennaRemoveList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public class L2SymbolMakerInstance
extends L2Npc {
    public L2SymbolMakerInstance(int objectID, L2NpcTemplate template) {
        super(objectID, template);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (command.equals("Draw")) {
            L2HennaInstance[] henna = HennaTreeTable.getInstance().getAvailableHenna(player.getClassId());
            player.sendPacket(new HennaEquipList(player, henna));
        } else if (command.equals("RemoveList")) {
            boolean hasHennas = false;
            for (int i = 1; i <= 3; ++i) {
                L2HennaInstance henna = player.getHenna(i);
                if (henna == null) continue;
                hasHennas = true;
            }
            if (hasHennas) {
                player.sendPacket(new HennaRemoveList(player));
            }
        } else {
            super.onBypassFeedback(player, command);
        }
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return "data/html/symbolmaker/SymbolMaker.htm";
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return false;
    }
}

