/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SortedWareHouseWithdrawalList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.WareHouseDepositList;
import com.l2jserver.gameserver.network.serverpackets.WareHouseWithdrawalList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;

public final class L2WarehouseInstance
extends L2NpcInstance {
    public L2WarehouseInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
    }

    @Override
    public boolean isWarehouse() {
        return true;
    }

    @Override
    public String getHtmlPath(int npcId, int val) {
        return this.getHtmlPath("data/html/warehouse/", npcId, val);
    }

    private void showRetrieveWindow(L2PcInstance player, SortedWareHouseWithdrawalList.WarehouseListType itemtype, byte sortorder) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        player.setActiveWarehouse(player.getWarehouse());
        if (player.getActiveWarehouse().getSize() == 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.NO_ITEM_DEPOSITED_IN_WH));
            return;
        }
        if (itemtype != null) {
            player.sendPacket(new SortedWareHouseWithdrawalList(player, 1, itemtype, sortorder));
        } else {
            player.sendPacket(new WareHouseWithdrawalList(player, 1));
        }
        if (Config.DEBUG) {
            _log.fine("Source: L2WarehouseInstance.java; Player: " + player.getName() + "; Command: showRetrieveWindow; Message: Showing stored items.");
        }
    }

    private void showDepositWindow(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        player.setActiveWarehouse(player.getWarehouse());
        player.tempInventoryDisable();
        if (Config.DEBUG) {
            _log.fine("Source: L2WarehouseInstance.java; Player: " + player.getName() + "; Command: showDepositWindow; Message: Showing items to deposit.");
        }
        player.sendPacket(new WareHouseDepositList(player, 1));
    }

    private void showDepositWindowClan(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        if (player.getClan() != null) {
            if (player.getClan().getLevel() == 0) {
                player.sendPacket(new SystemMessage(SystemMessageId.ONLY_LEVEL_1_CLAN_OR_HIGHER_CAN_USE_WAREHOUSE));
            } else {
                player.setActiveWarehouse(player.getClan().getWarehouse());
                player.tempInventoryDisable();
                WareHouseDepositList dl = new WareHouseDepositList(player, 4);
                player.sendPacket(dl);
                if (Config.DEBUG) {
                    _log.fine("Source: L2WarehouseInstance.java; Player: " + player.getName() + "; Command: showDepositWindowClan; Message: Showing items to deposit.");
                }
            }
        }
    }

    private void showWithdrawWindowClan(L2PcInstance player, SortedWareHouseWithdrawalList.WarehouseListType itemtype, byte sortorder) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
        if (Config.DEBUG) {
            _log.fine("Source: L2WarehouseInstance.java; Player: " + player.getName() + "; Command: showWithdrawWindowClan; Message: Showing stored items.");
        }
        if ((player.getClanPrivileges() & 8) != 8) {
            player.sendPacket(new SystemMessage(SystemMessageId.YOU_DO_NOT_HAVE_THE_RIGHT_TO_USE_CLAN_WAREHOUSE));
            return;
        }
        if (player.getClan().getLevel() == 0) {
            player.sendPacket(new SystemMessage(SystemMessageId.ONLY_LEVEL_1_CLAN_OR_HIGHER_CAN_USE_WAREHOUSE));
        } else {
            player.setActiveWarehouse(player.getClan().getWarehouse());
            if (itemtype != null) {
                player.sendPacket(new SortedWareHouseWithdrawalList(player, 4, itemtype, sortorder));
            } else {
                player.sendPacket(new WareHouseWithdrawalList(player, 4));
            }
        }
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        if (player.getActiveEnchantItem() != null) {
            return;
        }
        String[] param = command.split("_");
        if (command.startsWith("WithdrawP")) {
            if (Config.L2JMOD_ENABLE_WAREHOUSESORTING_PRIVATE) {
                String htmFile = "data/html/mods/WhSortedP.htm";
                String htmContent = HtmCache.getInstance().getHtm(htmFile);
                if (htmContent != null) {
                    NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
                    npcHtmlMessage.setHtml(htmContent);
                    npcHtmlMessage.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(npcHtmlMessage);
                } else {
                    _log.warning("Missing htm: " + htmFile + "!");
                    player.sendMessage("This NPC's html is missing. Please inform the server admin.");
                }
            } else {
                this.showRetrieveWindow(player, null, (byte)0);
            }
        } else if (command.startsWith("WithdrawSortedP")) {
            if (param.length > 2) {
                this.showRetrieveWindow(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), SortedWareHouseWithdrawalList.getOrder(param[2]));
            } else if (param.length > 1) {
                this.showRetrieveWindow(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), (byte)1);
            } else {
                this.showRetrieveWindow(player, SortedWareHouseWithdrawalList.WarehouseListType.ALL, (byte)1);
            }
        } else if (command.equals("DepositP")) {
            this.showDepositWindow(player);
        } else if (command.startsWith("WithdrawC")) {
            if (Config.L2JMOD_ENABLE_WAREHOUSESORTING_CLAN) {
                String htmFile = "data/html/mods/WhSortedC.htm";
                String htmContent = HtmCache.getInstance().getHtm(htmFile);
                if (htmContent != null) {
                    NpcHtmlMessage npcHtmlMessage = new NpcHtmlMessage(this.getObjectId());
                    npcHtmlMessage.setHtml(htmContent);
                    npcHtmlMessage.replace((CharSequence)"%objectId%", String.valueOf(this.getObjectId()));
                    player.sendPacket(npcHtmlMessage);
                } else {
                    _log.warning("Missing htm: " + htmFile + "!");
                    player.sendMessage("This NPC's html is missing. Please inform the server admin.");
                }
            } else {
                this.showWithdrawWindowClan(player, null, (byte)0);
            }
        } else if (command.startsWith("WithdrawSortedC")) {
            if (param.length > 2) {
                this.showWithdrawWindowClan(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), SortedWareHouseWithdrawalList.getOrder(param[2]));
            } else if (param.length > 1) {
                this.showWithdrawWindowClan(player, SortedWareHouseWithdrawalList.WarehouseListType.valueOf(param[1]), (byte)1);
            } else {
                this.showWithdrawWindowClan(player, SortedWareHouseWithdrawalList.WarehouseListType.ALL, (byte)1);
            }
        } else if (command.equals("DepositC")) {
            this.showDepositWindowClan(player);
        } else {
            super.onBypassFeedback(player, command);
        }
    }
}

