/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class Auction {
    protected static final Logger _log = Logger.getLogger(Auction.class.getName());
    private int _id = 0;
    private int _adenaId = 57;
    private long _endDate;
    private int _highestBidderId = 0;
    private String _highestBidderName = "";
    private int _highestBidderMaxBid = 0;
    private int _itemId = 0;
    private String _itemName = "";
    private int _itemObjectId = 0;
    private int _itemQuantity = 0;
    private String _itemType = "";
    private int _sellerId = 0;
    private String _sellerClanName = "";
    private String _sellerName = "";
    private int _currentBid = 0;
    private int _startingBid = 0;
    private Map<Integer, Bidder> _bidders = new FastMap();
    private static final String[] ItemTypeName = new String[]{"ClanHall"};

    public Auction(int auctionId) {
        this._id = auctionId;
        this.load();
        this.startAutoTask();
    }

    public Auction(int itemId, L2Clan Clan, long delay, int bid, String name) {
        this._id = itemId;
        this._endDate = System.currentTimeMillis() + delay;
        this._itemId = itemId;
        this._itemName = name;
        this._itemType = "ClanHall";
        this._sellerId = Clan.getLeaderId();
        this._sellerName = Clan.getLeaderName();
        this._sellerClanName = Clan.getName();
        this._startingBid = bid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Select * from auction where id = ?");
            statement.setInt(1, this.getId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                this._currentBid = rs.getInt("currentBid");
                this._endDate = rs.getLong("endDate");
                this._itemId = rs.getInt("itemId");
                this._itemName = rs.getString("itemName");
                this._itemObjectId = rs.getInt("itemObjectId");
                this._itemType = rs.getString("itemType");
                this._sellerId = rs.getInt("sellerId");
                this._sellerClanName = rs.getString("sellerClanName");
                this._sellerName = rs.getString("sellerName");
                this._startingBid = rs.getInt("startingBid");
            }
            statement.close();
            this.loadBid();
        }
        catch (Exception e) {
            _log.warning("Exception: Auction.load(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBid() {
        this._highestBidderId = 0;
        this._highestBidderName = "";
        this._highestBidderMaxBid = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT bidderId, bidderName, maxBid, clan_name, time_bid FROM auction_bid WHERE auctionId = ? ORDER BY maxBid DESC");
            statement.setInt(1, this.getId());
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                if (rs.isFirst()) {
                    this._highestBidderId = rs.getInt("bidderId");
                    this._highestBidderName = rs.getString("bidderName");
                    this._highestBidderMaxBid = rs.getInt("maxBid");
                }
                this._bidders.put(rs.getInt("bidderId"), new Bidder(rs.getString("bidderName"), rs.getString("clan_name"), rs.getInt("maxBid"), rs.getLong("time_bid")));
            }
            statement.close();
        }
        catch (Exception e) {
            _log.warning("Exception: Auction.loadBid(): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    private void startAutoTask() {
        long currentTime = System.currentTimeMillis();
        long taskDelay = 0L;
        if (this._endDate <= currentTime) {
            this._endDate = currentTime + 604800000L;
            this.saveAuctionDate();
        } else {
            taskDelay = this._endDate - currentTime;
        }
        ThreadPoolManager.getInstance().scheduleGeneral(new AutoEndTask(), taskDelay);
    }

    public static String getItemTypeName(ItemTypeEnum value) {
        return ItemTypeName[value.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveAuctionDate() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Update auction set endDate = ? where id = ?");
            statement.setLong(1, this._endDate);
            statement.setInt(2, this._id);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: saveAuctionDate(): " + e.getMessage(), e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void setBid(L2PcInstance bidder, int bid) {
        int requiredAdena = bid;
        if (this.getHighestBidderName().equals(bidder.getClan().getLeaderName())) {
            requiredAdena = bid - this.getHighestBidderMaxBid();
        }
        if ((this.getHighestBidderId() > 0 && bid > this.getHighestBidderMaxBid() || this.getHighestBidderId() == 0 && bid >= this.getStartingBid()) && this.takeItem(bidder, this._adenaId, requiredAdena)) {
            this.updateInDB(bidder, bid);
            bidder.getClan().setAuctionBiddedAt(this._id, true);
            return;
        }
        if (bid < this.getStartingBid() || bid <= this.getHighestBidderMaxBid()) {
            bidder.sendPacket(new SystemMessage(SystemMessageId.BID_PRICE_MUST_BE_HIGHER));
        }
    }

    private void returnItem(String Clan, int itemId, int quantity, boolean penalty) {
        if (penalty) {
            quantity = (int)((double)quantity * 0.9);
        }
        ClanTable.getInstance().getClanByName(Clan).getWarehouse().addItem("Outbidded", this._adenaId, quantity, null, null);
    }

    private boolean takeItem(L2PcInstance bidder, int itemId, int quantity) {
        if (bidder.getClan() != null && bidder.getClan().getWarehouse().getAdena() >= (long)quantity) {
            bidder.getClan().getWarehouse().destroyItemByItemId("Buy", this._adenaId, quantity, bidder, bidder);
            return true;
        }
        bidder.sendPacket(new SystemMessage(SystemMessageId.NOT_ENOUGH_ADENA_IN_CWH));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInDB(L2PcInstance bidder, int bid) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            if (this.getBidders().get(bidder.getClanId()) != null) {
                PreparedStatement statement = con.prepareStatement("UPDATE auction_bid SET bidderId=?, bidderName=?, maxBid=?, time_bid=? WHERE auctionId=? AND bidderId=?");
                statement.setInt(1, bidder.getClanId());
                statement.setString(2, bidder.getClan().getLeaderName());
                statement.setInt(3, bid);
                statement.setLong(4, System.currentTimeMillis());
                statement.setInt(5, this.getId());
                statement.setInt(6, bidder.getClanId());
                statement.execute();
                statement.close();
            } else {
                PreparedStatement statement = con.prepareStatement("INSERT INTO auction_bid (id, auctionId, bidderId, bidderName, maxBid, clan_name, time_bid) VALUES (?, ?, ?, ?, ?, ?, ?)");
                statement.setInt(1, IdFactory.getInstance().getNextId());
                statement.setInt(2, this.getId());
                statement.setInt(3, bidder.getClanId());
                statement.setString(4, bidder.getName());
                statement.setInt(5, bid);
                statement.setString(6, bidder.getClan().getName());
                statement.setLong(7, System.currentTimeMillis());
                statement.execute();
                statement.close();
                if (L2World.getInstance().getPlayer(this._highestBidderName) != null) {
                    L2World.getInstance().getPlayer(this._highestBidderName).sendMessage("You have been out bidded");
                }
            }
            this._highestBidderId = bidder.getClanId();
            this._highestBidderMaxBid = bid;
            this._highestBidderName = bidder.getClan().getLeaderName();
            if (this._bidders.get(this._highestBidderId) == null) {
                this._bidders.put(this._highestBidderId, new Bidder(this._highestBidderName, bidder.getClan().getName(), bid, Calendar.getInstance().getTimeInMillis()));
            } else {
                this._bidders.get(this._highestBidderId).setBid(bid);
                this._bidders.get(this._highestBidderId).setTimeBid(Calendar.getInstance().getTimeInMillis());
            }
            bidder.sendPacket(new SystemMessage(SystemMessageId.BID_IN_CLANHALL_AUCTION));
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Auction.updateInDB(L2PcInstance bidder, int bid): " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBids() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM auction_bid WHERE auctionId=?");
            statement.setInt(1, this.getId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Auction.deleteFromDB(): " + e.getMessage(), e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        for (Bidder b : this._bidders.values()) {
            if (ClanTable.getInstance().getClanByName(b.getClanName()).getHasHideout() == 0) {
                this.returnItem(b.getClanName(), this._adenaId, b.getBid(), true);
            } else if (L2World.getInstance().getPlayer(b.getName()) != null) {
                L2World.getInstance().getPlayer(b.getName()).sendMessage("Congratulation you have won ClanHall!");
            }
            ClanTable.getInstance().getClanByName(b.getClanName()).setAuctionBiddedAt(0, true);
        }
        this._bidders.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAuctionFromDB() {
        AuctionManager.getInstance().getAuctions().remove(this);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM auction WHERE itemId=?");
            statement.setInt(1, this._itemId);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Auction.deleteFromDB(): " + e.getMessage(), e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public void endAuction() {
        if (ClanHallManager.getInstance().loaded()) {
            if (this._highestBidderId == 0 && this._sellerId == 0) {
                this.startAutoTask();
                return;
            }
            if (this._highestBidderId == 0 && this._sellerId > 0) {
                int aucId = AuctionManager.getInstance().getAuctionIndex(this._id);
                AuctionManager.getInstance().getAuctions().remove(aucId);
                return;
            }
            if (this._sellerId > 0) {
                this.returnItem(this._sellerClanName, this._adenaId, this._highestBidderMaxBid, true);
                this.returnItem(this._sellerClanName, this._adenaId, ClanHallManager.getInstance().getClanHallById(this._itemId).getLease(), false);
            }
            this.deleteAuctionFromDB();
            L2Clan Clan = ClanTable.getInstance().getClanByName(this._bidders.get(this._highestBidderId).getClanName());
            this._bidders.remove(this._highestBidderId);
            Clan.setAuctionBiddedAt(0, true);
            this.removeBids();
            ClanHallManager.getInstance().setOwner(this._itemId, Clan);
        } else {
            ThreadPoolManager.getInstance().scheduleGeneral(new AutoEndTask(), 3000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void cancelBid(int bidder) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM auction_bid WHERE auctionId=? AND bidderId=?");
            statement.setInt(1, this.getId());
            statement.setInt(2, bidder);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Auction.cancelBid(String bidder): " + e.getMessage(), e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
        this.returnItem(this._bidders.get(bidder).getClanName(), this._adenaId, this._bidders.get(bidder).getBid(), true);
        ClanTable.getInstance().getClanByName(this._bidders.get(bidder).getClanName()).setAuctionBiddedAt(0, true);
        this._bidders.clear();
        this.loadBid();
    }

    public void cancelAuction() {
        this.deleteAuctionFromDB();
        this.removeBids();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirmAuction() {
        AuctionManager.getInstance().getAuctions().add(this);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO auction (id, sellerId, sellerName, sellerClanName, itemType, itemId, itemObjectId, itemName, itemQuantity, startingBid, currentBid, endDate) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)");
            statement.setInt(1, this.getId());
            statement.setInt(2, this._sellerId);
            statement.setString(3, this._sellerName);
            statement.setString(4, this._sellerClanName);
            statement.setString(5, this._itemType);
            statement.setInt(6, this._itemId);
            statement.setInt(7, this._itemObjectId);
            statement.setString(8, this._itemName);
            statement.setInt(9, this._itemQuantity);
            statement.setInt(10, this._startingBid);
            statement.setInt(11, this._currentBid);
            statement.setLong(12, this._endDate);
            statement.execute();
            statement.close();
            this.loadBid();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Exception: Auction.load(): " + e.getMessage(), e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    public final int getId() {
        return this._id;
    }

    public final int getCurrentBid() {
        return this._currentBid;
    }

    public final long getEndDate() {
        return this._endDate;
    }

    public final int getHighestBidderId() {
        return this._highestBidderId;
    }

    public final String getHighestBidderName() {
        return this._highestBidderName;
    }

    public final int getHighestBidderMaxBid() {
        return this._highestBidderMaxBid;
    }

    public final int getItemId() {
        return this._itemId;
    }

    public final String getItemName() {
        return this._itemName;
    }

    public final int getItemObjectId() {
        return this._itemObjectId;
    }

    public final int getItemQuantity() {
        return this._itemQuantity;
    }

    public final String getItemType() {
        return this._itemType;
    }

    public final int getSellerId() {
        return this._sellerId;
    }

    public final String getSellerName() {
        return this._sellerName;
    }

    public final String getSellerClanName() {
        return this._sellerClanName;
    }

    public final int getStartingBid() {
        return this._startingBid;
    }

    public final Map<Integer, Bidder> getBidders() {
        return this._bidders;
    }

    public class AutoEndTask
    implements Runnable {
        @Override
        public void run() {
            try {
                Auction.this.endAuction();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }

    public class Bidder {
        private String _name;
        private String _clanName;
        private int _bid;
        private Calendar _timeBid;

        public Bidder(String name, String clanName, int bid, long timeBid) {
            this._name = name;
            this._clanName = clanName;
            this._bid = bid;
            this._timeBid = Calendar.getInstance();
            this._timeBid.setTimeInMillis(timeBid);
        }

        public String getName() {
            return this._name;
        }

        public String getClanName() {
            return this._clanName;
        }

        public int getBid() {
            return this._bid;
        }

        public Calendar getTimeBid() {
            return this._timeBid;
        }

        public void setTimeBid(long timeBid) {
            this._timeBid.setTimeInMillis(timeBid);
        }

        public void setBid(int bid) {
            this._bid = bid;
        }
    }

    public static enum ItemTypeEnum {
        ClanHall;

    }
}

