/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.entity;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.util.Rnd;

public class TvTEventTeleporter
implements Runnable {
    private L2PcInstance _playerInstance = null;
    private int[] _coordinates = new int[3];
    private boolean _adminRemove = false;

    public TvTEventTeleporter(L2PcInstance playerInstance, int[] coordinates, boolean fastSchedule, boolean adminRemove) {
        this._playerInstance = playerInstance;
        this._coordinates = coordinates;
        this._adminRemove = adminRemove;
        long delay = (TvTEvent.isStarted() ? Config.TVT_EVENT_RESPAWN_TELEPORT_DELAY : Config.TVT_EVENT_START_LEAVE_TELEPORT_DELAY) * 1000;
        ThreadPoolManager.getInstance().scheduleGeneral(this, fastSchedule ? 0L : delay);
    }

    @Override
    public void run() {
        int TvTInstance;
        if (this._playerInstance == null) {
            return;
        }
        L2Summon summon = this._playerInstance.getPet();
        if (summon != null) {
            summon.unSummon(this._playerInstance);
        }
        if (this._playerInstance.isInDuel()) {
            this._playerInstance.setDuelState(4);
        }
        if (Config.TVT_EVENT_EFFECTS_REMOVAL == 0 || Config.TVT_EVENT_EFFECTS_REMOVAL == 1 && this._playerInstance.getTeam() == 0) {
            this._playerInstance.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        if ((TvTInstance = TvTEvent.getTvTEventInstance()) != 0) {
            if (TvTEvent.isStarted() && !this._adminRemove) {
                this._playerInstance.setInstanceId(TvTInstance);
            } else {
                this._playerInstance.setInstanceId(0);
            }
        } else {
            this._playerInstance.setInstanceId(0);
        }
        this._playerInstance.doRevive();
        this._playerInstance.teleToLocation(this._coordinates[0] + Rnd.get(101) - 50, this._coordinates[1] + Rnd.get(101) - 50, this._coordinates[2], false);
        if (TvTEvent.isStarted() && !this._adminRemove) {
            this._playerInstance.setTeam(TvTEvent.getParticipantTeamId(this._playerInstance.getObjectId()) + 1);
        } else {
            this._playerInstance.setTeam(0);
        }
        this._playerInstance.setCurrentCp(this._playerInstance.getMaxCp());
        this._playerInstance.setCurrentHp(this._playerInstance.getMaxHp());
        this._playerInstance.setCurrentMp(this._playerInstance.getMaxMp());
        this._playerInstance.broadcastStatusUpdate();
        this._playerInstance.broadcastUserInfo();
    }
}

