/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.olympiad.OlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMatchEnd;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadUserInfo;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.util.L2FastList;
import com.l2jserver.util.Util;
import gnu.trove.TIntIntHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class Olympiad {
    protected static final Logger _log = Logger.getLogger(Olympiad.class.getName());
    protected static final Logger _logResults = Logger.getLogger("olympiad");
    private static Map<Integer, StatsSet> _nobles;
    protected static L2FastList<StatsSet> _heroesToBe;
    private static L2FastList<L2PcInstance> _nonClassBasedRegisters;
    private static Map<Integer, L2FastList<L2PcInstance>> _classBasedRegisters;
    private static TIntIntHashMap _noblesRank;
    private static final String OLYMPIAD_DATA_FILE = "config/olympiad.properties";
    public static final String OLYMPIAD_HTML_PATH = "data/html/olympiad/";
    private static final String OLYMPIAD_LOAD_DATA = "SELECT current_cycle, period, olympiad_end, validation_end, next_weekly_change FROM olympiad_data WHERE id = 0";
    private static final String OLYMPIAD_SAVE_DATA = "INSERT INTO olympiad_data (id, current_cycle, period, olympiad_end, validation_end, next_weekly_change) VALUES (0,?,?,?,?,?) ON DUPLICATE KEY UPDATE current_cycle=?, period=?, olympiad_end=?, validation_end=?, next_weekly_change=?";
    private static final String OLYMPIAD_LOAD_NOBLES = "SELECT olympiad_nobles.charId, olympiad_nobles.class_id, characters.char_name, olympiad_nobles.olympiad_points, olympiad_nobles.competitions_done, olympiad_nobles.competitions_won, olympiad_nobles.competitions_lost, olympiad_nobles.competitions_drawn FROM olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId";
    private static final String OLYMPIAD_SAVE_NOBLES = "INSERT INTO olympiad_nobles (`charId`,`class_id`,`olympiad_points`,`competitions_done`,`competitions_won`,`competitions_lost`,`competitions_drawn`) VALUES (?,?,?,?,?,?,?)";
    private static final String OLYMPIAD_UPDATE_NOBLES = "UPDATE olympiad_nobles SET olympiad_points = ?, competitions_done = ?, competitions_won = ?, competitions_lost = ?, competitions_drawn = ? WHERE charId = ?";
    private static final String OLYMPIAD_GET_HEROS = "SELECT olympiad_nobles.charId, characters.char_name FROM olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND olympiad_nobles.class_id = ? AND olympiad_nobles.competitions_done >= 9 AND olympiad_nobles.competitions_won > 0 ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC";
    private static final String GET_ALL_CLASSIFIED_NOBLESS = "SELECT charId from olympiad_nobles_eom WHERE competitions_done >= 9 ORDER BY olympiad_points DESC, competitions_done DESC, competitions_won DESC";
    private static final String GET_EACH_CLASS_LEADER = "SELECT characters.char_name from olympiad_nobles_eom, characters WHERE characters.charId = olympiad_nobles_eom.charId AND olympiad_nobles_eom.class_id = ? AND olympiad_nobles_eom.competitions_done >= 9 ORDER BY olympiad_nobles_eom.olympiad_points DESC, olympiad_nobles_eom.competitions_done DESC, olympiad_nobles_eom.competitions_won DESC LIMIT 10";
    private static final String GET_EACH_CLASS_LEADER_CURRENT = "SELECT characters.char_name from olympiad_nobles, characters WHERE characters.charId = olympiad_nobles.charId AND olympiad_nobles.class_id = ? AND olympiad_nobles.competitions_done >= 9 ORDER BY olympiad_nobles.olympiad_points DESC, olympiad_nobles.competitions_done DESC, olympiad_nobles.competitions_won DESC LIMIT 10";
    private static final String OLYMPIAD_DELETE_ALL = "TRUNCATE olympiad_nobles";
    private static final String OLYMPIAD_MONTH_CLEAR = "TRUNCATE olympiad_nobles_eom";
    private static final String OLYMPIAD_MONTH_CREATE = "INSERT INTO olympiad_nobles_eom SELECT * FROM olympiad_nobles";
    private static final int[] HERO_IDS;
    private static final int COMP_START;
    private static final int COMP_MIN;
    private static final long COMP_PERIOD;
    protected static final long WEEKLY_PERIOD;
    protected static final long VALIDATION_PERIOD;
    private static final int DEFAULT_POINTS = 18;
    protected static final int WEEKLY_POINTS = 3;
    public static final String CHAR_ID = "charId";
    public static final String CLASS_ID = "class_id";
    public static final String CHAR_NAME = "char_name";
    public static final String POINTS = "olympiad_points";
    public static final String COMP_DONE = "competitions_done";
    public static final String COMP_WON = "competitions_won";
    public static final String COMP_LOST = "competitions_lost";
    public static final String COMP_DRAWN = "competitions_drawn";
    protected long _olympiadEnd;
    protected long _validationEnd;
    protected int _period;
    protected long _nextWeeklyChange;
    protected int _currentCycle;
    private long _compEnd;
    private Calendar _compStart;
    protected static boolean _inCompPeriod;
    protected static boolean _compStarted;
    protected ScheduledFuture<?> _scheduledCompStart;
    protected ScheduledFuture<?> _scheduledCompEnd;
    protected ScheduledFuture<?> _scheduledOlympiadEnd;
    protected ScheduledFuture<?> _scheduledWeeklyTask;
    protected ScheduledFuture<?> _scheduledValdationTask;

    public static Olympiad getInstance() {
        return SingletonHolder._instance;
    }

    private Olympiad() {
        this.load();
        if (this._period == 0) {
            this.init();
        }
    }

    public static Integer getStadiumCount() {
        return OlympiadManager.STADIUMS.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        ResultSet rset;
        PreparedStatement statement;
        _nobles = new FastMap();
        Connection con = null;
        boolean loaded = false;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(OLYMPIAD_LOAD_DATA);
            rset = statement.executeQuery();
            while (rset.next()) {
                this._currentCycle = rset.getInt("current_cycle");
                this._period = rset.getInt("period");
                this._olympiadEnd = rset.getLong("olympiad_end");
                this._validationEnd = rset.getLong("validation_end");
                this._nextWeeklyChange = rset.getLong("next_weekly_change");
                loaded = true;
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Olympiad System: Error loading olympiad data from database: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!loaded) {
            _log.log(Level.INFO, "Olympiad System: failed to load data from database, trying to load from file.");
            Properties OlympiadProperties = new Properties();
            InputStream is = null;
            try {
                is = new FileInputStream(new File("./config/olympiad.properties"));
                OlympiadProperties.load(is);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Olympiad System: Error loading olympiad properties: ", e);
                return;
            }
            finally {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this._currentCycle = Integer.parseInt(OlympiadProperties.getProperty("CurrentCycle", "1"));
            this._period = Integer.parseInt(OlympiadProperties.getProperty("Period", "0"));
            this._olympiadEnd = Long.parseLong(OlympiadProperties.getProperty("OlympiadEnd", "0"));
            this._validationEnd = Long.parseLong(OlympiadProperties.getProperty("ValidationEnd", "0"));
            this._nextWeeklyChange = Long.parseLong(OlympiadProperties.getProperty("NextWeeklyChange", "0"));
        }
        switch (this._period) {
            case 0: {
                if (this._olympiadEnd == 0L || this._olympiadEnd < Calendar.getInstance().getTimeInMillis()) {
                    this.setNewOlympiadEnd();
                    break;
                }
                this.scheduleWeeklyChange();
                break;
            }
            case 1: {
                if (this._validationEnd > Calendar.getInstance().getTimeInMillis()) {
                    this.loadNoblesRank();
                    this._scheduledValdationTask = ThreadPoolManager.getInstance().scheduleGeneral(new ValidationEndTask(), this.getMillisToValidationEnd());
                    break;
                }
                ++this._currentCycle;
                this._period = 0;
                this.deleteNobles();
                this.setNewOlympiadEnd();
                break;
            }
            default: {
                _log.warning("Olympiad System: Omg something went wrong in loading!! Period = " + this._period);
                return;
            }
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement(OLYMPIAD_LOAD_NOBLES);
            rset = statement.executeQuery();
            while (rset.next()) {
                StatsSet statData = new StatsSet();
                int charId = rset.getInt(CHAR_ID);
                statData.set(CLASS_ID, rset.getInt(CLASS_ID));
                statData.set(CHAR_NAME, rset.getString(CHAR_NAME));
                statData.set(POINTS, rset.getInt(POINTS));
                statData.set(COMP_DONE, rset.getInt(COMP_DONE));
                statData.set(COMP_WON, rset.getInt(COMP_WON));
                statData.set(COMP_LOST, rset.getInt(COMP_LOST));
                statData.set(COMP_DRAWN, rset.getInt(COMP_DRAWN));
                statData.set("to_save", false);
                _nobles.put(charId, statData);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Olympiad System: Error loading noblesse data from database: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Olympiad olympiad = this;
        synchronized (olympiad) {
            _log.info("Olympiad System: Loading Olympiad System....");
            if (this._period == 0) {
                _log.info("Olympiad System: Currently in Olympiad Period");
            } else {
                _log.info("Olympiad System: Currently in Validation Period");
            }
            long milliToEnd = this._period == 0 ? this.getMillisToOlympiadEnd() : this.getMillisToValidationEnd();
            _log.info("Olympiad System: " + Math.round(milliToEnd / 60000L) + " minutes until period ends");
            if (this._period == 0) {
                milliToEnd = this.getMillisToWeekChange();
                _log.info("Olympiad System: Next weekly change is in " + Math.round(milliToEnd / 60000L) + " minutes");
            }
        }
        _log.info("Olympiad System: Loaded " + _nobles.size() + " Nobles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNoblesRank() {
        _noblesRank = new TIntIntHashMap();
        TIntIntHashMap tmpPlace = new TIntIntHashMap();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(GET_ALL_CLASSIFIED_NOBLESS);
            ResultSet rset = statement.executeQuery();
            int place = 1;
            while (rset.next()) {
                tmpPlace.put(rset.getInt(CHAR_ID), place++);
            }
            rset.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Olympiad System: Error loading noblesse data from database for Ranking: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        int rank1 = (int)Math.round((double)tmpPlace.size() * 0.01);
        int rank2 = (int)Math.round((double)tmpPlace.size() * 0.1);
        int rank3 = (int)Math.round((double)tmpPlace.size() * 0.25);
        int rank4 = (int)Math.round((double)tmpPlace.size() * 0.5);
        if (rank1 == 0) {
            rank1 = 1;
            ++rank2;
            ++rank3;
            ++rank4;
        }
        for (int charId : tmpPlace.keys()) {
            if (tmpPlace.get(charId) <= rank1) {
                _noblesRank.put(charId, 1);
                continue;
            }
            if (tmpPlace.get(charId) <= rank2) {
                _noblesRank.put(charId, 2);
                continue;
            }
            if (tmpPlace.get(charId) <= rank3) {
                _noblesRank.put(charId, 3);
                continue;
            }
            if (tmpPlace.get(charId) <= rank4) {
                _noblesRank.put(charId, 4);
                continue;
            }
            _noblesRank.put(charId, 5);
        }
    }

    protected void init() {
        if (this._period == 1) {
            return;
        }
        _nonClassBasedRegisters = new L2FastList();
        _classBasedRegisters = new FastMap();
        this._compStart = Calendar.getInstance();
        this._compStart.set(11, COMP_START);
        this._compStart.set(12, COMP_MIN);
        this._compEnd = this._compStart.getTimeInMillis() + COMP_PERIOD;
        if (this._scheduledOlympiadEnd != null) {
            this._scheduledOlympiadEnd.cancel(true);
        }
        this._scheduledOlympiadEnd = ThreadPoolManager.getInstance().scheduleGeneral(new OlympiadEndTask(), this.getMillisToOlympiadEnd());
        this.updateCompStatus();
    }

    public boolean registerNoble(L2PcInstance noble, boolean classBased) {
        L2FastList<L2PcInstance> classed;
        if (!_inCompPeriod) {
            SystemMessage sm = new SystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS);
            noble.sendPacket(sm);
            return false;
        }
        if (!noble.isNoble()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD);
            sm.addPcName(noble);
            noble.sendPacket(sm);
            return false;
        }
        if (noble.getBaseClass() != noble.getClassId().getId()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_CANT_JOIN_THE_OLYMPIAD_WITH_A_SUB_CLASS_CHARACTER);
            sm.addPcName(noble);
            noble.sendPacket(sm);
            return false;
        }
        if (noble.isCursedWeaponEquipped()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_CANNOT_JOIN_OLYMPIAD_POSSESSING_S2);
            sm.addPcName(noble);
            sm.addItemName(noble.getCursedWeaponEquippedId());
            noble.sendPacket(sm);
            return false;
        }
        if ((double)noble.getInventoryLimit() * 0.8 <= (double)noble.getInventory().getSize()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_CANNOT_PARTICIPATE_IN_OLYMPIAD_INVENTORY_SLOT_EXCEEDS_80_PERCENT);
            sm.addPcName(noble);
            noble.sendPacket(sm);
            return false;
        }
        if (this.getMillisToCompEnd() < 600000L) {
            SystemMessage sm = new SystemMessage(SystemMessageId.GAME_REQUEST_CANNOT_BE_MADE);
            noble.sendPacket(sm);
            return false;
        }
        if (TvTEvent.isPlayerParticipant(noble.getObjectId())) {
            noble.sendMessage("TvT\u30a4\u30d9\u30f3\u30c8\u53c2\u52a0\u4e2d\u306e\u30d7\u30ec\u30a4\u30e4\u30fc\u306f\u3001\u30aa\u30ea\u30f3\u30d4\u30a2\u30fc\u30c9\u306b\u53c2\u52a0\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        if (_classBasedRegisters.containsKey(noble.getClassId().getId())) {
            classed = _classBasedRegisters.get(noble.getClassId().getId());
            for (L2PcInstance participant : classed) {
                if (participant.getObjectId() != noble.getObjectId()) continue;
                SystemMessage sm = new SystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_CLASS_MATCH_WAITING_LIST);
                sm.addPcName(noble);
                noble.sendPacket(sm);
                return false;
            }
        }
        if (this.isRegisteredInComp(noble)) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_IS_ALREADY_REGISTERED_ON_THE_NON_CLASS_LIMITED_MATCH_WAITING_LIST);
            sm.addPcName(noble);
            noble.sendPacket(sm);
            return false;
        }
        if (!_nobles.containsKey(noble.getObjectId())) {
            StatsSet statDat = new StatsSet();
            statDat.set(CLASS_ID, noble.getClassId().getId());
            statDat.set(CHAR_NAME, noble.getName());
            statDat.set(POINTS, 18);
            statDat.set(COMP_DONE, 0);
            statDat.set(COMP_WON, 0);
            statDat.set(COMP_LOST, 0);
            statDat.set(COMP_DRAWN, 0);
            statDat.set("to_save", true);
            _nobles.put(noble.getObjectId(), statDat);
        }
        if (classBased && this.getNoblePoints(noble.getObjectId()) < 3) {
            noble.sendMessage("Cant register when you have less than 3 points");
            return false;
        }
        if (!classBased && this.getNoblePoints(noble.getObjectId()) < 5) {
            noble.sendMessage("Cant register when you have less than 5 points");
            return false;
        }
        if (classBased) {
            if (_classBasedRegisters.containsKey(noble.getClassId().getId())) {
                classed = _classBasedRegisters.get(noble.getClassId().getId());
                classed.add(noble);
                _classBasedRegisters.remove(noble.getClassId().getId());
                _classBasedRegisters.put(noble.getClassId().getId(), classed);
            } else {
                classed = new L2FastList();
                classed.add(noble);
                _classBasedRegisters.put(noble.getClassId().getId(), classed);
            }
            SystemMessage sm = new SystemMessage(SystemMessageId.YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_CLASSIFIED_GAMES);
            noble.sendPacket(sm);
        } else {
            _nonClassBasedRegisters.add(noble);
            SystemMessage sm = new SystemMessage(SystemMessageId.YOU_HAVE_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_NO_CLASS_GAMES);
            noble.sendPacket(sm);
        }
        return true;
    }

    protected static int getNobleCount() {
        return _nobles.size();
    }

    protected static StatsSet getNobleStats(int playerId) {
        return _nobles.get(playerId);
    }

    protected static synchronized void updateNobleStats(int playerId, StatsSet stats) {
        _nobles.remove(playerId);
        _nobles.put(playerId, stats);
    }

    protected static L2FastList<L2PcInstance> getRegisteredNonClassBased() {
        return _nonClassBasedRegisters;
    }

    protected static Map<Integer, L2FastList<L2PcInstance>> getRegisteredClassBased() {
        return _classBasedRegisters;
    }

    protected static L2FastList<Integer> hasEnoughRegisteredClassed() {
        L2FastList<Integer> result = new L2FastList<Integer>();
        for (Integer classList : Olympiad.getRegisteredClassBased().keySet()) {
            if (Olympiad.getRegisteredClassBased().get(classList).size() < Config.ALT_OLY_CLASSED) continue;
            result.add(classList);
        }
        if (!result.isEmpty()) {
            return result;
        }
        return null;
    }

    protected static boolean hasEnoughRegisteredNonClassed() {
        return Olympiad.getRegisteredNonClassBased().size() >= Config.ALT_OLY_NONCLASSED;
    }

    protected static void clearRegistered() {
        _nonClassBasedRegisters.clear();
        _classBasedRegisters.clear();
    }

    public boolean isRegistered(L2PcInstance noble) {
        L2FastList<L2PcInstance> classed;
        boolean result = false;
        if (_nonClassBasedRegisters != null && _nonClassBasedRegisters.contains(noble)) {
            result = true;
        } else if (_classBasedRegisters != null && _classBasedRegisters.containsKey(noble.getClassId().getId()) && (classed = _classBasedRegisters.get(noble.getClassId().getId())) != null && classed.contains(noble)) {
            result = true;
        }
        return result;
    }

    public boolean unRegisterNoble(L2PcInstance noble) {
        if (!_inCompPeriod) {
            SystemMessage sm = new SystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_IS_NOT_CURRENTLY_IN_PROGRESS);
            noble.sendPacket(sm);
            return false;
        }
        if (!noble.isNoble()) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_DOES_NOT_MEET_REQUIREMENTS_ONLY_NOBLESS_CAN_PARTICIPATE_IN_THE_OLYMPIAD);
            sm.addString(noble.getName());
            noble.sendPacket(sm);
            return false;
        }
        if (!this.isRegistered(noble)) {
            SystemMessage sm = new SystemMessage(SystemMessageId.YOU_HAVE_NOT_BEEN_REGISTERED_IN_A_WAITING_LIST_OF_A_GAME);
            noble.sendPacket(sm);
            return false;
        }
        for (OlympiadGame game : OlympiadManager.getInstance().getOlympiadGames().values()) {
            if (game == null || game._playerOneID != noble.getObjectId() && game._playerTwoID != noble.getObjectId()) continue;
            noble.sendMessage("Can't deregister whilst you are already selected for a game");
            return false;
        }
        if (_nonClassBasedRegisters.contains(noble)) {
            _nonClassBasedRegisters.remove(noble);
        } else {
            L2FastList<L2PcInstance> classed = _classBasedRegisters.get(noble.getClassId().getId());
            classed.remove(noble);
            _classBasedRegisters.remove(noble.getClassId().getId());
            _classBasedRegisters.put(noble.getClassId().getId(), classed);
        }
        SystemMessage sm = new SystemMessage(SystemMessageId.YOU_HAVE_BEEN_DELETED_FROM_THE_WAITING_LIST_OF_A_GAME);
        noble.sendPacket(sm);
        return true;
    }

    public void removeDisconnectedCompetitor(L2PcInstance player) {
        if (OlympiadManager.getInstance().getOlympiadGame(player.getOlympiadGameId()) != null) {
            OlympiadManager.getInstance().getOlympiadGame(player.getOlympiadGameId()).handleDisconnect(player);
        }
        L2FastList<L2PcInstance> classed = _classBasedRegisters.get(player.getClassId().getId());
        if (_nonClassBasedRegisters.contains(player)) {
            _nonClassBasedRegisters.remove(player);
        } else if (classed != null && classed.contains(player)) {
            classed.remove(player);
            _classBasedRegisters.remove(player.getClassId().getId());
            _classBasedRegisters.put(player.getClassId().getId(), classed);
        }
    }

    public void notifyCompetitorDamage(L2PcInstance player, int damage, int gameId) {
        if (OlympiadManager.getInstance().getOlympiadGames().get(gameId) != null) {
            OlympiadManager.getInstance().getOlympiadGames().get(gameId).addDamage(player, damage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCompStatus() {
        Olympiad olympiad = this;
        synchronized (olympiad) {
            long milliToStart = this.getMillisToCompBegin();
            double numSecs = milliToStart / 1000L % 60L;
            double countDown = ((double)(milliToStart / 1000L) - numSecs) / 60.0;
            int numMins = (int)Math.floor(countDown % 60.0);
            countDown = (countDown - (double)numMins) / 60.0;
            int numHours = (int)Math.floor(countDown % 24.0);
            int numDays = (int)Math.floor((countDown - (double)numHours) / 24.0);
            _log.info("Olympiad System: Competition Period Starts in " + numDays + " days, " + numHours + " hours and " + numMins + " mins.");
            _log.info("Olympiad System: Event starts/started : " + Util.dateFormat(this._compStart));
        }
        this._scheduledCompStart = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (Olympiad.this.isOlympiadEnd()) {
                    return;
                }
                _inCompPeriod = true;
                OlympiadManager om = OlympiadManager.getInstance();
                Announcements.getInstance().announceToAll(new SystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_HAS_STARTED));
                _log.info("Olympiad System: Olympiad Game Started");
                _logResults.info("Result,Player1,Player2,Player1 HP,Player2 HP,Player1 Damage,Player2 Damage,Points,Classed");
                Thread olyCycle = new Thread(om);
                olyCycle.start();
                long regEnd = Olympiad.this.getMillisToCompEnd() - 600000L;
                if (regEnd > 0L) {
                    ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                        @Override
                        public void run() {
                            Announcements.getInstance().announceToAll(new SystemMessage(SystemMessageId.OLYMPIAD_REGISTRATION_PERIOD_ENDED));
                        }
                    }, regEnd);
                }
                Olympiad.this._scheduledCompEnd = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

                    @Override
                    public void run() {
                        if (Olympiad.this.isOlympiadEnd()) {
                            return;
                        }
                        _inCompPeriod = false;
                        Announcements.getInstance().announceToAll(new SystemMessage(SystemMessageId.THE_OLYMPIAD_GAME_HAS_ENDED));
                        _log.info("Olympiad System: Olympiad Game Ended");
                        while (OlympiadGame._battleStarted) {
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        Olympiad.this.saveOlympiadStatus();
                        Olympiad.this.init();
                    }
                }, Olympiad.this.getMillisToCompEnd());
            }
        }, this.getMillisToCompBegin());
    }

    private long getMillisToOlympiadEnd() {
        return this._olympiadEnd - Calendar.getInstance().getTimeInMillis();
    }

    public void manualSelectHeroes() {
        if (this._scheduledOlympiadEnd != null) {
            this._scheduledOlympiadEnd.cancel(true);
        }
        this._scheduledOlympiadEnd = ThreadPoolManager.getInstance().scheduleGeneral(new OlympiadEndTask(), 0L);
    }

    protected long getMillisToValidationEnd() {
        if (this._validationEnd > Calendar.getInstance().getTimeInMillis()) {
            return this._validationEnd - Calendar.getInstance().getTimeInMillis();
        }
        return 10L;
    }

    public boolean isOlympiadEnd() {
        return this._period != 0;
    }

    protected void setNewOlympiadEnd() {
        SystemMessage sm = new SystemMessage(SystemMessageId.OLYMPIAD_PERIOD_S1_HAS_STARTED);
        sm.addNumber(this._currentCycle);
        Announcements.getInstance().announceToAll(sm);
        Calendar currentTime = Calendar.getInstance();
        currentTime.add(2, 1);
        currentTime.set(5, 1);
        currentTime.set(9, 0);
        currentTime.set(10, 12);
        currentTime.set(12, 0);
        currentTime.set(13, 0);
        this._olympiadEnd = currentTime.getTimeInMillis();
        Calendar nextChange = Calendar.getInstance();
        this._nextWeeklyChange = nextChange.getTimeInMillis() + WEEKLY_PERIOD;
        this.scheduleWeeklyChange();
    }

    public boolean inCompPeriod() {
        return _inCompPeriod;
    }

    private long getMillisToCompBegin() {
        if (this._compStart.getTimeInMillis() < Calendar.getInstance().getTimeInMillis() && this._compEnd > Calendar.getInstance().getTimeInMillis()) {
            return 10L;
        }
        if (this._compStart.getTimeInMillis() > Calendar.getInstance().getTimeInMillis()) {
            return this._compStart.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        }
        return this.setNewCompBegin();
    }

    private long setNewCompBegin() {
        this._compStart = Calendar.getInstance();
        this._compStart.set(11, COMP_START);
        this._compStart.set(12, COMP_MIN);
        this._compStart.add(11, 24);
        this._compEnd = this._compStart.getTimeInMillis() + COMP_PERIOD;
        _log.info("Olympiad System: New Schedule @ " + this._compStart.getTime());
        return this._compStart.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
    }

    protected long getMillisToCompEnd() {
        return this._compEnd - Calendar.getInstance().getTimeInMillis();
    }

    private long getMillisToWeekChange() {
        if (this._nextWeeklyChange > Calendar.getInstance().getTimeInMillis()) {
            return this._nextWeeklyChange - Calendar.getInstance().getTimeInMillis();
        }
        return 10L;
    }

    private void scheduleWeeklyChange() {
        this._scheduledWeeklyTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Olympiad.this.addWeeklyPoints();
                _log.info("Olympiad System: Added weekly points to nobles");
                Calendar nextChange = Calendar.getInstance();
                Olympiad.this._nextWeeklyChange = nextChange.getTimeInMillis() + WEEKLY_PERIOD;
            }
        }, this.getMillisToWeekChange(), WEEKLY_PERIOD);
    }

    protected synchronized void addWeeklyPoints() {
        if (this._period == 1) {
            return;
        }
        for (Integer nobleId : _nobles.keySet()) {
            StatsSet nobleInfo = _nobles.get(nobleId);
            int currentPoints = nobleInfo.getInteger(POINTS);
            nobleInfo.set(POINTS, currentPoints += 3);
            Olympiad.updateNobleStats(nobleId, nobleInfo);
        }
    }

    public FastMap<Integer, String> getMatchList() {
        return OlympiadManager.getInstance().getAllTitles();
    }

    public L2PcInstance[] getPlayers(int Id) {
        if (OlympiadManager.getInstance().getOlympiadGame(Id) == null) {
            return null;
        }
        return OlympiadManager.getInstance().getOlympiadGame(Id).getPlayers();
    }

    public int getCurrentCycle() {
        return this._currentCycle;
    }

    public static void addSpectator(int id, L2PcInstance spectator, boolean storeCoords) {
        if (Olympiad.getInstance().isRegisteredInComp(spectator)) {
            spectator.sendPacket(new SystemMessage(SystemMessageId.WHILE_YOU_ARE_ON_THE_WAITING_LIST_YOU_ARE_NOT_ALLOWED_TO_WATCH_THE_GAME));
            return;
        }
        if (!TvTEvent.isInactive() && TvTEvent.isPlayerParticipant(spectator.getObjectId())) {
            spectator.sendMessage("You can not observe games while registered for TvT");
            return;
        }
        OlympiadManager.STADIUMS[id].addSpectator(id, spectator, storeCoords);
    }

    public static int getSpectatorArena(L2PcInstance player) {
        for (int i = 0; i < OlympiadManager.STADIUMS.length; ++i) {
            if (!OlympiadManager.STADIUMS[i].getSpectators().contains(player)) continue;
            return i;
        }
        return -1;
    }

    public static void removeSpectator(int id, L2PcInstance spectator) {
        try {
            OlympiadManager.STADIUMS[id].removeSpectator(spectator);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public L2FastList<L2PcInstance> getSpectators(int id) {
        try {
            if (OlympiadManager.getInstance().getOlympiadGame(id) == null) {
                return null;
            }
            return OlympiadManager.STADIUMS[id].getSpectators();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }

    public Map<Integer, OlympiadGame> getOlympiadGames() {
        return OlympiadManager.getInstance().getOlympiadGames();
    }

    public boolean playerInStadia(L2PcInstance player) {
        return ZoneManager.getInstance().getOlympiadStadium(player) != null;
    }

    public int[] getWaitingList() {
        int[] array = new int[2];
        if (!this.inCompPeriod()) {
            return null;
        }
        int classCount = 0;
        if (_classBasedRegisters.size() != 0) {
            for (L2FastList<L2PcInstance> classed : _classBasedRegisters.values()) {
                classCount += classed.size();
            }
        }
        array[0] = classCount;
        array[1] = _nonClassBasedRegisters.size();
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void saveNobleData() {
        if (_nobles == null || _nobles.isEmpty()) {
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            for (Integer nobleId : _nobles.keySet()) {
                PreparedStatement statement;
                StatsSet nobleInfo = _nobles.get(nobleId);
                if (nobleInfo == null) continue;
                int charId = nobleId;
                int classId = nobleInfo.getInteger(CLASS_ID);
                int points = nobleInfo.getInteger(POINTS);
                int compDone = nobleInfo.getInteger(COMP_DONE);
                int compWon = nobleInfo.getInteger(COMP_WON);
                int compLost = nobleInfo.getInteger(COMP_LOST);
                int compDrawn = nobleInfo.getInteger(COMP_DRAWN);
                boolean toSave = nobleInfo.getBool("to_save");
                if (toSave) {
                    statement = con.prepareStatement(OLYMPIAD_SAVE_NOBLES);
                    statement.setInt(1, charId);
                    statement.setInt(2, classId);
                    statement.setInt(3, points);
                    statement.setInt(4, compDone);
                    statement.setInt(5, compWon);
                    statement.setInt(6, compLost);
                    statement.setInt(7, compDrawn);
                    nobleInfo.set("to_save", false);
                    Olympiad.updateNobleStats(nobleId, nobleInfo);
                } else {
                    statement = con.prepareStatement(OLYMPIAD_UPDATE_NOBLES);
                    statement.setInt(1, points);
                    statement.setInt(2, compDone);
                    statement.setInt(3, compWon);
                    statement.setInt(4, compLost);
                    statement.setInt(5, compDrawn);
                    statement.setInt(6, charId);
                }
                statement.execute();
                statement.close();
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Olympiad System: Failed to save noblesse data to database: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveOlympiadStatus() {
        this.saveNobleData();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(OLYMPIAD_SAVE_DATA);
            statement.setInt(1, this._currentCycle);
            statement.setInt(2, this._period);
            statement.setLong(3, this._olympiadEnd);
            statement.setLong(4, this._validationEnd);
            statement.setLong(5, this._nextWeeklyChange);
            statement.setInt(6, this._currentCycle);
            statement.setInt(7, this._period);
            statement.setLong(8, this._olympiadEnd);
            statement.setLong(9, this._validationEnd);
            statement.setLong(10, this._nextWeeklyChange);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Olympiad System: Failed to save olympiad data to database: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMonthlyData() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(OLYMPIAD_MONTH_CLEAR);
            statement.execute();
            statement.close();
            statement = con.prepareStatement(OLYMPIAD_MONTH_CREATE);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "Olympiad System: Failed to update monthly noblese data: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void sortHerosToBe() {
        LogRecord record;
        if (this._period != 1) {
            return;
        }
        if (_nobles != null) {
            _logResults.info("Noble,charid,classid,compDone,points");
            for (Integer nobleId : _nobles.keySet()) {
                StatsSet nobleInfo = _nobles.get(nobleId);
                if (nobleInfo == null) continue;
                int charId = nobleId;
                int classId = nobleInfo.getInteger(CLASS_ID);
                String charName = nobleInfo.getString(CHAR_NAME);
                int points = nobleInfo.getInteger(POINTS);
                int compDone = nobleInfo.getInteger(COMP_DONE);
                record = new LogRecord(Level.INFO, charName);
                record.setParameters(new Object[]{charId, classId, compDone, points});
                _logResults.log(record);
            }
        }
        _heroesToBe = new L2FastList();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            L2FastList soulHounds = new L2FastList();
            for (int i = 0; i < HERO_IDS.length; ++i) {
                PreparedStatement statement = con.prepareStatement(OLYMPIAD_GET_HEROS);
                statement.setInt(1, HERO_IDS[i]);
                ResultSet rset = statement.executeQuery();
                if (rset.next()) {
                    StatsSet hero = new StatsSet();
                    hero.set(CLASS_ID, HERO_IDS[i]);
                    hero.set(CHAR_ID, rset.getInt(CHAR_ID));
                    hero.set(CHAR_NAME, rset.getString(CHAR_NAME));
                    if (HERO_IDS[i] == 132 || HERO_IDS[i] == 133) {
                        hero = _nobles.get(hero.getInteger(CHAR_ID));
                        hero.set(CHAR_ID, rset.getInt(CHAR_ID));
                        soulHounds.add(hero);
                    } else {
                        record = new LogRecord(Level.INFO, "Hero " + hero.getString(CHAR_NAME));
                        record.setParameters(new Object[]{hero.getInteger(CHAR_ID), hero.getInteger(CLASS_ID)});
                        _logResults.log(record);
                        _heroesToBe.add(hero);
                    }
                }
                statement.close();
                rset.close();
            }
            switch (soulHounds.size()) {
                case 0: {
                    return;
                }
                case 1: {
                    StatsSet hero = new StatsSet();
                    StatsSet winner = (StatsSet)soulHounds.get(0);
                    hero.set(CLASS_ID, winner.getInteger(CLASS_ID));
                    hero.set(CHAR_ID, winner.getInteger(CHAR_ID));
                    hero.set(CHAR_NAME, winner.getString(CHAR_NAME));
                    record = new LogRecord(Level.INFO, "Hero " + hero.getString(CHAR_NAME));
                    record.setParameters(new Object[]{hero.getInteger(CHAR_ID), hero.getInteger(CLASS_ID)});
                    _logResults.log(record);
                    _heroesToBe.add(hero);
                    return;
                }
                case 2: {
                    StatsSet hero = new StatsSet();
                    StatsSet hero1 = (StatsSet)soulHounds.get(0);
                    StatsSet hero2 = (StatsSet)soulHounds.get(1);
                    int hero1Points = hero1.getInteger(POINTS);
                    int hero2Points = hero2.getInteger(POINTS);
                    int hero1Comps = hero1.getInteger(COMP_DONE);
                    int hero2Comps = hero2.getInteger(COMP_DONE);
                    int hero1Wins = hero1.getInteger(COMP_WON);
                    int hero2Wins = hero2.getInteger(COMP_WON);
                    StatsSet winner = hero1Points > hero2Points ? hero1 : (hero2Points > hero1Points ? hero2 : (hero1Comps > hero2Comps ? hero1 : (hero2Comps > hero1Comps ? hero2 : (hero1Wins > hero2Wins ? hero1 : hero2))));
                    hero.set(CLASS_ID, winner.getInteger(CLASS_ID));
                    hero.set(CHAR_ID, winner.getInteger(CHAR_ID));
                    hero.set(CHAR_NAME, winner.getString(CHAR_NAME));
                    record = new LogRecord(Level.INFO, "Hero " + hero.getString(CHAR_NAME));
                    record.setParameters(new Object[]{hero.getInteger(CHAR_ID), hero.getInteger(CLASS_ID)});
                    _logResults.log(record);
                    _heroesToBe.add(hero);
                    return;
                }
            }
            return;
        }
        catch (SQLException e) {
            _log.warning("Olympiad System: Couldnt load heros from DB");
            return;
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public L2FastList<String> getClassLeaderBoard(int classId) {
        L2FastList<String> names = new L2FastList<String>();
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = Config.ALT_OLY_SHOW_MONTHLY_WINNERS ? con.prepareStatement(GET_EACH_CLASS_LEADER) : con.prepareStatement(GET_EACH_CLASS_LEADER_CURRENT);
            statement.setInt(1, classId);
            ResultSet rset = statement.executeQuery();
            while (rset.next()) {
                names.add(rset.getString(CHAR_NAME));
            }
            if (classId == 132) {
                statement.setInt(1, 133);
                rset = statement.executeQuery();
                while (rset.next()) {
                    names.add(rset.getString(CHAR_NAME));
                }
            }
            statement.close();
            rset.close();
            L2FastList<String> l2FastList = names;
            return l2FastList;
        }
        catch (SQLException e) {
            _log.warning("Olympiad System: Couldnt load olympiad leaders from DB");
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return names;
    }

    public int getNoblessePasses(L2PcInstance player, boolean clear) {
        if (this._period != 1 || _noblesRank.isEmpty()) {
            return 0;
        }
        int objId = player.getObjectId();
        if (!_noblesRank.containsKey(objId)) {
            return 0;
        }
        StatsSet noble = _nobles.get(objId);
        if (noble.getInteger(POINTS) == 0) {
            return 0;
        }
        int rank = _noblesRank.get(objId);
        int points = player.isHero() ? Config.ALT_OLY_HERO_POINTS : 0;
        switch (rank) {
            case 1: {
                points += Config.ALT_OLY_RANK1_POINTS;
                break;
            }
            case 2: {
                points += Config.ALT_OLY_RANK2_POINTS;
                break;
            }
            case 3: {
                points += Config.ALT_OLY_RANK3_POINTS;
                break;
            }
            case 4: {
                points += Config.ALT_OLY_RANK4_POINTS;
                break;
            }
            default: {
                points += Config.ALT_OLY_RANK5_POINTS;
            }
        }
        if (clear) {
            noble.set(POINTS, 0);
            Olympiad.updateNobleStats(objId, noble);
        }
        return points *= Config.ALT_OLY_GP_PER_POINT;
    }

    public boolean isRegisteredInComp(L2PcInstance player) {
        boolean result = this.isRegistered(player);
        if (_inCompPeriod) {
            for (OlympiadGame game : OlympiadManager.getInstance().getOlympiadGames().values()) {
                if (game._playerOneID != player.getObjectId() && game._playerTwoID != player.getObjectId()) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public int getNoblePoints(int objId) {
        if (_nobles.isEmpty()) {
            return 0;
        }
        StatsSet noble = _nobles.get(objId);
        if (noble == null) {
            return 0;
        }
        int points = noble.getInteger(POINTS);
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastNobleOlympiadPoints(int objId) {
        int result = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT olympiad_points FROM olympiad_nobles_eom WHERE charId = ?");
            statement.setInt(1, objId);
            ResultSet rs = statement.executeQuery();
            if (rs.first()) {
                result = rs.getInt(1);
            }
            rs.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not load last olympiad points:", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
        return result;
    }

    public int getCompetitionDone(int objId) {
        if (_nobles.isEmpty()) {
            return 0;
        }
        StatsSet noble = _nobles.get(objId);
        if (noble == null) {
            return 0;
        }
        int points = noble.getInteger(COMP_DONE);
        return points;
    }

    public int getCompetitionWon(int objId) {
        if (_nobles.isEmpty()) {
            return 0;
        }
        StatsSet noble = _nobles.get(objId);
        if (noble == null) {
            return 0;
        }
        int points = noble.getInteger(COMP_WON);
        return points;
    }

    public int getCompetitionLost(int objId) {
        if (_nobles.isEmpty()) {
            return 0;
        }
        StatsSet noble = _nobles.get(objId);
        if (noble == null) {
            return 0;
        }
        int points = noble.getInteger(COMP_LOST);
        return points;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteNobles() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement(OLYMPIAD_DELETE_ALL);
            statement.execute();
            statement.close();
        }
        catch (SQLException e) {
            _log.warning("Olympiad System: Couldnt delete nobles from DB");
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        _nobles.clear();
    }

    public static void sendMatchList(L2PcInstance player) {
        NpcHtmlMessage message = new NpcHtmlMessage(0);
        message.setFile("data/html/olympiad/olympiad_observe2.htm");
        FastMap<Integer, String> matches = Olympiad.getInstance().getMatchList();
        for (int i = 0; i < Olympiad.getStadiumCount(); ++i) {
            int arenaId = i + 1;
            String state = "\u6e96\u5099\u4e2d";
            String players = "&nbsp;";
            if (matches.containsKey((Object)i)) {
                state = OlympiadGame._gameIsStarted ? "<FONT COLOR=FFFF00>\u5bfe\u6226\u4e2d</FONT>" : "<FONT COLOR=00FF00>\u53d7\u4ed8\u6e08</FONT>";
                players = (String)matches.get((Object)i);
            }
            message.replace((CharSequence)("%state" + arenaId + "%"), state);
            message.replace((CharSequence)("%players" + arenaId + "%"), players);
        }
        player.sendPacket(message);
    }

    public static void bypassChangeArena(String command, L2PcInstance player) {
        if (!player.inObserverMode()) {
            return;
        }
        String[] commands = command.split(" ");
        int id = Integer.parseInt(commands[1]);
        int arena = Olympiad.getSpectatorArena(player);
        if (arena < 0) {
            return;
        }
        Olympiad.removeSpectator(arena, player);
        player.sendPacket(new ExOlympiadMatchEnd());
        Olympiad.addSpectator(id, player, false);
        OlympiadGame game = OlympiadManager.getInstance().getOlympiadGame(id);
        if (game != null) {
            if (game._playerOne == null || !game._playerOne.isInOlympiadMode() || !game._playerOne.isOlympiadStart()) {
                return;
            }
            if (game._playerTwo == null || !game._playerTwo.isInOlympiadMode() || !game._playerTwo.isOlympiadStart()) {
                return;
            }
            player.sendPacket(new ExOlympiadUserInfo(game._playerOne, 1));
            player.sendPacket(new ExOlympiadUserInfo(game._playerTwo, 2));
        }
    }

    static {
        HERO_IDS = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 131, 132, 133, 134};
        COMP_START = Config.ALT_OLY_START_TIME;
        COMP_MIN = Config.ALT_OLY_MIN;
        COMP_PERIOD = Config.ALT_OLY_CPERIOD;
        WEEKLY_PERIOD = Config.ALT_OLY_WPERIOD;
        VALIDATION_PERIOD = Config.ALT_OLY_VPERIOD;
        _compStarted = false;
    }

    private static class SingletonHolder {
        protected static final Olympiad _instance = new Olympiad();

        private SingletonHolder() {
        }
    }

    protected class ValidationEndTask
    implements Runnable {
        protected ValidationEndTask() {
        }

        @Override
        public void run() {
            Announcements.getInstance().announceToAll("\u30aa\u30ea\u30f3\u30d4\u30a2\u30fc\u30c9\u671f\u9593\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
            Olympiad.this._period = 0;
            ++Olympiad.this._currentCycle;
            Olympiad.this.deleteNobles();
            Olympiad.this.setNewOlympiadEnd();
            Olympiad.this.init();
        }
    }

    protected class OlympiadEndTask
    implements Runnable {
        protected OlympiadEndTask() {
        }

        @Override
        public void run() {
            SystemMessage sm = new SystemMessage(SystemMessageId.OLYMPIAD_PERIOD_S1_HAS_ENDED);
            sm.addNumber(Olympiad.this._currentCycle);
            Announcements.getInstance().announceToAll(sm);
            Announcements.getInstance().announceToAll("\u30aa\u30ea\u30f3\u30d4\u30a2\u30fc\u30c9\u671f\u9593\u304c\u59cb\u307e\u308a\u307e\u3057\u305f\u3002");
            if (Olympiad.this._scheduledWeeklyTask != null) {
                Olympiad.this._scheduledWeeklyTask.cancel(true);
            }
            Olympiad.this.saveNobleData();
            Olympiad.this._period = 1;
            Olympiad.this.sortHerosToBe();
            Hero.getInstance().computeNewHeroes(_heroesToBe);
            Olympiad.this.saveOlympiadStatus();
            Olympiad.this.updateMonthlyData();
            Calendar validationEnd = Calendar.getInstance();
            Olympiad.this._validationEnd = validationEnd.getTimeInMillis() + VALIDATION_PERIOD;
            Olympiad.this.loadNoblesRank();
            Olympiad.this._scheduledValdationTask = ThreadPoolManager.getInstance().scheduleGeneral(new ValidationEndTask(), Olympiad.this.getMillisToValidationEnd());
        }
    }

    protected static enum COMP_TYPE {
        CLASSED,
        NON_CLASSED;

    }
}

