/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.quest;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class QuestStateManager {
    protected static final Logger _log = Logger.getLogger(QuestStateManager.class.getName());
    private List<QuestState> _questStates = new FastList();

    private QuestStateManager() {
        ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTimerTask(), 60000L);
    }

    public void addQuestState(Quest quest, L2PcInstance player, byte state) {
        QuestState qs = this.getQuestState(player);
        if (qs == null) {
            qs = new QuestState(quest, player, state);
        }
    }

    public void cleanUp() {
        for (int i = this.getQuestStates().size() - 1; i >= 0; --i) {
            if (this.getQuestStates().get(i).getPlayer() != null) continue;
            this.removeQuestState(this.getQuestStates().get(i));
            this.getQuestStates().remove(i);
        }
    }

    private void removeQuestState(QuestState qs) {
        qs = null;
    }

    public static final QuestStateManager getInstance() {
        return SingletonHolder._instance;
    }

    public QuestState getQuestState(L2PcInstance player) {
        for (QuestState q : this.getQuestStates()) {
            if (q.getPlayer() == null || q.getPlayer().getObjectId() != player.getObjectId()) continue;
            return q;
        }
        return null;
    }

    public List<QuestState> getQuestStates() {
        if (this._questStates == null) {
            this._questStates = new FastList();
        }
        return this._questStates;
    }

    private static class SingletonHolder {
        protected static final QuestStateManager _instance = new QuestStateManager();

        private SingletonHolder() {
        }
    }

    public class ScheduleTimerTask
    implements Runnable {
        @Override
        public void run() {
            try {
                QuestStateManager.this.cleanUp();
                ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTimerTask(), 60000L);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "", e);
            }
        }
    }
}

