/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class L2ArenaZone
extends L2ZoneType {
    private String _arenaName;
    private int[] _spawnLoc = new int[3];

    public L2ArenaZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("name")) {
            this._arenaName = value;
        } else if (name.equals("spawnX")) {
            this._spawnLoc[0] = Integer.parseInt(value);
        } else if (name.equals("spawnY")) {
            this._spawnLoc[1] = Integer.parseInt(value);
        } else if (name.equals("spawnZ")) {
            this._spawnLoc[2] = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        character.setInsideZone((byte)0, true);
        character.setInsideZone((byte)12, true);
        if (character instanceof L2PcInstance && !character.isInsideZone((byte)0)) {
            ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE));
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone((byte)0, false);
        character.setInsideZone((byte)12, false);
        if (character instanceof L2PcInstance && !character.isInsideZone((byte)0)) {
            ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    @Deprecated
    public String getName() {
        return this._arenaName;
    }

    public final int[] getSpawnLoc() {
        return this._spawnLoc;
    }
}

