/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TradeOtherAdd;
import com.l2jserver.gameserver.network.serverpackets.TradeOwnAdd;
import java.util.logging.Logger;

public final class AddTradeItem
extends L2GameClientPacket {
    private static final String _C__16_ADDTRADEITEM = "[C] 16 AddTradeItem";
    private static final Logger _log = Logger.getLogger(AddTradeItem.class.getName());
    private int _tradeId;
    private int _objectId;
    private long _count;

    @Override
    protected void readImpl() {
        this._tradeId = this.readD();
        this._objectId = this.readD();
        this._count = this.readQ();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        TradeList trade = player.getActiveTradeList();
        if (trade == null) {
            _log.warning("Character: " + player.getName() + " requested item:" + this._objectId + " add without active tradelist:" + this._tradeId);
            return;
        }
        L2PcInstance partner = trade.getPartner();
        if (partner == null || L2World.getInstance().findObject(partner.getObjectId()) == null || partner.getActiveTradeList() == null) {
            if (partner != null) {
                _log.warning("Character:" + player.getName() + " requested invalid trade object: " + this._objectId);
            }
            SystemMessage msg = new SystemMessage(SystemMessageId.TARGET_IS_NOT_FOUND_IN_THE_GAME);
            player.sendPacket(msg);
            player.cancelActiveTrade();
            return;
        }
        if (trade.isConfirmed() || partner.getActiveTradeList().isConfirmed()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_ADJUST_ITEMS_AFTER_TRADE_CONFIRMED));
            return;
        }
        if (!player.getAccessLevel().allowTransaction()) {
            player.sendMessage("Transactions are disable for your Access Level");
            player.cancelActiveTrade();
            return;
        }
        if (!player.validateItemManipulation(this._objectId, "trade")) {
            player.sendPacket(new SystemMessage(SystemMessageId.NOTHING_HAPPENED));
            return;
        }
        TradeList.TradeItem item = trade.addItem(this._objectId, this._count);
        if (item != null) {
            player.sendPacket(new TradeOwnAdd(item));
            trade.getPartner().sendPacket(new TradeOtherAdd(item));
        }
    }

    @Override
    public String getType() {
        return _C__16_ADDTRADEITEM;
    }
}

