/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestDestroyItem
extends L2GameClientPacket {
    private static final String _C__59_REQUESTDESTROYITEM = "[C] 59 RequestDestroyItem";
    private static Logger _log = Logger.getLogger(RequestDestroyItem.class.getName());
    private int _objectId;
    private long _count;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._count = this.readQ();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2ItemInstance removedItem;
        InventoryUpdate iu;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (this._count <= 0L) {
            if (this._count < 0L) {
                Util.handleIllegalPlayerAction(activeChar, "[RequestDestroyItem] Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to destroy item with oid " + this._objectId + " but has count < 0!", Config.DEFAULT_PUNISH);
            }
            return;
        }
        if (!activeChar.getFloodProtectors().getTransaction().tryPerformAction("destroy")) {
            activeChar.sendMessage("You destroying items too fast.");
            return;
        }
        long count = this._count;
        if (activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE));
            return;
        }
        L2ItemInstance itemToRemove = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (itemToRemove == null) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (activeChar.isCastingNow() && activeChar.getCurrentSkill() != null && activeChar.getCurrentSkill().getSkill().getItemConsumeId() == itemToRemove.getItemId()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        if (activeChar.isCastingSimultaneouslyNow() && activeChar.getLastSimultaneousSkillCast() != null && activeChar.getLastSimultaneousSkillCast().getItemConsumeId() == itemToRemove.getItemId()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            return;
        }
        int itemId = itemToRemove.getItemId();
        if (itemToRemove.isWear() || !activeChar.isGM() && !itemToRemove.isDestroyable() || CursedWeaponsManager.getInstance().isCursed(itemId)) {
            if (itemToRemove.isHeroItem()) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.HERO_WEAPONS_CANT_DESTROYED));
            } else {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_DISCARD_THIS_ITEM));
            }
            return;
        }
        if (!itemToRemove.isStackable() && count > 1L) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestDestroyItem] Character " + activeChar.getName() + " of account " + activeChar.getAccountName() + " tried to destroy a non-stackable item with oid " + this._objectId + " but has count > 1!", Config.DEFAULT_PUNISH);
            return;
        }
        if (this._count > itemToRemove.getCount()) {
            count = itemToRemove.getCount();
        }
        if (itemToRemove.isEquipped()) {
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(itemToRemove.getLocationSlot());
            iu = new InventoryUpdate();
            for (L2ItemInstance item : unequiped) {
                activeChar.checkSSMatch(null, item);
                iu.addModifiedItem(item);
            }
            activeChar.sendPacket(iu);
            activeChar.broadcastUserInfo();
        }
        if (PetDataTable.isPetItem(itemId)) {
            Connection con = null;
            try {
                if (activeChar.getPet() != null && activeChar.getPet().getControlItemId() == this._objectId) {
                    activeChar.getPet().unSummon(activeChar);
                }
                con = L2DatabaseFactory.getInstance().getConnection();
                PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");
                statement.setInt(1, this._objectId);
                statement.execute();
                statement.close();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "could not delete pet objectid: ", e);
            }
            finally {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
        if (itemToRemove.isTimeLimitedItem()) {
            itemToRemove.endOfLife();
        }
        if ((removedItem = activeChar.getInventory().destroyItem("Destroy", this._objectId, count, activeChar, null)) == null) {
            return;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            iu = new InventoryUpdate();
            if (removedItem.getCount() == 0L) {
                iu.addRemovedItem(removedItem);
            } else {
                iu.addModifiedItem(removedItem);
            }
            activeChar.sendPacket(iu);
        } else {
            this.sendPacket(new ItemList(activeChar, true));
        }
        StatusUpdate su = new StatusUpdate(activeChar.getObjectId());
        su.addAttribute(14, activeChar.getCurrentLoad());
        activeChar.sendPacket(su);
    }

    @Override
    public String getType() {
        return _C__59_REQUESTDESTROYITEM;
    }
}

