/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.datatables.SkillTreeTable;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2ShortCut;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfo;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillInfoDetail;
import com.l2jserver.gameserver.network.serverpackets.ExEnchantSkillResult;
import com.l2jserver.gameserver.network.serverpackets.ShortCutRegister;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.util.Rnd;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class RequestExEnchantSkillRouteChange
extends L2GameClientPacket {
    protected static final Logger _log = Logger.getLogger(RequestExEnchantSkillRouteChange.class.getName());
    private static final Logger _logEnchant = Logger.getLogger("enchant");
    private int _skillId;
    private int _skillLvl;

    @Override
    protected void readImpl() {
        this._skillId = this.readD();
        this._skillLvl = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        if (player.getClassId().level() < 3) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_IN_THIS_CLASS);
            return;
        }
        if (player.getLevel() < 76) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ON_THIS_LEVEL);
            return;
        }
        if (!player.isAllowedToEnchantSkills()) {
            player.sendPacket(SystemMessageId.YOU_CANNOT_USE_SKILL_ENCHANT_ATTACKING_TRANSFORMED_BOAT);
            return;
        }
        L2Skill skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLvl);
        if (skill == null) {
            return;
        }
        int reqItemId = 9626;
        L2EnchantSkillLearn s = SkillTreeTable.getInstance().getSkillEnchantmentBySkillId(this._skillId);
        if (s == null) {
            return;
        }
        int currentLevel = player.getSkillLevel(this._skillId);
        if (currentLevel <= 100) {
            return;
        }
        int currentEnchantLevel = currentLevel % 100;
        if (currentEnchantLevel != this._skillLvl % 100) {
            return;
        }
        L2EnchantSkillLearn.EnchantSkillDetail esd = s.getEnchantSkillDetail(this._skillLvl);
        int requiredSp = esd.getSpCost();
        int requireditems = esd.getAdena();
        if (player.getSp() >= requiredSp) {
            SystemMessage sm;
            L2ItemInstance spb = player.getInventory().getItemByItemId(reqItemId);
            if (Config.ES_SP_BOOK_NEEDED && spb == null) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_DONT_HAVE_ALL_ITENS_NEEDED_TO_CHANGE_SKILL_ENCHANT_ROUTE));
                return;
            }
            if (player.getInventory().getAdena() < (long)requireditems) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL));
                return;
            }
            boolean check = player.getStat().removeExpAndSp(0L, requiredSp, false);
            if (Config.ES_SP_BOOK_NEEDED) {
                check &= player.destroyItem("Consume", spb.getObjectId(), 1L, (L2Object)player, true);
            }
            if (!(check &= player.destroyItemByItemId("Consume", 57, requireditems, player, true))) {
                player.sendPacket(new SystemMessage(SystemMessageId.YOU_DONT_HAVE_ALL_OF_THE_ITEMS_NEEDED_TO_ENCHANT_THAT_SKILL));
                return;
            }
            int levelPenalty = Rnd.get(Math.min(4, currentEnchantLevel));
            this._skillLvl -= levelPenalty;
            if (this._skillLvl % 100 == 0) {
                this._skillLvl = s.getBaseLevel();
            }
            if ((skill = SkillTable.getInstance().getInfo(this._skillId, this._skillLvl)) != null) {
                if (Config.LOG_SKILL_ENCHANTS) {
                    LogRecord record = new LogRecord(Level.INFO, "Route Change");
                    record.setParameters(new Object[]{player, skill, spb});
                    record.setLoggerName("skill");
                    _logEnchant.log(record);
                }
                player.addSkill(skill, true);
                player.sendPacket(new ExEnchantSkillResult(true));
            }
            if (Config.DEBUG) {
                _log.fine("Learned skill ID: " + this._skillId + " Level: " + this._skillLvl + " for " + requiredSp + " SP, " + requireditems + " Adena.");
            }
            player.sendPacket(new UserInfo(player));
            player.sendPacket(new ExBrExtraUserInfo(player));
            if (levelPenalty == 0) {
                sm = new SystemMessage(SystemMessageId.SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WILL_REMAIN);
                sm.addSkillName(this._skillId);
                player.sendPacket(sm);
            } else {
                sm = new SystemMessage(SystemMessageId.SKILL_ENCHANT_CHANGE_SUCCESSFUL_S1_LEVEL_WAS_DECREASED_BY_S2);
                sm.addSkillName(this._skillId);
                sm.addNumber(levelPenalty);
                player.sendPacket(sm);
            }
            player.sendSkillList();
            player.sendPacket(new ExEnchantSkillInfo(this._skillId, player.getSkillLevel(this._skillId)));
            player.sendPacket(new ExEnchantSkillInfoDetail(3, this._skillId, player.getSkillLevel(this._skillId), player));
            this.updateSkillShortcuts(player);
        } else {
            SystemMessage sm = new SystemMessage(SystemMessageId.YOU_DONT_HAVE_ENOUGH_SP_TO_ENCHANT_THAT_SKILL);
            player.sendPacket(sm);
        }
    }

    private void updateSkillShortcuts(L2PcInstance player) {
        L2ShortCut[] allShortCuts;
        for (L2ShortCut sc : allShortCuts = player.getAllShortCuts()) {
            if (sc.getId() != this._skillId || sc.getType() != 2) continue;
            L2ShortCut newsc = new L2ShortCut(sc.getSlot(), sc.getPage(), sc.getType(), sc.getId(), player.getSkillLevel(this._skillId), 1);
            player.sendPacket(new ShortCutRegister(newsc));
            player.registerShortCut(newsc);
        }
    }

    @Override
    public String getType() {
        return "[C] D0:34 RequestExEnchantSkillRouteChange";
    }
}

