/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.FriendPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestFriendDel
extends L2GameClientPacket {
    private static final String _C__61_REQUESTFRIENDDEL = "[C] 61 RequestFriendDel";
    private static Logger _log = Logger.getLogger(RequestFriendDel.class.getName());
    private String _name;

    @Override
    protected void readImpl() {
        this._name = this.readS();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        int id = CharNameTable.getInstance().getIdByName(this._name);
        if (id == -1) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_NOT_ON_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        if (!activeChar.getFriendList().contains(id)) {
            SystemMessage sm = new SystemMessage(SystemMessageId.C1_NOT_ON_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            return;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM character_friends WHERE (charId=? AND friendId=?) OR (charId=? AND friendId=?)");
            statement.setInt(1, activeChar.getObjectId());
            statement.setInt(2, id);
            statement.setInt(3, id);
            statement.setInt(4, activeChar.getObjectId());
            statement.execute();
            statement.close();
            SystemMessage sm = new SystemMessage(SystemMessageId.S1_HAS_BEEN_DELETED_FROM_YOUR_FRIENDS_LIST);
            sm.addString(this._name);
            activeChar.sendPacket(sm);
            activeChar.getFriendList().remove(new Integer(id));
            activeChar.sendPacket(new FriendPacket(false, id));
            L2PcInstance player = L2World.getInstance().getPlayer(this._name);
            if (player != null) {
                player.getFriendList().remove(new Integer(activeChar.getObjectId()));
                player.sendPacket(new FriendPacket(false, activeChar.getObjectId()));
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "could not del friend objectid: ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String getType() {
        return _C__61_REQUESTFRIENDDEL;
    }
}

