/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.RequestBypassToServer;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.logging.Logger;

public final class NpcQuestHtmlMessage
extends L2GameServerPacket {
    private static Logger _log = Logger.getLogger(RequestBypassToServer.class.getName());
    private int _npcObjId;
    private String _html;
    private int _questId = 0;

    public NpcQuestHtmlMessage(int npcObjId, int questId) {
        this._npcObjId = npcObjId;
        this._questId = questId;
    }

    @Override
    public void runImpl() {
        if (Config.BYPASS_VALIDATION) {
            this.buildBypassCache(((L2GameClient)this.getClient()).getActiveChar());
        }
    }

    public void setHtml(String text) {
        if (text.length() > 8192) {
            _log.warning("Html is too long! this will crash the client!");
            this._html = "<html><body>Html was too long</body></html>";
            return;
        }
        this._html = text;
    }

    public boolean setFile(String path) {
        String content = HtmCache.getInstance().getHtm(path);
        if (content == null) {
            this.setHtml("<html><body>My Text is missing:<br>" + path + "</body></html>");
            _log.warning("missing html page " + path);
            return false;
        }
        this.setHtml(content);
        return true;
    }

    public void replace(String pattern, String value) {
        this._html = this._html.replaceAll(pattern, value);
    }

    private final void buildBypassCache(L2PcInstance activeChar) {
        if (activeChar == null) {
            return;
        }
        activeChar.clearBypass();
        int len = this._html.length();
        for (int i = 0; i < len; ++i) {
            int start = this._html.indexOf("bypass -h", i);
            int finish = this._html.indexOf("\"", start);
            if (start < 0 || finish < 0) break;
            i = finish;
            int finish2 = this._html.indexOf("$", start += 10);
            if (finish2 < finish && finish2 > 0) {
                activeChar.addBypass2(this._html.substring(start, finish2).trim());
                continue;
            }
            activeChar.addBypass(this._html.substring(start, finish).trim());
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(254);
        this.writeH(141);
        this.writeD(this._npcObjId);
        this.writeS(this._html);
        this.writeD(this._questId);
    }

    @Override
    public String getType() {
        return "[S] FE:8D NpcQuestHtmlMessage";
    }
}

