/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MerchantInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import java.util.logging.Logger;
import javolution.util.FastList;

public class SellList
extends L2GameServerPacket {
    private static final String _S__10_SELLLIST = "[S] 06 SellList";
    private static Logger _log = Logger.getLogger(SellList.class.getName());
    private final L2PcInstance _activeChar;
    private final L2MerchantInstance _lease;
    private long _money;
    private List<L2ItemInstance> _selllist = new FastList();

    public SellList(L2PcInstance player) {
        this._activeChar = player;
        this._lease = null;
        this._money = this._activeChar.getAdena();
        this.doLease();
    }

    public SellList(L2PcInstance player, L2MerchantInstance lease) {
        this._activeChar = player;
        this._lease = lease;
        this._money = this._activeChar.getAdena();
        this.doLease();
    }

    private void doLease() {
        if (this._lease == null) {
            for (L2ItemInstance item : this._activeChar.getInventory().getItems()) {
                if (item.isEquipped() || !item.isSellable() || this._activeChar.getPet() != null && item.getObjectId() == this._activeChar.getPet().getControlItemId()) continue;
                this._selllist.add(item);
                if (!Config.DEBUG) continue;
                _log.fine("item added to selllist: " + item.getItem().getName());
            }
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(6);
        this.writeQ(this._money);
        this.writeD(this._lease == null ? 0 : 1000000 + this._lease.getTemplate().npcId);
        this.writeH(this._selllist.size());
        for (L2ItemInstance item : this._selllist) {
            this.writeH(item.getItem().getType1());
            this.writeD(item.getObjectId());
            this.writeD(item.getItemId());
            this.writeQ(item.getCount());
            this.writeH(item.getItem().getType2());
            this.writeH(0);
            this.writeD(item.getItem().getBodyPart());
            this.writeH(item.getEnchantLevel());
            this.writeH(0);
            this.writeH(item.getCustomType2());
            this.writeQ(item.getItem().getReferencePrice() / 2);
            this.writeH(item.getAttackElementType());
            this.writeH(item.getAttackElementPower());
            for (byte i = 0; i < 6; i = (byte)(i + 1)) {
                this.writeH(item.getElementDefAttr(i));
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
        }
    }

    @Override
    public String getType() {
        return _S__10_SELLLIST;
    }
}

