/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills;

import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.skills.DocumentBase;
import com.l2jserver.gameserver.skills.conditions.Condition;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import java.io.File;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class DocumentSkill
extends DocumentBase {
    private Skill _currentSkill;
    private List<L2Skill> _skillsInFile = new FastList();

    DocumentSkill(File file) {
        super(file);
    }

    private void setCurrentSkill(Skill skill) {
        this._currentSkill = skill;
    }

    @Override
    protected StatsSet getStatsSet() {
        return this._currentSkill.sets[this._currentSkill.currentLevel];
    }

    protected List<L2Skill> getSkills() {
        return this._skillsInFile;
    }

    @Override
    protected String getTableValue(String name) {
        try {
            return ((String[])this._tables.get(name))[this._currentSkill.currentLevel];
        }
        catch (RuntimeException e) {
            _log.log(Level.SEVERE, "Error in table: " + name + " of Skill Id " + this._currentSkill.id, e);
            return "";
        }
    }

    @Override
    protected String getTableValue(String name, int idx) {
        try {
            return ((String[])this._tables.get(name))[idx - 1];
        }
        catch (RuntimeException e) {
            _log.log(Level.SEVERE, "wrong level count in skill Id " + this._currentSkill.id, e);
            return "";
        }
    }

    @Override
    protected void parseDocument(Document doc) {
        for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
            if ("list".equalsIgnoreCase(n.getNodeName())) {
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"skill".equalsIgnoreCase(d.getNodeName())) continue;
                    this.setCurrentSkill(new Skill());
                    this.parseSkill(d);
                    this._skillsInFile.addAll(this._currentSkill.skills);
                    this.resetTable();
                }
                continue;
            }
            if (!"skill".equalsIgnoreCase(n.getNodeName())) continue;
            this.setCurrentSkill(new Skill());
            this.parseSkill(n);
            this._skillsInFile.addAll(this._currentSkill.skills);
        }
    }

    protected void parseSkill(Node n) {
        Node msg;
        Condition condition;
        int i;
        Node first;
        NamedNodeMap attrs = n.getAttributes();
        int enchantLevels1 = 0;
        int enchantLevels2 = 0;
        int enchantLevels3 = 0;
        int enchantLevels4 = 0;
        int enchantLevels5 = 0;
        int enchantLevels6 = 0;
        int enchantLevels7 = 0;
        int enchantLevels8 = 0;
        int skillId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
        String skillName = attrs.getNamedItem("name").getNodeValue();
        String levels = attrs.getNamedItem("levels").getNodeValue();
        int lastLvl = Integer.parseInt(levels);
        if (attrs.getNamedItem("enchantLevels1") != null) {
            enchantLevels1 = Integer.parseInt(attrs.getNamedItem("enchantLevels1").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels2") != null) {
            enchantLevels2 = Integer.parseInt(attrs.getNamedItem("enchantLevels2").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels3") != null) {
            enchantLevels3 = Integer.parseInt(attrs.getNamedItem("enchantLevels3").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels4") != null) {
            enchantLevels4 = Integer.parseInt(attrs.getNamedItem("enchantLevels4").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels5") != null) {
            enchantLevels5 = Integer.parseInt(attrs.getNamedItem("enchantLevels5").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels6") != null) {
            enchantLevels6 = Integer.parseInt(attrs.getNamedItem("enchantLevels6").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels7") != null) {
            enchantLevels7 = Integer.parseInt(attrs.getNamedItem("enchantLevels7").getNodeValue());
        }
        if (attrs.getNamedItem("enchantLevels8") != null) {
            enchantLevels8 = Integer.parseInt(attrs.getNamedItem("enchantLevels8").getNodeValue());
        }
        this._currentSkill.id = skillId;
        this._currentSkill.name = skillName;
        this._currentSkill.sets = new StatsSet[lastLvl];
        this._currentSkill.enchsets1 = new StatsSet[enchantLevels1];
        this._currentSkill.enchsets2 = new StatsSet[enchantLevels2];
        this._currentSkill.enchsets3 = new StatsSet[enchantLevels3];
        this._currentSkill.enchsets4 = new StatsSet[enchantLevels4];
        this._currentSkill.enchsets5 = new StatsSet[enchantLevels5];
        this._currentSkill.enchsets6 = new StatsSet[enchantLevels6];
        this._currentSkill.enchsets7 = new StatsSet[enchantLevels7];
        this._currentSkill.enchsets8 = new StatsSet[enchantLevels8];
        for (int i2 = 0; i2 < lastLvl; ++i2) {
            this._currentSkill.sets[i2] = new StatsSet();
            this._currentSkill.sets[i2].set("skill_id", this._currentSkill.id);
            this._currentSkill.sets[i2].set("level", i2 + 1);
            this._currentSkill.sets[i2].set("name", this._currentSkill.name);
        }
        if (this._currentSkill.sets.length != lastLvl) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + lastLvl + " levels expected");
        }
        for (n = first = n.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"table".equalsIgnoreCase(n.getNodeName())) continue;
            this.parseTable(n);
        }
        for (i = 1; i <= lastLvl; ++i) {
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.sets[i - 1], i);
            }
        }
        for (i = 0; i < enchantLevels1; ++i) {
            this._currentSkill.enchsets1[i] = new StatsSet();
            this._currentSkill.enchsets1[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets1[i].set("level", i + 101);
            this._currentSkill.enchsets1[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets1[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant1".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets1[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets1.length != enchantLevels1) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels1 + " levels expected");
        }
        for (i = 0; i < enchantLevels2; ++i) {
            this._currentSkill.enchsets2[i] = new StatsSet();
            this._currentSkill.enchsets2[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets2[i].set("level", i + 201);
            this._currentSkill.enchsets2[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets2[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant2".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets2[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets2.length != enchantLevels2) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels2 + " levels expected");
        }
        for (i = 0; i < enchantLevels3; ++i) {
            this._currentSkill.enchsets3[i] = new StatsSet();
            this._currentSkill.enchsets3[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets3[i].set("level", i + 301);
            this._currentSkill.enchsets3[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets3[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant3".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets3[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets3.length != enchantLevels3) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels3 + " levels expected");
        }
        for (i = 0; i < enchantLevels4; ++i) {
            this._currentSkill.enchsets4[i] = new StatsSet();
            this._currentSkill.enchsets4[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets4[i].set("level", i + 401);
            this._currentSkill.enchsets4[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets4[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant4".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets4[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets4.length != enchantLevels4) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels4 + " levels expected");
        }
        for (i = 0; i < enchantLevels5; ++i) {
            this._currentSkill.enchsets5[i] = new StatsSet();
            this._currentSkill.enchsets5[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets5[i].set("level", i + 501);
            this._currentSkill.enchsets5[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets5[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant5".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets5[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets5.length != enchantLevels5) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels5 + " levels expected");
        }
        for (i = 0; i < enchantLevels6; ++i) {
            this._currentSkill.enchsets6[i] = new StatsSet();
            this._currentSkill.enchsets6[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets6[i].set("level", i + 601);
            this._currentSkill.enchsets6[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets6[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant6".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets6[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets6.length != enchantLevels6) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels6 + " levels expected");
        }
        for (i = 0; i < enchantLevels7; ++i) {
            this._currentSkill.enchsets7[i] = new StatsSet();
            this._currentSkill.enchsets7[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets7[i].set("level", i + 701);
            this._currentSkill.enchsets7[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets7[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant7".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets7[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets7.length != enchantLevels7) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels7 + " levels expected");
        }
        for (i = 0; i < enchantLevels8; ++i) {
            this._currentSkill.enchsets8[i] = new StatsSet();
            this._currentSkill.enchsets8[i].set("skill_id", this._currentSkill.id);
            this._currentSkill.enchsets8[i].set("level", i + 801);
            this._currentSkill.enchsets8[i].set("name", this._currentSkill.name);
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"set".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets8[i], this._currentSkill.sets.length);
            }
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!"enchant8".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseBeanSet(n, this._currentSkill.enchsets8[i], i + 1);
            }
        }
        if (this._currentSkill.enchsets8.length != enchantLevels8) {
            throw new RuntimeException("Skill id=" + skillId + " number of levels missmatch, " + enchantLevels8 + " levels expected");
        }
        this.makeSkills();
        for (i = 0; i < lastLvl; ++i) {
            this._currentSkill.currentLevel = i;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("cond".equalsIgnoreCase(n.getNodeName())) {
                    Condition condition2 = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    Node msg2 = n.getAttributes().getNamedItem("msg");
                    Node msgId = n.getAttributes().getNamedItem("msgId");
                    if (condition2 != null && msg2 != null) {
                        condition2.setMessage(msg2.getNodeValue());
                    } else if (condition2 != null && msgId != null) {
                        condition2.setMessageId(Integer.decode(this.getValue(msgId.getNodeValue(), null)));
                        Node addName = n.getAttributes().getNamedItem("addName");
                        if (addName != null && Integer.decode(this.getValue(msgId.getNodeValue(), null)) > 0) {
                            condition2.addName();
                        }
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition2, false);
                    continue;
                }
                if (!"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl; i < lastLvl + enchantLevels1; ++i) {
            this._currentSkill.currentLevel = i - lastLvl;
            boolean foundCond = false;
            boolean foundFor = false;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant1cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant1for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1; i < lastLvl + enchantLevels1 + enchantLevels2; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant2cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant2for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1 + enchantLevels2; i < lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1 - enchantLevels2;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant3cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant3for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3; i < lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1 - enchantLevels2 - enchantLevels3;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant4cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant4for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4; i < lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1 - enchantLevels2 - enchantLevels3 - enchantLevels4;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant5cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant5for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5; i < lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5 + enchantLevels6; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1 - enchantLevels2 - enchantLevels3 - enchantLevels4 - enchantLevels5;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant6cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant6for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5 + enchantLevels6; i < lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5 + enchantLevels6 + enchantLevels7; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1 - enchantLevels2 - enchantLevels3 - enchantLevels4 - enchantLevels5 - enchantLevels6;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant7cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant7for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        for (i = lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5 + enchantLevels6 + enchantLevels7; i < lastLvl + enchantLevels1 + enchantLevels2 + enchantLevels3 + enchantLevels4 + enchantLevels5 + enchantLevels6 + enchantLevels7 + enchantLevels8; ++i) {
            boolean foundCond = false;
            boolean foundFor = false;
            this._currentSkill.currentLevel = i - lastLvl - enchantLevels1 - enchantLevels2 - enchantLevels3 - enchantLevels4 - enchantLevels5 - enchantLevels6 - enchantLevels7;
            for (n = first; n != null; n = n.getNextSibling()) {
                if ("enchant8cond".equalsIgnoreCase(n.getNodeName())) {
                    foundCond = true;
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (!"enchant8for".equalsIgnoreCase(n.getNodeName())) continue;
                foundFor = true;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
            if (foundCond && foundFor) continue;
            this._currentSkill.currentLevel = lastLvl - 1;
            for (n = first; n != null; n = n.getNextSibling()) {
                if (!foundCond && "cond".equalsIgnoreCase(n.getNodeName())) {
                    condition = this.parseCondition(n.getFirstChild(), this._currentSkill.currentSkills.get(i));
                    msg = n.getAttributes().getNamedItem("msg");
                    if (condition != null && msg != null) {
                        condition.setMessage(msg.getNodeValue());
                    }
                    this._currentSkill.currentSkills.get(i).attach(condition, false);
                    continue;
                }
                if (foundFor || !"for".equalsIgnoreCase(n.getNodeName())) continue;
                this.parseTemplate(n, this._currentSkill.currentSkills.get(i));
            }
        }
        this._currentSkill.skills.addAll(this._currentSkill.currentSkills);
    }

    private void makeSkills() {
        int i;
        int count = 0;
        this._currentSkill.currentSkills = new FastList(this._currentSkill.sets.length + this._currentSkill.enchsets1.length + this._currentSkill.enchsets2.length + this._currentSkill.enchsets3.length + this._currentSkill.enchsets4.length + this._currentSkill.enchsets5.length + this._currentSkill.enchsets6.length + this._currentSkill.enchsets7.length + this._currentSkill.enchsets8.length);
        for (int i2 = 0; i2 < this._currentSkill.sets.length; ++i2) {
            try {
                this._currentSkill.currentSkills.add(i2, this._currentSkill.sets[i2].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.sets[i2]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.sets[i2].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.sets[i2]).getDisplayId() + "level" + this._currentSkill.sets[i2].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.sets[i2]).getLevel(), e);
            }
        }
        int _count = count;
        for (i = 0; i < this._currentSkill.enchsets1.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets1[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets1[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets1[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets1[i]).getDisplayId() + " level=" + this._currentSkill.enchsets1[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets1[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets2.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets2[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets2[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets2[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets2[i]).getDisplayId() + " level=" + this._currentSkill.enchsets2[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets2[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets3.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets3[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets3[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets3[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets3[i]).getDisplayId() + " level=" + this._currentSkill.enchsets3[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets3[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets4.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets4[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets4[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets4[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets4[i]).getDisplayId() + " level=" + this._currentSkill.enchsets4[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets4[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets5.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets5[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets5[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets5[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets5[i]).getDisplayId() + " level=" + this._currentSkill.enchsets5[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets5[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets6.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets6[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets6[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets6[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets6[i]).getDisplayId() + " level=" + this._currentSkill.enchsets6[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets6[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets7.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets7[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets7[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets7[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets7[i]).getDisplayId() + " level=" + this._currentSkill.enchsets7[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets7[i]).getLevel(), e);
            }
        }
        _count = count;
        for (i = 0; i < this._currentSkill.enchsets8.length; ++i) {
            try {
                this._currentSkill.currentSkills.add(_count + i, this._currentSkill.enchsets8[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets8[i]));
                ++count;
                continue;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Skill id=" + this._currentSkill.enchsets8[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets8[i]).getDisplayId() + " level=" + this._currentSkill.enchsets8[i].getEnum("skillType", L2SkillType.class).makeSkill(this._currentSkill.enchsets8[i]).getLevel(), e);
            }
        }
    }

    public class Skill {
        public int id;
        public String name;
        public StatsSet[] sets;
        public StatsSet[] enchsets1;
        public StatsSet[] enchsets2;
        public StatsSet[] enchsets3;
        public StatsSet[] enchsets4;
        public StatsSet[] enchsets5;
        public StatsSet[] enchsets6;
        public StatsSet[] enchsets7;
        public StatsSet[] enchsets8;
        public int currentLevel;
        public List<L2Skill> skills = new FastList();
        public List<L2Skill> currentSkills = new FastList();
    }
}

