/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.conditions;

import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.PlayerState;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.conditions.Condition;

public class ConditionPlayerState
extends Condition {
    private final PlayerState _check;
    private final boolean _required;

    public ConditionPlayerState(PlayerState check, boolean required) {
        this._check = check;
        this._required = required;
    }

    @Override
    public boolean testImpl(Env env) {
        switch (this._check) {
            case RESTING: {
                if (env.player instanceof L2PcInstance) {
                    return ((L2PcInstance)env.player).isSitting() == this._required;
                }
                return !this._required;
            }
            case MOVING: {
                return env.player.isMoving() == this._required;
            }
            case RUNNING: {
                return env.player.isMoving() == this._required && env.player.isRunning() == this._required;
            }
            case FLYING: {
                return env.player.isFlying() == this._required;
            }
            case BEHIND: {
                return env.player.isBehindTarget() == this._required;
            }
            case FRONT: {
                return env.player.isInFrontOfTarget() == this._required;
            }
            case CHAOTIC: {
                L2PcInstance player = env.player.getActingPlayer();
                if (player != null) {
                    return player.getKarma() > 0 == this._required;
                }
                return !this._required;
            }
            case OLYMPIAD: {
                L2PcInstance player = env.player.getActingPlayer();
                if (player != null) {
                    return player.isInOlympiadMode() == this._required;
                }
                return !this._required;
            }
        }
        return !this._required;
    }
}

