/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;

public class EffectChameleonRest
extends L2Effect {
    public EffectChameleonRest(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.RELAXING;
    }

    @Override
    public boolean onStart() {
        if (this.getEffected() instanceof L2PcInstance) {
            this.setChameleon(true);
            ((L2PcInstance)this.getEffected()).setSilentMoving(true);
            ((L2PcInstance)this.getEffected()).sitDown();
        } else {
            this.getEffected().getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
        }
        return super.onStart();
    }

    @Override
    public void onExit() {
        this.setChameleon(false);
        if (this.getEffected() instanceof L2PcInstance) {
            ((L2PcInstance)this.getEffected()).setSilentMoving(false);
        }
        super.onExit();
    }

    @Override
    public boolean onActionTime() {
        double manaDam;
        boolean retval = true;
        if (this.getEffected().isDead()) {
            retval = false;
        }
        if (this.getSkill().getSkillType() != L2SkillType.CONT) {
            return false;
        }
        if (this.getEffected() instanceof L2PcInstance && !((L2PcInstance)this.getEffected()).isSitting()) {
            retval = false;
        }
        if ((manaDam = this.calc()) > this.getEffected().getCurrentMp()) {
            this.getEffected().sendPacket(new SystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
            return false;
        }
        if (!retval) {
            this.setChameleon(retval);
        } else {
            this.getEffected().reduceCurrentMp(manaDam);
        }
        return retval;
    }

    private void setChameleon(boolean val) {
        if (this.getEffected() instanceof L2PcInstance) {
            ((L2PcInstance)this.getEffected()).setRelax(val);
        }
    }
}

