/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import java.util.Collection;
import java.util.logging.Logger;

public class KnownListUpdateTaskManager {
    protected static final Logger _log = Logger.getLogger(KnownListUpdateTaskManager.class.getName());
    private static final int FULL_UPDATE_TIMER = 100;
    private Object syncObject = new Object();
    public static boolean updatePass = true;
    public static int _fullUpdateTimer = 100;

    private KnownListUpdateTaskManager() {
        ThreadPoolManager.getInstance().scheduleAi(new KnownListUpdate(), 1000L);
    }

    public static KnownListUpdateTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    public Object getSync() {
        return this.syncObject;
    }

    public void updateRegion(L2WorldRegion region, boolean fullUpdate, boolean forgetObjects) {
        Collection<L2Object> vObj = region.getVisibleObjects().values();
        for (L2Object object : vObj) {
            if (object == null || !object.isVisible()) continue;
            if (forgetObjects) {
                object.getKnownList().forgetObjects(object instanceof L2Playable || Config.GUARD_ATTACK_AGGRO_MOB && object instanceof L2GuardInstance || fullUpdate);
                continue;
            }
            if (object instanceof L2Playable || Config.GUARD_ATTACK_AGGRO_MOB && object instanceof L2GuardInstance || fullUpdate) {
                for (L2WorldRegion regi : region.getSurroundingRegions()) {
                    Collection<L2Object> inrObj = regi.getVisibleObjects().values();
                    for (L2Object l2Object : inrObj) {
                        if (l2Object == object) continue;
                        object.getKnownList().addKnownObject(l2Object);
                    }
                }
                continue;
            }
            if (!(object instanceof L2Character)) continue;
            for (L2WorldRegion regi : region.getSurroundingRegions()) {
                Collection<L2Playable> inrPls = regi.getVisiblePlayable().values();
                if (!regi.isActive().booleanValue()) continue;
                for (L2Playable l2Playable : inrPls) {
                    if (l2Playable == object) continue;
                    object.getKnownList().addKnownObject(l2Playable);
                }
            }
        }
    }

    private static class SingletonHolder {
        protected static final KnownListUpdateTaskManager _instance = new KnownListUpdateTaskManager();

        private SingletonHolder() {
        }
    }

    private class KnownListUpdate
    implements Runnable {
        @Override
        public void run() {
            try {
                L2WorldRegion[][] arr$ = L2World.getInstance().getAllWorldRegions();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    L2WorldRegion[] regions;
                    for (L2WorldRegion r : regions = arr$[i$]) {
                        try {
                            if (!r.isActive().booleanValue()) continue;
                            KnownListUpdateTaskManager.this.updateRegion(r, _fullUpdateTimer == 100, updatePass);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.warning(e.toString());
            }
            boolean bl = updatePass = !updatePass;
            _fullUpdateTimer = _fullUpdateTimer > 0 ? --_fullUpdateTimer : 100;
            ThreadPoolManager.getInstance().scheduleAi(new KnownListUpdate(), Config.KNOWNLIST_UPDATE_INTERVAL);
        }
    }
}

