/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates;

import com.l2jserver.Config;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class StatsSet {
    private static final Logger _log = Logger.getLogger(StatsSet.class.getName());
    private final Map<String, Object> _set = new FastMap();

    public final Map<String, Object> getSet() {
        return this._set;
    }

    public void add(StatsSet newSet) {
        Map<String, Object> newMap = newSet.getSet();
        for (String key : newMap.keySet()) {
            Object value = newMap.get(key);
            this._set.put(key, value);
        }
    }

    public boolean getBool(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Boolean value required, but not specified");
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    public boolean getBool(String name, boolean deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        try {
            return Boolean.parseBoolean((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Boolean value required, but found: " + val);
        }
    }

    public byte getByte(String name, byte deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + val);
        }
    }

    public byte getByte(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Byte value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        try {
            return Byte.parseByte((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Byte value required, but found: " + val);
        }
    }

    public short getShort(String name, short deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + val);
        }
    }

    public short getShort(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Short value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).shortValue();
        }
        try {
            return Short.parseShort((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Short value required, but found: " + val);
        }
    }

    public int getInteger(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public int getInteger(String name, int deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        try {
            return Integer.parseInt((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public int[] getIntegerArray(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            int[] result = new int[]{((Number)val).intValue()};
            return result;
        }
        int c = 0;
        String[] vals = ((String)val).split(";");
        int[] result = new int[vals.length];
        for (String v : vals) {
            try {
                result[c++] = Integer.parseInt(v);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Integer value required, but found: " + val);
            }
        }
        return result;
    }

    public long getLong(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Integer value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public long getLong(String name, int deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).longValue();
        }
        try {
            return Long.parseLong((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Integer value required, but found: " + val);
        }
    }

    public float getFloat(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return (float)Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public float getFloat(String name, float deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).floatValue();
        }
        try {
            return (float)Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public double getDouble(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Float value required, but not specified");
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public double getDouble(String name, float deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (val instanceof Number) {
            return ((Number)val).doubleValue();
        }
        try {
            return Double.parseDouble((String)val);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Float value required, but found: " + val);
        }
    }

    public String getString(String name) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("String value \"" + name + "\" required, but not specified");
        }
        return String.valueOf(val);
    }

    public String getString(String name, String deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        return String.valueOf(val);
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass) {
        Object val = this._set.get(name);
        if (val == null) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + " required, but not specified");
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + "required, but found: " + val);
        }
    }

    public <T extends Enum<T>> T getEnum(String name, Class<T> enumClass, T deflt) {
        Object val = this._set.get(name);
        if (val == null) {
            return deflt;
        }
        if (enumClass.isInstance(val)) {
            return (T)((Enum)val);
        }
        try {
            return Enum.valueOf(enumClass, String.valueOf(val));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Enum value of type " + enumClass.getName() + "required, but found: " + val);
        }
    }

    public void set(String name, String value) {
        this._set.put(name, value);
    }

    public void set(String name, boolean value) {
        this._set.put(name, value);
    }

    public void set(String name, int value) {
        this._set.put(name, value);
    }

    public void safeSet(String name, int value, int min, int max, String reference) {
        if (min <= max && (value < min || value >= max)) {
            if (Config.ASSERT) {
                throw new AssertionError((Object)("Incorrect value: " + value + "for: " + name + "Ref: " + reference));
            }
            _log.log(Level.SEVERE, "Incorrect value: " + value + "for: " + name + "Ref: " + reference);
        }
        this.set(name, value);
    }

    public void set(String name, double value) {
        this._set.put(name, value);
    }

    public void set(String name, long value) {
        this._set.put(name, value);
    }

    public void set(String name, Enum<?> value) {
        this._set.put(name, value);
    }
}

