/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.lib.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GMAudit {
    private static final Logger _log;
    private static final SimpleDateFormat _formatter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void auditGMAction(String gmName, String action, String target, String params) {
        String today = _formatter.format(new Date());
        OutputStreamWriter save = null;
        try {
            File file = new File("log/GMAudit/" + gmName + ".txt");
            save = new FileWriter(file, true);
            String out = today + ">" + gmName + ">" + action + ">" + target + ">" + params + "\r\n";
            save.write(out);
        }
        catch (IOException e) {
            _log.log(Level.SEVERE, "GMAudit for GM " + gmName + " could not be saved: ", e);
        }
        finally {
            try {
                save.close();
            }
            catch (Exception e) {}
        }
    }

    public static void auditGMAction(String gmName, String action, String target) {
        GMAudit.auditGMAction(gmName, action, target, "");
    }

    static {
        new File("log/GMAudit").mkdirs();
        _log = Logger.getLogger(Log.class.getName());
        _formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    }
}

