/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.log;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class EnchantFormatter
extends Formatter {
    private static final String CRLF = "\r\n";
    private SimpleDateFormat dateFmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

    @Override
    public String format(LogRecord record) {
        Object[] params = record.getParameters();
        StringBuilder output = StringUtil.startAppend(30 + record.getMessage().length() + (params == null ? 0 : params.length * 10), "[", this.dateFmt.format(new Date(record.getMillis())), "] ", record.getMessage());
        for (Object p : params) {
            if (p == null) continue;
            StringUtil.append(output, ", ");
            if (p instanceof L2PcInstance) {
                L2PcInstance player = (L2PcInstance)p;
                StringUtil.append(output, "Character:", player.getName(), " [" + player.getObjectId() + "] Account:", player.getAccountName());
                if (player.getClient() == null || player.getClient().isDetached()) continue;
                StringUtil.append(output, " IP:", player.getClient().getConnection().getInetAddress().getHostAddress());
                continue;
            }
            if (p instanceof L2ItemInstance) {
                L2ItemInstance item = (L2ItemInstance)p;
                if (item.getEnchantLevel() > 0) {
                    StringUtil.append(output, "+", String.valueOf(item.getEnchantLevel()), " ");
                }
                StringUtil.append(output, item.getItem().getName(), "(", String.valueOf(item.getCount()), ")");
                StringUtil.append(output, " [", String.valueOf(item.getObjectId()), "]");
                continue;
            }
            if (p instanceof L2Skill) {
                L2Skill skill = (L2Skill)p;
                if (skill.getLevel() > 100) {
                    StringUtil.append(output, "+", String.valueOf(skill.getLevel() % 100), " ");
                }
                StringUtil.append(output, skill.getName(), "(", String.valueOf(skill.getId()), " ", String.valueOf(skill.getLevel()), ")");
                continue;
            }
            StringUtil.append(output, p.toString());
        }
        output.append(CRLF);
        return output.toString();
    }
}

