/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai2;

import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.ai2.AiEventType;
import com.l2jserver.gameserver.ai2.EventHandler;
import java.util.List;
import javolution.util.FastList;

public class EventHandlerSet
implements Comparable<EventHandlerSet> {
    private int _comparatorPrio;
    private long _insertionTime;
    private List<EventHandler> _handlers;
    private AiEventType _eventType;

    public EventHandlerSet(AiEventType event, List<EventHandler> handlers, TaskPriority prio) {
        this._comparatorPrio = (prio.ordinal() + 1) * 3;
        this._handlers = new FastList();
        this._eventType = event;
        for (EventHandler handler : handlers) {
            this.addHandler(handler);
        }
    }

    public EventHandlerSet(EventHandler handler, TaskPriority prio) {
        this._comparatorPrio = (prio.ordinal() + 1) * 3;
        this._handlers = new FastList();
        this._eventType = handler.getEvenType();
        this.addHandler(handler);
    }

    public void addHandler(EventHandler handler) {
        if (handler == null) {
            return;
        }
        int prio = handler.getPriority();
        int index = -1;
        for (EventHandler eventHandler : this._handlers) {
            if (eventHandler.getPriority() > prio) continue;
            index = eventHandler.getPriority();
            break;
        }
        if (index != -1) {
            this._handlers.add(index, handler);
        } else {
            this._handlers.add(handler);
        }
    }

    public void setPrio(TaskPriority prio) {
        this._comparatorPrio = (prio.ordinal() + 1) * 3;
    }

    public void stampInsertionTime() {
        this._insertionTime = System.currentTimeMillis();
    }

    public int getComparatorPriority() {
        return this._comparatorPrio;
    }

    public List<EventHandler> getHandlers() {
        return this._handlers;
    }

    public AiEventType getEventType() {
        return this._eventType;
    }

    @Override
    public int compareTo(EventHandlerSet es) {
        return (int)((System.currentTimeMillis() - this._insertionTime) / 1000L) + this._comparatorPrio - es.getComparatorPriority();
    }

    public String toString() {
        String str = "EventHandlerSet: size:" + this._handlers.size() + " Priority:" + this._comparatorPrio + (this._insertionTime != 0L ? " TimePoints: " + (int)((System.currentTimeMillis() - this._insertionTime) / 1000L) : "");
        for (EventHandler handler : this._handlers) {
            str = str.concat(" - " + handler.toString());
        }
        return str;
    }
}

