/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class PetSkillsTable {
    private static Logger _log = Logger.getLogger(PetSkillsTable.class.getName());
    private FastMap<Integer, Map<Integer, L2PetSkillLearn>> _skillTrees = new FastMap();

    public static PetSkillsTable getInstance() {
        return SingletonHolder._instance;
    }

    public void reload() {
        this._skillTrees.clear();
        this.load();
    }

    private PetSkillsTable() {
        this.load();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        int npcId = 0;
        int count = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            try {
                PreparedStatement statement = con.prepareStatement("SELECT id FROM npc WHERE type IN ('L2Pet','L2BabyPet','L2SiegeSummon') ORDER BY id");
                ResultSet petlist = statement.executeQuery();
                while (petlist.next()) {
                    FastMap map = new FastMap();
                    npcId = petlist.getInt("id");
                    PreparedStatement statement2 = con.prepareStatement("SELECT minLvl, skillId, skillLvl FROM pets_skills where templateId=? ORDER BY skillId, skillLvl");
                    statement2.setInt(1, npcId);
                    ResultSet skilltree = statement2.executeQuery();
                    while (skilltree.next()) {
                        int id = skilltree.getInt("skillId");
                        int lvl = skilltree.getInt("skillLvl");
                        int minLvl = skilltree.getInt("minLvl");
                        L2PetSkillLearn skillLearn = new L2PetSkillLearn(id, lvl, minLvl);
                        map.put(SkillTable.getSkillHashCode(id, lvl + 1), skillLearn);
                    }
                    this._skillTrees.put((Object)npcId, (Object)map);
                    skilltree.close();
                    statement2.close();
                    count += map.size();
                    _log.fine("PetSkillsTable: skill tree for pet " + npcId + " has " + map.size() + " skills");
                }
                petlist.close();
                statement.close();
            }
            catch (Exception e) {
                _log.severe("Error while creating pet skill tree (Pet ID " + npcId + "):" + e);
            }
            _log.config("PetSkillsTable: Loaded " + count + " skills.");
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error while loading pet skills tables ", e);
        }
        finally {
            try {
                con.close();
            }
            catch (Exception e) {}
        }
    }

    public int getAvailableLevel(L2Summon cha, int skillId) {
        int lvl = 0;
        if (!this._skillTrees.containsKey((Object)cha.getNpcId())) {
            return lvl;
        }
        Collection skills = ((Map)this._skillTrees.get((Object)cha.getNpcId())).values();
        for (L2PetSkillLearn temp : skills) {
            if (temp.getId() != skillId) continue;
            if (temp.getLevel() == 0) {
                int maxLvl;
                if (cha.getLevel() < 70) {
                    lvl = cha.getLevel() / 10;
                    if (lvl <= 0) {
                        lvl = 1;
                    }
                } else {
                    lvl = 7 + (cha.getLevel() - 70) / 5;
                }
                if (lvl <= (maxLvl = SkillTable.getInstance().getMaxLevel(temp.getId()))) break;
                lvl = maxLvl;
                break;
            }
            if (temp.getMinLevel() > cha.getLevel() || temp.getLevel() <= lvl) continue;
            lvl = temp.getLevel();
        }
        return lvl;
    }

    public FastList<Integer> getAvailableSkills(L2Summon cha) {
        FastList skillIds = new FastList();
        if (!this._skillTrees.containsKey((Object)cha.getNpcId())) {
            return null;
        }
        Collection skills = ((Map)this._skillTrees.get((Object)cha.getNpcId())).values();
        for (L2PetSkillLearn temp : skills) {
            if (skillIds.contains((Object)temp.getId())) continue;
            skillIds.add((Object)temp.getId());
        }
        return skillIds;
    }

    private static class SingletonHolder {
        protected static final PetSkillsTable _instance = new PetSkillsTable();

        private SingletonHolder() {
        }
    }

    public final class L2PetSkillLearn {
        private final int _id;
        private final int _level;
        private final int _minLevel;

        public L2PetSkillLearn(int id, int lvl, int minLvl) {
            this._id = id;
            this._level = lvl;
            this._minLevel = minLvl;
        }

        public int getId() {
            return this._id;
        }

        public int getLevel() {
            return this._level;
        }

        public int getMinLevel() {
            return this._minLevel;
        }
    }
}

