/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class CombatFlag {
    protected L2PcInstance _player = null;
    public int playerId = 0;
    private L2ItemInstance _item = null;
    private Location _location;
    public L2ItemInstance itemInstance;
    private int _itemId;
    private int _heading;
    private int _fortId;

    public CombatFlag(int fort_id, int x, int y, int z, int heading, int item_id) {
        this._fortId = fort_id;
        this._location = new Location(x, y, z, heading);
        this._heading = heading;
        this._itemId = item_id;
    }

    public synchronized void spawnMe() {
        L2ItemInstance i = ItemTable.getInstance().createItem("Combat", this._itemId, 1L, null, null);
        i.spawnMe(this._location.getX(), this._location.getY(), this._location.getZ());
        this.itemInstance = i;
    }

    public synchronized void unSpawnMe() {
        if (this._player != null) {
            this.dropIt();
        }
        if (this.itemInstance != null) {
            this.itemInstance.decayMe();
        }
    }

    public boolean activate(L2PcInstance player, L2ItemInstance item) {
        if (player.isMounted()) {
            player.sendPacket(new SystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
            return false;
        }
        this._player = player;
        this.playerId = this._player.getObjectId();
        this.itemInstance = null;
        this._item = item;
        this._player.getInventory().equipItemAndRecord(this._item);
        SystemMessage sm = new SystemMessage(SystemMessageId.S1_EQUIPPED);
        sm.addItemName(this._item);
        this._player.sendPacket(sm);
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addItem(this._item);
            this._player.sendPacket(iu);
        } else {
            this._player.sendPacket(new ItemList(this._player, false));
        }
        this._player.broadcastUserInfo();
        this._player.setCombatFlagEquipped(true);
        return true;
    }

    public void dropIt() {
        this._player.setCombatFlagEquipped(false);
        int slot = this._player.getInventory().getSlotFromItem(this._item);
        this._player.getInventory().unEquipItemInBodySlotAndRecord(slot);
        this._player.destroyItem("CombatFlag", this._item, null, true);
        this._item = null;
        this._player.broadcastUserInfo();
        this._player = null;
        this.playerId = 0;
    }
}

