/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.model.FishData;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PenaltyMonsterInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExFishingHpRegen;
import com.l2jserver.gameserver.network.serverpackets.ExFishingStartCombat;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.concurrent.Future;

public class L2Fishing
implements Runnable {
    private L2PcInstance _fisher;
    private int _time;
    private int _stop = 0;
    private int _goodUse = 0;
    private int _anim = 0;
    private int _mode = 0;
    private int _deceptiveMode = 0;
    private Future<?> _fishAiTask;
    private boolean _thinking;
    private int _fishId;
    private int _fishMaxHp;
    private int _fishCurHp;
    private double _regenHp;
    private boolean _isUpperGrade;
    private int _lureType;

    @Override
    public void run() {
        if (this._fisher == null) {
            return;
        }
        if (this._fishCurHp >= this._fishMaxHp * 2) {
            this._fisher.sendPacket(new SystemMessage(SystemMessageId.BAIT_STOLEN_BY_FISH));
            this.doDie(false);
        } else if (this._time <= 0) {
            this._fisher.sendPacket(new SystemMessage(SystemMessageId.FISH_SPIT_THE_HOOK));
            this.doDie(false);
        } else {
            this.aiTask();
        }
    }

    public L2Fishing(L2PcInstance Fisher, FishData fish, boolean isNoob, boolean isUpperGrade) {
        this._fisher = Fisher;
        this._fishCurHp = this._fishMaxHp = fish.getHP();
        this._regenHp = fish.getHpRegen();
        this._fishId = fish.getId();
        this._time = fish.getCombatTime() / 1000;
        this._isUpperGrade = isUpperGrade;
        if (isUpperGrade) {
            this._deceptiveMode = Rnd.get(100) >= 90 ? 1 : 0;
            this._lureType = 2;
        } else {
            this._deceptiveMode = 0;
            this._lureType = isNoob ? 0 : 1;
        }
        this._mode = Rnd.get(100) >= 80 ? 1 : 0;
        ExFishingStartCombat efsc = new ExFishingStartCombat(this._fisher, this._time, this._fishMaxHp, this._mode, this._lureType, this._deceptiveMode);
        this._fisher.broadcastPacket(efsc);
        this._fisher.sendPacket(new SystemMessage(SystemMessageId.GOT_A_BITE));
        if (this._fishAiTask == null) {
            this._fishAiTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(this, 1000L, 1000L);
        }
    }

    public void changeHp(int hp, int pen) {
        this._fishCurHp -= hp;
        if (this._fishCurHp < 0) {
            this._fishCurHp = 0;
        }
        ExFishingHpRegen efhr = new ExFishingHpRegen(this._fisher, this._time, this._fishCurHp, this._mode, this._goodUse, this._anim, pen, this._deceptiveMode);
        this._fisher.broadcastPacket(efhr);
        this._anim = 0;
        if (this._fishCurHp > this._fishMaxHp * 2) {
            this._fishCurHp = this._fishMaxHp * 2;
            this.doDie(false);
            return;
        }
        if (this._fishCurHp == 0) {
            this.doDie(true);
            return;
        }
    }

    public synchronized void doDie(boolean win) {
        if (this._fishAiTask != null) {
            this._fishAiTask.cancel(false);
            this._fishAiTask = null;
        }
        if (this._fisher == null) {
            return;
        }
        if (win) {
            int check = Rnd.get(100);
            if (check <= 5) {
                this.PenaltyMonster();
            } else {
                this._fisher.sendPacket(new SystemMessage(SystemMessageId.YOU_CAUGHT_SOMETHING));
                this._fisher.addItem("Fishing", this._fishId, 1L, null, true);
            }
        }
        this._fisher.endFishing(win);
        this._fisher = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aiTask() {
        if (this._thinking) {
            return;
        }
        this._thinking = true;
        --this._time;
        try {
            if (this._mode == 1) {
                if (this._deceptiveMode == 0) {
                    this._fishCurHp += (int)this._regenHp;
                }
            } else if (this._deceptiveMode == 1) {
                this._fishCurHp += (int)this._regenHp;
            }
            if (this._stop == 0) {
                this._stop = 1;
                int check = Rnd.get(100);
                if (check >= 70) {
                    int n = this._mode = this._mode == 0 ? 1 : 0;
                }
                if (this._isUpperGrade && (check = Rnd.get(100)) >= 90) {
                    this._deceptiveMode = this._deceptiveMode == 0 ? 1 : 0;
                }
            } else {
                --this._stop;
            }
        }
        finally {
            this._thinking = false;
            ExFishingHpRegen efhr = new ExFishingHpRegen(this._fisher, this._time, this._fishCurHp, this._mode, 0, this._anim, 0, this._deceptiveMode);
            if (this._anim != 0) {
                this._fisher.broadcastPacket(efhr);
            } else {
                this._fisher.sendPacket(efhr);
            }
        }
    }

    public void useRealing(int dmg, int pen) {
        this._anim = 2;
        if (Rnd.get(100) > 90) {
            this._fisher.sendPacket(new SystemMessage(SystemMessageId.FISH_RESISTED_ATTEMPT_TO_BRING_IT_IN));
            this._goodUse = 0;
            this.changeHp(0, pen);
            return;
        }
        if (this._fisher == null) {
            return;
        }
        if (this._mode == 1) {
            if (this._deceptiveMode == 0) {
                SystemMessage sm = new SystemMessage(SystemMessageId.REELING_SUCCESFUL_S1_DAMAGE);
                sm.addNumber(dmg);
                this._fisher.sendPacket(sm);
                if (pen == 50) {
                    sm = new SystemMessage(SystemMessageId.REELING_SUCCESSFUL_PENALTY_S1);
                    sm.addNumber(pen);
                    this._fisher.sendPacket(sm);
                }
                this._goodUse = 1;
                this.changeHp(dmg, pen);
            } else {
                SystemMessage sm = new SystemMessage(SystemMessageId.FISH_RESISTED_REELING_S1_HP_REGAINED);
                sm.addNumber(dmg);
                this._fisher.sendPacket(sm);
                this._goodUse = 2;
                this.changeHp(-dmg, pen);
            }
        } else if (this._deceptiveMode == 0) {
            SystemMessage sm = new SystemMessage(SystemMessageId.FISH_RESISTED_REELING_S1_HP_REGAINED);
            sm.addNumber(dmg);
            this._fisher.sendPacket(sm);
            this._goodUse = 2;
            this.changeHp(-dmg, pen);
        } else {
            SystemMessage sm = new SystemMessage(SystemMessageId.REELING_SUCCESFUL_S1_DAMAGE);
            sm.addNumber(dmg);
            this._fisher.sendPacket(sm);
            if (pen == 50) {
                sm = new SystemMessage(SystemMessageId.REELING_SUCCESSFUL_PENALTY_S1);
                sm.addNumber(pen);
                this._fisher.sendPacket(sm);
            }
            this._goodUse = 1;
            this.changeHp(dmg, pen);
        }
    }

    public void usePomping(int dmg, int pen) {
        this._anim = 1;
        if (Rnd.get(100) > 90) {
            this._fisher.sendPacket(new SystemMessage(SystemMessageId.FISH_RESISTED_ATTEMPT_TO_BRING_IT_IN));
            this._goodUse = 0;
            this.changeHp(0, pen);
            return;
        }
        if (this._fisher == null) {
            return;
        }
        if (this._mode == 0) {
            if (this._deceptiveMode == 0) {
                SystemMessage sm = new SystemMessage(SystemMessageId.PUMPING_SUCCESFUL_S1_DAMAGE);
                sm.addNumber(dmg);
                this._fisher.sendPacket(sm);
                if (pen == 50) {
                    sm = new SystemMessage(SystemMessageId.PUMPING_SUCCESSFUL_PENALTY_S1);
                    sm.addNumber(pen);
                    this._fisher.sendPacket(sm);
                }
                this._goodUse = 1;
                this.changeHp(dmg, pen);
            } else {
                SystemMessage sm = new SystemMessage(SystemMessageId.FISH_RESISTED_PUMPING_S1_HP_REGAINED);
                sm.addNumber(dmg);
                this._fisher.sendPacket(sm);
                this._goodUse = 2;
                this.changeHp(-dmg, pen);
            }
        } else if (this._deceptiveMode == 0) {
            SystemMessage sm = new SystemMessage(SystemMessageId.FISH_RESISTED_PUMPING_S1_HP_REGAINED);
            sm.addNumber(dmg);
            this._fisher.sendPacket(sm);
            this._goodUse = 2;
            this.changeHp(-dmg, pen);
        } else {
            SystemMessage sm = new SystemMessage(SystemMessageId.PUMPING_SUCCESFUL_S1_DAMAGE);
            sm.addNumber(dmg);
            this._fisher.sendPacket(sm);
            if (pen == 50) {
                sm = new SystemMessage(SystemMessageId.PUMPING_SUCCESSFUL_PENALTY_S1);
                sm.addNumber(pen);
                this._fisher.sendPacket(sm);
            }
            this._goodUse = 1;
            this.changeHp(dmg, pen);
        }
    }

    private void PenaltyMonster() {
        int npcid;
        int lvl = (int)Math.round((double)this._fisher.getLevel() * 0.1);
        this._fisher.sendPacket(new SystemMessage(SystemMessageId.YOU_CAUGHT_SOMETHING_SMELLY_THROW_IT_BACK));
        switch (lvl) {
            case 0: 
            case 1: {
                npcid = 18319;
                break;
            }
            case 2: {
                npcid = 18320;
                break;
            }
            case 3: {
                npcid = 18321;
                break;
            }
            case 4: {
                npcid = 18322;
                break;
            }
            case 5: {
                npcid = 18323;
                break;
            }
            case 6: {
                npcid = 18324;
                break;
            }
            case 7: {
                npcid = 18325;
                break;
            }
            case 8: 
            case 9: {
                npcid = 18326;
                break;
            }
            default: {
                npcid = 18319;
            }
        }
        L2NpcTemplate temp = NpcTable.getInstance().getTemplate(npcid);
        if (temp != null) {
            try {
                L2Spawn spawn = new L2Spawn(temp);
                spawn.setLocx(this._fisher.getX());
                spawn.setLocy(this._fisher.getY());
                spawn.setLocz(this._fisher.getZ() + 20);
                spawn.setAmount(1);
                spawn.setHeading(this._fisher.getHeading());
                spawn.stopRespawn();
                ((L2PenaltyMonsterInstance)spawn.doSpawn().scheduleDespawn(180000L)).setPlayerToKill(this._fisher);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }
}

