/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.templates.item.L2Item;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.LineNumberReader;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class L2Manor {
    private static Logger _log = Logger.getLogger(L2Manor.class.getName());
    private static FastMap<Integer, SeedData> _seeds;

    private L2Manor() {
        _seeds = new FastMap().setShared(true);
        this.parseData();
    }

    public static L2Manor getInstance() {
        return SingletonHolder._instance;
    }

    public FastList<Integer> getAllCrops() {
        FastList crops = new FastList();
        for (SeedData seed : _seeds.values()) {
            if (crops.contains((Object)seed.getCrop()) || seed.getCrop() == 0 || crops.contains((Object)seed.getCrop())) continue;
            crops.add((Object)seed.getCrop());
        }
        return crops;
    }

    public int getSeedBasicPrice(int seedId) {
        L2Item seedItem = ItemTable.getInstance().getTemplate(seedId);
        if (seedItem != null) {
            return seedItem.getReferencePrice();
        }
        return 0;
    }

    public int getSeedBasicPriceByCrop(int cropId) {
        for (SeedData seed : _seeds.values()) {
            if (seed.getCrop() != cropId) continue;
            return this.getSeedBasicPrice(seed.getId());
        }
        return 0;
    }

    public int getCropBasicPrice(int cropId) {
        L2Item cropItem = ItemTable.getInstance().getTemplate(cropId);
        if (cropItem != null) {
            return cropItem.getReferencePrice();
        }
        return 0;
    }

    public int getMatureCrop(int cropId) {
        for (SeedData seed : _seeds.values()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getMature();
        }
        return 0;
    }

    public long getSeedBuyPrice(int seedId) {
        long buyPrice = this.getSeedBasicPrice(seedId);
        return buyPrice > 0L ? buyPrice : 1L;
    }

    public int getSeedMinLevel(int seedId) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getLevel() - 5;
        }
        return -1;
    }

    public int getSeedMaxLevel(int seedId) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getLevel() + 5;
        }
        return -1;
    }

    public int getSeedLevelByCrop(int cropId) {
        for (SeedData seed : _seeds.values()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getLevel();
        }
        return 0;
    }

    public int getSeedLevel(int seedId) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getLevel();
        }
        return -1;
    }

    public boolean isAlternative(int seedId) {
        for (SeedData seed : _seeds.values()) {
            if (seed.getId() != seedId) continue;
            return seed.isAlternative();
        }
        return false;
    }

    public int getCropType(int seedId) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getCrop();
        }
        return -1;
    }

    public synchronized int getRewardItem(int cropId, int type) {
        for (SeedData seed : _seeds.values()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getReward(type);
        }
        return -1;
    }

    public synchronized int getRewardItemBySeed(int seedId, int type) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getReward(type);
        }
        return 0;
    }

    public FastList<Integer> getCropsForCastle(int castleId) {
        FastList crops = new FastList();
        for (SeedData seed : _seeds.values()) {
            if (seed.getManorId() != castleId || crops.contains((Object)seed.getCrop())) continue;
            crops.add((Object)seed.getCrop());
        }
        return crops;
    }

    public FastList<Integer> getSeedsForCastle(int castleId) {
        FastList seedsID = new FastList();
        for (SeedData seed : _seeds.values()) {
            if (seed.getManorId() != castleId || seedsID.contains((Object)seed.getId())) continue;
            seedsID.add((Object)seed.getId());
        }
        return seedsID;
    }

    public int getCastleIdForSeed(int seedId) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getManorId();
        }
        return 0;
    }

    public int getSeedSaleLimit(int seedId) {
        SeedData seed = (SeedData)_seeds.get((Object)seedId);
        if (seed != null) {
            return seed.getSeedLimit();
        }
        return 0;
    }

    public int getCropPuchaseLimit(int cropId) {
        for (SeedData seed : _seeds.values()) {
            if (seed.getCrop() != cropId) continue;
            return seed.getCropLimit();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseData() {
        BufferedReader lnr = null;
        try {
            File seedData = new File(Config.DATAPACK_ROOT, "data/seeds.csv");
            lnr = new LineNumberReader(new BufferedReader(new FileReader(seedData)));
            String line = null;
            while ((line = ((LineNumberReader)lnr).readLine()) != null) {
                if (line.trim().length() == 0 || line.startsWith("#")) continue;
                SeedData seed = this.parseList(line);
                _seeds.put((Object)seed.getId(), (Object)seed);
            }
            _log.info("ManorManager: Loaded " + _seeds.size() + " seeds");
        }
        catch (FileNotFoundException e) {
            _log.info("seeds.csv is missing in data folder");
        }
        catch (Exception e) {
            _log.info("error while loading seeds: " + e.getMessage());
        }
        finally {
            try {
                lnr.close();
            }
            catch (Exception e1) {}
        }
    }

    private SeedData parseList(String line) {
        StringTokenizer st = new StringTokenizer(line, ";");
        int seedId = Integer.parseInt(st.nextToken());
        int level = Integer.parseInt(st.nextToken());
        int cropId = Integer.parseInt(st.nextToken());
        int matureId = Integer.parseInt(st.nextToken());
        int type1R = Integer.parseInt(st.nextToken());
        int type2R = Integer.parseInt(st.nextToken());
        int manorId = Integer.parseInt(st.nextToken());
        int isAlt = Integer.parseInt(st.nextToken());
        int limitSeeds = Integer.parseInt(st.nextToken());
        int limitCrops = Integer.parseInt(st.nextToken());
        SeedData seed = new SeedData(level, cropId, matureId);
        seed.setData(seedId, type1R, type2R, manorId, isAlt, limitSeeds, limitCrops);
        return seed;
    }

    private static class SingletonHolder {
        protected static final L2Manor _instance = new L2Manor();

        private SingletonHolder() {
        }
    }

    private class SeedData {
        private int _id;
        private int _level;
        private int _crop;
        private int _mature;
        private int _type1;
        private int _type2;
        private int _manorId;
        private int _isAlternative;
        private int _limitSeeds;
        private int _limitCrops;

        public SeedData(int level, int crop, int mature) {
            this._level = level;
            this._crop = crop;
            this._mature = mature;
        }

        public void setData(int id, int t1, int t2, int manorId, int isAlt, int lim1, int lim2) {
            this._id = id;
            this._type1 = t1;
            this._type2 = t2;
            this._manorId = manorId;
            this._isAlternative = isAlt;
            this._limitSeeds = lim1;
            this._limitCrops = lim2;
        }

        public int getManorId() {
            return this._manorId;
        }

        public int getId() {
            return this._id;
        }

        public int getCrop() {
            return this._crop;
        }

        public int getMature() {
            return this._mature;
        }

        public int getReward(int type) {
            return type == 1 ? this._type1 : this._type2;
        }

        public int getLevel() {
            return this._level;
        }

        public boolean isAlternative() {
            return this._isAlternative == 1;
        }

        public int getSeedLimit() {
            return this._limitSeeds * Config.RATE_DROP_MANOR;
        }

        public int getCropLimit() {
            return this._limitCrops * Config.RATE_DROP_MANOR;
        }
    }
}

