/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.PetSkillsTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import javolution.util.FastList;

public final class L2BabyPetInstance
extends L2PetInstance {
    protected static final int BUFF_CONTROL = 5771;
    protected FastList<Integer> _buffs = null;
    protected int _majorHeal = 0;
    protected int _minorHeal = 0;
    protected int _recharge = 0;
    private Future<?> _castTask;
    protected long _buffControlTimestamp = 0L;

    public L2BabyPetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        super(objectId, template, owner, control);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        Iterator i$ = PetSkillsTable.getInstance().getAvailableSkills(this).iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            double healPower = 0.0;
            L2Skill skill = SkillTable.getInstance().getInfo(id, PetSkillsTable.getInstance().getAvailableLevel(this, id));
            if (skill == null || skill.getId() == 5771) continue;
            switch (skill.getSkillType()) {
                case HEAL: {
                    if (healPower == 0.0) {
                        this._majorHeal = id;
                        this._minorHeal = id;
                        healPower = skill.getPower();
                        break;
                    }
                    if (skill.getPower() > healPower) {
                        this._majorHeal = id;
                        break;
                    }
                    this._minorHeal = id;
                    break;
                }
                case BUFF: {
                    if (this._buffs == null) {
                        this._buffs = new FastList();
                    }
                    this._buffs.add((Object)id);
                    break;
                }
                case MANAHEAL: 
                case MANARECHARGE: {
                    this._recharge = id;
                }
            }
        }
        this.startCastTask();
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.stopCastTask();
        this.abortCast();
        return true;
    }

    @Override
    public synchronized void unSummon(L2PcInstance owner) {
        this.stopCastTask();
        this.abortCast();
        super.unSummon(owner);
    }

    @Override
    public void doRevive() {
        super.doRevive();
        this.startCastTask();
    }

    @Override
    public void onDecay() {
        super.onDecay();
        if (this._buffs != null) {
            this._buffs.clear();
        }
    }

    private final void startCastTask() {
        if (!(this._majorHeal <= 0 && this._buffs == null && this._recharge <= 0 || this._castTask != null || this.isDead())) {
            this._castTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new CastTask(this), 3000L, 1000L);
        }
    }

    private final void stopCastTask() {
        if (this._castTask != null) {
            this._castTask.cancel(false);
            this._castTask = null;
        }
    }

    protected void castSkill(L2Skill skill) {
        boolean previousFollowStatus = this.getFollowStatus();
        if (!previousFollowStatus && !this.isInsideRadius(this.getOwner(), skill.getCastRange(), true, true)) {
            return;
        }
        this.useMagic(skill, false, false);
        SystemMessage msg = new SystemMessage(SystemMessageId.PET_USES_S1);
        msg.addSkillName(skill);
        this.getOwner().sendPacket(msg);
        if (previousFollowStatus != this.getFollowStatus()) {
            this.setFollowStatus(previousFollowStatus);
        }
    }

    private class CastTask
    implements Runnable {
        private final L2BabyPetInstance _baby;
        private List<L2Skill> _currentBuffs = new FastList();

        public CastTask(L2BabyPetInstance baby) {
            this._baby = baby;
        }

        @Override
        public void run() {
            L2PcInstance owner = this._baby.getOwner();
            if (!(owner == null || owner.isDead() || owner.isInvul() || this._baby.isCastingNow() || this._baby.isBetrayed() || this._baby.isMuted() || this._baby.getAI().getIntention() == CtrlIntention.AI_INTENTION_CAST)) {
                L2Skill skill = null;
                if (L2BabyPetInstance.this._majorHeal > 0) {
                    double hpPercent = owner.getCurrentHp() / (double)owner.getMaxHp();
                    if (hpPercent < 0.15 && !this._baby.isSkillDisabled(L2BabyPetInstance.this._majorHeal) && Rnd.get(100) <= 75) {
                        skill = SkillTable.getInstance().getInfo(L2BabyPetInstance.this._majorHeal, PetSkillsTable.getInstance().getAvailableLevel(this._baby, L2BabyPetInstance.this._majorHeal));
                    } else if (hpPercent < 0.8 && !this._baby.isSkillDisabled(L2BabyPetInstance.this._minorHeal) && Rnd.get(100) <= 25) {
                        skill = SkillTable.getInstance().getInfo(L2BabyPetInstance.this._minorHeal, PetSkillsTable.getInstance().getAvailableLevel(this._baby, L2BabyPetInstance.this._minorHeal));
                    }
                    if (skill != null && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                        L2BabyPetInstance.this.castSkill(skill);
                        return;
                    }
                }
                if (!this._baby.isSkillDisabled(5771)) {
                    if (L2BabyPetInstance.this._buffs != null && !L2BabyPetInstance.this._buffs.isEmpty()) {
                        Iterator i$ = L2BabyPetInstance.this._buffs.iterator();
                        while (i$.hasNext()) {
                            int id = (Integer)i$.next();
                            if (this._baby.isSkillDisabled(id) || (skill = SkillTable.getInstance().getInfo(id, PetSkillsTable.getInstance().getAvailableLevel(this._baby, id))) == null || !(this._baby.getCurrentMp() >= (double)skill.getMpConsume())) continue;
                            this._currentBuffs.add(skill);
                        }
                    }
                    if (!this._currentBuffs.isEmpty()) {
                        L2Effect[] effects;
                        for (L2Effect e : effects = owner.getAllEffects()) {
                            L2Skill currentSkill;
                            if (e == null || (currentSkill = e.getSkill()).isDebuff() || currentSkill.isPassive() || currentSkill.isToggle()) continue;
                            Iterator<L2Skill> iter = this._currentBuffs.iterator();
                            while (iter.hasNext()) {
                                skill = iter.next();
                                if (currentSkill.getId() == skill.getId() && currentSkill.getLevel() >= skill.getLevel()) {
                                    iter.remove();
                                    continue;
                                }
                                if (!skill.hasEffects() || "none".equals(skill.getEffectTemplates()[0].stackType) || !e.getStackType().equals(skill.getEffectTemplates()[0].stackType) || !(e.getStackOrder() >= skill.getEffectTemplates()[0].stackOrder)) continue;
                                iter.remove();
                            }
                            if (this._currentBuffs.isEmpty()) break;
                        }
                        if (!this._currentBuffs.isEmpty()) {
                            L2BabyPetInstance.this.castSkill(this._currentBuffs.get(Rnd.get(this._currentBuffs.size())));
                            this._currentBuffs.clear();
                            return;
                        }
                    }
                }
                if (L2BabyPetInstance.this._recharge > 0 && !this._baby.isSkillDisabled(L2BabyPetInstance.this._recharge) && owner.getCurrentMp() / (double)owner.getMaxMp() < 0.7 && owner.isInCombat() && Rnd.get(100) <= 60 && (skill = SkillTable.getInstance().getInfo(L2BabyPetInstance.this._recharge, PetSkillsTable.getInstance().getAvailableLevel(this._baby, L2BabyPetInstance.this._recharge))) != null && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                    L2BabyPetInstance.this.castSkill(skill);
                    return;
                }
            }
        }
    }
}

